/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.expression;

import com.google.common.base.Verify;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.base.expression.AggregateFunctionPatterns;
import io.trino.plugin.base.expression.AggregateFunctionRule;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcExpression;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.expression.Variable;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.VarcharType;
import java.util.Objects;
import java.util.Optional;

public class ImplementCountDistinct
implements AggregateFunctionRule<JdbcExpression> {
    private static final Capture<Variable> INPUT = Capture.newCapture();
    private final JdbcTypeHandle bigintTypeHandle;
    private final boolean isRemoteCollationSensitive;

    public ImplementCountDistinct(JdbcTypeHandle bigintTypeHandle, boolean isRemoteCollationSensitive) {
        this.bigintTypeHandle = Objects.requireNonNull(bigintTypeHandle, "bigintTypeHandle is null");
        this.isRemoteCollationSensitive = isRemoteCollationSensitive;
    }

    public Pattern<AggregateFunction> getPattern() {
        return Pattern.typeOf(AggregateFunction.class).with(AggregateFunctionPatterns.distinct().equalTo((Object)true)).with(AggregateFunctionPatterns.hasFilter().equalTo((Object)false)).with(AggregateFunctionPatterns.functionName().equalTo((Object)"count")).with(AggregateFunctionPatterns.singleInput().matching(AggregateFunctionPatterns.variable().capturedAs(INPUT)));
    }

    public Optional<JdbcExpression> rewrite(AggregateFunction aggregateFunction, Captures captures, AggregateFunctionRule.RewriteContext context) {
        boolean isCaseSensitiveType;
        Variable input = (Variable)captures.get(INPUT);
        JdbcColumnHandle columnHandle = (JdbcColumnHandle)context.getAssignment(input.getName());
        Verify.verify((aggregateFunction.getOutputType() == BigintType.BIGINT ? 1 : 0) != 0);
        boolean bl = isCaseSensitiveType = columnHandle.getColumnType() instanceof CharType || columnHandle.getColumnType() instanceof VarcharType;
        if (aggregateFunction.isDistinct() && !this.isRemoteCollationSensitive && isCaseSensitiveType) {
            return Optional.empty();
        }
        return Optional.of(new JdbcExpression(String.format("count(DISTINCT %s)", context.getIdentifierQuote().apply(columnHandle.getColumnName())), this.bigintTypeHandle));
    }
}

