/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.phoenix5;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.jdbc.BaseJdbcClient;
import io.trino.plugin.jdbc.BooleanWriteFunction;
import io.trino.plugin.jdbc.ColumnMapping;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DecimalConfig;
import io.trino.plugin.jdbc.DecimalSessionSessionProperties;
import io.trino.plugin.jdbc.DoubleWriteFunction;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcOutputTableHandle;
import io.trino.plugin.jdbc.JdbcSortItem;
import io.trino.plugin.jdbc.JdbcSplit;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.LongWriteFunction;
import io.trino.plugin.jdbc.ObjectReadFunction;
import io.trino.plugin.jdbc.ObjectWriteFunction;
import io.trino.plugin.jdbc.PreparedQuery;
import io.trino.plugin.jdbc.QueryBuilder;
import io.trino.plugin.jdbc.SliceWriteFunction;
import io.trino.plugin.jdbc.StandardColumnMappings;
import io.trino.plugin.jdbc.TypeHandlingJdbcSessionProperties;
import io.trino.plugin.jdbc.UnsupportedTypeHandling;
import io.trino.plugin.jdbc.WriteFunction;
import io.trino.plugin.jdbc.WriteMapping;
import io.trino.plugin.jdbc.mapping.IdentifierMapping;
import io.trino.plugin.phoenix5.MetadataUtil;
import io.trino.plugin.phoenix5.PhoenixClientModule;
import io.trino.plugin.phoenix5.PhoenixColumnProperties;
import io.trino.plugin.phoenix5.PhoenixConfig;
import io.trino.plugin.phoenix5.PhoenixErrorCode;
import io.trino.plugin.phoenix5.PhoenixOutputTableHandle;
import io.trino.plugin.phoenix5.PhoenixSplit;
import io.trino.plugin.phoenix5.PhoenixTableProperties;
import io.trino.plugin.phoenix5.TypeUtils;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.math.RoundingMode;
import java.sql.Array;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.iterate.ConcatResultIterator;
import org.apache.phoenix.iterate.LookAheadResultIterator;
import org.apache.phoenix.iterate.MapReduceParallelScanGrouper;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.iterate.RoundRobinResultIterator;
import org.apache.phoenix.iterate.SequenceResultIterator;
import org.apache.phoenix.iterate.TableResultIterator;
import org.apache.phoenix.jdbc.DelegatePreparedStatement;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.log.LogLevel;
import org.apache.phoenix.mapreduce.PhoenixInputSplit;
import org.apache.phoenix.monitoring.ReadMetricQueue;
import org.apache.phoenix.monitoring.ScanMetricsHolder;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.HBaseFactoryProvider;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.TableProperty;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.SchemaUtil;

public class PhoenixClient
extends BaseJdbcClient {
    private static final String ROWKEY = "ROWKEY";
    private final Configuration configuration = new Configuration(false);

    @Inject
    public PhoenixClient(PhoenixConfig config, ConnectionFactory connectionFactory, IdentifierMapping identifierMapping) throws SQLException {
        super("\"", connectionFactory, (Set)ImmutableSet.of(), identifierMapping);
        PhoenixClientModule.getConnectionProperties(config).forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.configuration.set((String)k, (String)v)));
    }

    public java.sql.Connection getConnection(ConnectorSession session) throws SQLException {
        return this.connectionFactory.openConnection(session);
    }

    public Connection getHConnection() throws IOException {
        return HBaseFactoryProvider.getHConnectionFactory().createConnection(this.configuration);
    }

    public void execute(ConnectorSession session, String statement) {
        super.execute(session, statement);
    }

    public Collection<String> listSchemas(java.sql.Connection connection) {
        ImmutableSet immutableSet;
        block9: {
            ResultSet resultSet = connection.getMetaData().getSchemas();
            try {
                ImmutableSet.Builder schemaNames = ImmutableSet.builder();
                schemaNames.add((Object)"default");
                while (resultSet.next()) {
                    String schemaName = this.getTableSchemaName(resultSet);
                    if (!this.filterSchema(schemaName)) continue;
                    schemaNames.add((Object)schemaName);
                }
                immutableSet = schemaNames.build();
                if (resultSet == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new TrinoException((ErrorCodeSupplier)PhoenixErrorCode.PHOENIX_METADATA_ERROR, (Throwable)e);
                }
            }
            resultSet.close();
        }
        return immutableSet;
    }

    public PreparedStatement buildSql(ConnectorSession session, java.sql.Connection connection, JdbcSplit split, JdbcTableHandle table, List<JdbcColumnHandle> columnHandles) throws SQLException {
        PreparedStatement query = this.prepareStatement(session, connection, table, columnHandles, Optional.of(split));
        QueryPlan queryPlan = this.getQueryPlan((PhoenixPreparedStatement)query);
        final ResultSet resultSet = PhoenixClient.getResultSet(((PhoenixSplit)split).getPhoenixInputSplit(), queryPlan);
        return new DelegatePreparedStatement(query){

            public ResultSet executeQuery() {
                return resultSet;
            }
        };
    }

    public PreparedStatement prepareStatement(ConnectorSession session, java.sql.Connection connection, JdbcTableHandle table, List<JdbcColumnHandle> columns, Optional<JdbcSplit> split) throws SQLException {
        PreparedQuery preparedQuery = this.prepareQuery(session, connection, table, Optional.empty(), columns, (Map)ImmutableMap.of(), split);
        return new QueryBuilder((JdbcClient)this).prepareStatement(session, connection, preparedQuery);
    }

    public boolean supportsTopN(ConnectorSession session, JdbcTableHandle handle, List<JdbcSortItem> sortOrder) {
        return true;
    }

    protected Optional<BaseJdbcClient.TopNFunction> topNFunction() {
        return Optional.of(BaseJdbcClient.TopNFunction.sqlStandard(arg_0 -> ((PhoenixClient)this).quoted(arg_0)));
    }

    public boolean isTopNGuaranteed(ConnectorSession session) {
        return false;
    }

    protected Optional<BiFunction<String, Long, String>> limitFunction() {
        return Optional.of((sql, limit) -> sql + " LIMIT " + limit);
    }

    public boolean isLimitGuaranteed(ConnectorSession session) {
        return false;
    }

    public String buildInsertSql(JdbcOutputTableHandle handle, List<WriteFunction> columnWriters) {
        PhoenixOutputTableHandle outputHandle = (PhoenixOutputTableHandle)handle;
        Object params = columnWriters.stream().map(WriteFunction::getBindExpression).collect(Collectors.joining(","));
        Object columns = handle.getColumnNames().stream().map(SchemaUtil::getEscapedArgument).collect(Collectors.joining(","));
        if (outputHandle.rowkeyColumn().isPresent()) {
            String nextId = String.format("NEXT VALUE FOR %s, ", this.quoted(null, handle.getSchemaName(), handle.getTableName() + "_sequence"));
            params = nextId + (String)params;
            columns = outputHandle.rowkeyColumn().get() + ", " + (String)columns;
        }
        return String.format("UPSERT INTO %s (%s) VALUES (%s)", this.quoted(null, handle.getSchemaName(), handle.getTableName()), columns, params);
    }

    public ResultSet getTables(java.sql.Connection connection, Optional<String> schemaName, Optional<String> tableName) throws SQLException {
        return super.getTables(connection, schemaName.map(MetadataUtil::toPhoenixSchemaName), tableName);
    }

    protected String getTableSchemaName(ResultSet resultSet) throws SQLException {
        return (String)MoreObjects.firstNonNull((Object)resultSet.getString("TABLE_SCHEM"), (Object)"default");
    }

    public Optional<ColumnMapping> toColumnMapping(ConnectorSession session, java.sql.Connection connection, JdbcTypeHandle typeHandle) {
        Optional mapping = this.getForcedMappingToVarchar(typeHandle);
        if (mapping.isPresent()) {
            return mapping;
        }
        switch (typeHandle.getJdbcType()) {
            case 16: {
                return Optional.of(StandardColumnMappings.booleanColumnMapping());
            }
            case -6: {
                return Optional.of(StandardColumnMappings.tinyintColumnMapping());
            }
            case 5: {
                return Optional.of(StandardColumnMappings.smallintColumnMapping());
            }
            case 4: {
                return Optional.of(StandardColumnMappings.integerColumnMapping());
            }
            case -5: {
                return Optional.of(StandardColumnMappings.bigintColumnMapping());
            }
            case 6: {
                return Optional.of(StandardColumnMappings.realColumnMapping());
            }
            case 8: {
                return Optional.of(StandardColumnMappings.doubleColumnMapping());
            }
            case 3: {
                Optional columnSize = typeHandle.getColumnSize();
                int precision = columnSize.orElse(38);
                int decimalDigits = typeHandle.getDecimalDigits().orElse(0);
                if (DecimalSessionSessionProperties.getDecimalRounding((ConnectorSession)session) == DecimalConfig.DecimalMapping.ALLOW_OVERFLOW && columnSize.isEmpty()) {
                    return Optional.of(StandardColumnMappings.decimalColumnMapping((DecimalType)DecimalType.createDecimalType((int)38, (int)DecimalSessionSessionProperties.getDecimalDefaultScale((ConnectorSession)session)), (RoundingMode)DecimalSessionSessionProperties.getDecimalRoundingMode((ConnectorSession)session)));
                }
                if ((precision += Math.max(-decimalDigits, 0)) > 38) break;
                return Optional.of(StandardColumnMappings.decimalColumnMapping((DecimalType)DecimalType.createDecimalType((int)precision, (int)Math.max(decimalDigits, 0)), (RoundingMode)RoundingMode.UNNECESSARY));
            }
            case 1: {
                return Optional.of(StandardColumnMappings.defaultCharColumnMapping((int)typeHandle.getRequiredColumnSize(), (boolean)true));
            }
            case -16: 
            case -9: 
            case -1: 
            case 12: {
                if (typeHandle.getColumnSize().isEmpty()) {
                    return Optional.of(StandardColumnMappings.varcharColumnMapping((VarcharType)VarcharType.createUnboundedVarcharType(), (boolean)true));
                }
                return Optional.of(StandardColumnMappings.defaultVarcharColumnMapping((int)typeHandle.getRequiredColumnSize(), (boolean)true));
            }
            case -3: {
                return Optional.of(StandardColumnMappings.varbinaryColumnMapping());
            }
            case 91: {
                return Optional.of(StandardColumnMappings.dateColumnMapping());
            }
            case 93: 
            case 2013: 
            case 2014: {
                if (TypeHandlingJdbcSessionProperties.getUnsupportedTypeHandling((ConnectorSession)session) == UnsupportedTypeHandling.CONVERT_TO_VARCHAR) {
                    return PhoenixClient.mapToUnboundedVarchar((JdbcTypeHandle)typeHandle);
                }
                return Optional.empty();
            }
            case 2003: {
                JdbcTypeHandle elementTypeHandle = this.getArrayElementTypeHandle(typeHandle);
                if (elementTypeHandle.getJdbcType() == -3) {
                    return Optional.empty();
                }
                return this.toColumnMapping(session, connection, elementTypeHandle).map(elementMapping -> {
                    ArrayType trinoArrayType = new ArrayType(elementMapping.getType());
                    String jdbcTypeName = (String)elementTypeHandle.getJdbcTypeName().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)PhoenixErrorCode.PHOENIX_METADATA_ERROR, "Type name is missing for jdbc type: " + JDBCType.valueOf(elementTypeHandle.getJdbcType())));
                    return PhoenixClient.arrayColumnMapping(session, trinoArrayType, jdbcTypeName);
                });
            }
        }
        if (TypeHandlingJdbcSessionProperties.getUnsupportedTypeHandling((ConnectorSession)session) == UnsupportedTypeHandling.CONVERT_TO_VARCHAR) {
            return PhoenixClient.mapToUnboundedVarchar((JdbcTypeHandle)typeHandle);
        }
        return Optional.empty();
    }

    public WriteMapping toWriteMapping(ConnectorSession session, Type type) {
        if (type == BooleanType.BOOLEAN) {
            return WriteMapping.booleanMapping((String)"boolean", (BooleanWriteFunction)StandardColumnMappings.booleanWriteFunction());
        }
        if (type == TinyintType.TINYINT) {
            return WriteMapping.longMapping((String)"tinyint", (LongWriteFunction)StandardColumnMappings.tinyintWriteFunction());
        }
        if (type == SmallintType.SMALLINT) {
            return WriteMapping.longMapping((String)"smallint", (LongWriteFunction)StandardColumnMappings.smallintWriteFunction());
        }
        if (type == IntegerType.INTEGER) {
            return WriteMapping.longMapping((String)"integer", (LongWriteFunction)StandardColumnMappings.integerWriteFunction());
        }
        if (type == BigintType.BIGINT) {
            return WriteMapping.longMapping((String)"bigint", (LongWriteFunction)StandardColumnMappings.bigintWriteFunction());
        }
        if (type == RealType.REAL) {
            return WriteMapping.longMapping((String)"float", (LongWriteFunction)StandardColumnMappings.realWriteFunction());
        }
        if (type == DoubleType.DOUBLE) {
            return WriteMapping.doubleMapping((String)"double", (DoubleWriteFunction)StandardColumnMappings.doubleWriteFunction());
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            String dataType = String.format("decimal(%s, %s)", decimalType.getPrecision(), decimalType.getScale());
            if (decimalType.isShort()) {
                return WriteMapping.longMapping((String)dataType, (LongWriteFunction)StandardColumnMappings.shortDecimalWriteFunction((DecimalType)decimalType));
            }
            return WriteMapping.sliceMapping((String)dataType, (SliceWriteFunction)StandardColumnMappings.longDecimalWriteFunction((DecimalType)decimalType));
        }
        if (type instanceof CharType) {
            return WriteMapping.sliceMapping((String)("char(" + ((CharType)type).getLength() + ")"), (SliceWriteFunction)StandardColumnMappings.charWriteFunction());
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            Object dataType = varcharType.isUnbounded() ? "varchar" : "varchar(" + varcharType.getBoundedLength() + ")";
            return WriteMapping.sliceMapping((String)dataType, (SliceWriteFunction)StandardColumnMappings.varcharWriteFunction());
        }
        if (type instanceof VarbinaryType) {
            return WriteMapping.sliceMapping((String)"varbinary", (SliceWriteFunction)StandardColumnMappings.varbinaryWriteFunction());
        }
        if (type == DateType.DATE) {
            return WriteMapping.longMapping((String)"date", (LongWriteFunction)StandardColumnMappings.dateWriteFunction());
        }
        if (TimeType.TIME.equals((Object)type)) {
            return WriteMapping.longMapping((String)"time", (LongWriteFunction)StandardColumnMappings.timeWriteFunctionUsingSqlTime());
        }
        if (TimeWithTimeZoneType.TIME_WITH_TIME_ZONE.equals((Object)type) || TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS.equals((Object)type)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported column type: " + type.getDisplayName());
        }
        if (type instanceof ArrayType) {
            Type elementType = ((ArrayType)type).getElementType();
            String elementDataType = this.toWriteMapping(session, elementType).getDataType().toUpperCase(Locale.ENGLISH);
            String elementWriteName = TypeUtils.getArrayElementPhoenixTypeName(session, this, elementType);
            return WriteMapping.objectMapping((String)(elementDataType + " ARRAY"), (ObjectWriteFunction)PhoenixClient.arrayWriteFunction(session, elementType, elementWriteName));
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported column type: " + type.getDisplayName());
    }

    public JdbcOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        PhoenixOutputTableHandle phoenixOutputTableHandle;
        block13: {
            SchemaTableName schemaTableName = tableMetadata.getTable();
            String schema = schemaTableName.getSchemaName();
            String table = schemaTableName.getTableName();
            if (!this.getSchemaNames(session).contains(schema)) {
                throw new SchemaNotFoundException(schema);
            }
            java.sql.Connection connection = this.connectionFactory.openConnection(session);
            try {
                ConnectorIdentity identity = session.getIdentity();
                schema = this.getIdentifierMapping().toRemoteSchemaName(identity, connection, schema);
                table = this.getIdentifierMapping().toRemoteTableName(identity, connection, schema, table);
                schema = MetadataUtil.toPhoenixSchemaName(schema);
                LinkedList tableColumns = new LinkedList(tableMetadata.getColumns());
                Map tableProperties = tableMetadata.getProperties();
                Optional<Boolean> immutableRows = PhoenixTableProperties.getImmutableRows(tableProperties);
                String immutable = immutableRows.isPresent() && immutableRows.get() != false ? "IMMUTABLE" : "";
                ImmutableList.Builder columnNames = ImmutableList.builder();
                ImmutableList.Builder columnTypes = ImmutableList.builder();
                ImmutableList.Builder columnList = ImmutableList.builder();
                Set rowkeyColumns = tableColumns.stream().filter(col -> PhoenixColumnProperties.isPrimaryKey(col, tableProperties)).collect(Collectors.toSet());
                ImmutableList.Builder pkNames = ImmutableList.builder();
                Optional<String> rowkeyColumn = Optional.empty();
                if (rowkeyColumns.isEmpty()) {
                    columnList.add((Object)"ROWKEY bigint not null");
                    pkNames.add((Object)ROWKEY);
                    this.execute(session, String.format("CREATE SEQUENCE %s", MetadataUtil.getEscapedTableName(schema, table + "_sequence")));
                    rowkeyColumn = Optional.of(ROWKEY);
                }
                for (ColumnMetadata column : tableColumns) {
                    String columnName = this.getIdentifierMapping().toRemoteColumnName(connection, column.getName());
                    columnNames.add((Object)columnName);
                    columnTypes.add((Object)column.getType());
                    Object typeStatement = this.toWriteMapping(session, column.getType()).getDataType();
                    if (rowkeyColumns.contains(column)) {
                        typeStatement = (String)typeStatement + " not null";
                        pkNames.add((Object)columnName);
                    }
                    columnList.add((Object)String.format("%s %s", SchemaUtil.getEscapedArgument((String)columnName), typeStatement));
                }
                ImmutableList.Builder tableOptions = ImmutableList.builder();
                PhoenixTableProperties.getSaltBuckets(tableProperties).ifPresent(value -> tableOptions.add((Object)(TableProperty.SALT_BUCKETS + "=" + value)));
                PhoenixTableProperties.getSplitOn(tableProperties).ifPresent(value -> tableOptions.add((Object)("SPLIT ON (" + value.replace('\"', '\'') + ")")));
                PhoenixTableProperties.getDisableWal(tableProperties).ifPresent(value -> tableOptions.add((Object)(TableProperty.DISABLE_WAL + "=" + value)));
                PhoenixTableProperties.getDefaultColumnFamily(tableProperties).ifPresent(value -> tableOptions.add((Object)(TableProperty.DEFAULT_COLUMN_FAMILY + "=" + value)));
                PhoenixTableProperties.getBloomfilter(tableProperties).ifPresent(value -> tableOptions.add((Object)("BLOOMFILTER='" + value + "'")));
                PhoenixTableProperties.getVersions(tableProperties).ifPresent(value -> tableOptions.add((Object)("VERSIONS=" + value)));
                PhoenixTableProperties.getMinVersions(tableProperties).ifPresent(value -> tableOptions.add((Object)("MIN_VERSIONS=" + value)));
                PhoenixTableProperties.getCompression(tableProperties).ifPresent(value -> tableOptions.add((Object)("COMPRESSION='" + value + "'")));
                PhoenixTableProperties.getTimeToLive(tableProperties).ifPresent(value -> tableOptions.add((Object)("TTL=" + value)));
                PhoenixTableProperties.getDataBlockEncoding(tableProperties).ifPresent(value -> tableOptions.add((Object)("DATA_BLOCK_ENCODING='" + value + "'")));
                String sql = String.format("CREATE %s TABLE %s (%s , CONSTRAINT PK PRIMARY KEY (%s)) %s", immutable, MetadataUtil.getEscapedTableName(schema, table), String.join((CharSequence)", ", (Iterable<? extends CharSequence>)columnList.build()), String.join((CharSequence)", ", (Iterable<? extends CharSequence>)pkNames.build()), String.join((CharSequence)", ", (Iterable<? extends CharSequence>)tableOptions.build()));
                this.execute(session, sql);
                phoenixOutputTableHandle = new PhoenixOutputTableHandle(schema, table, (List<String>)columnNames.build(), (List<Type>)columnTypes.build(), Optional.empty(), rowkeyColumn);
                if (connection == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == SQLExceptionCode.TABLE_ALREADY_EXIST.getErrorCode()) {
                        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Phoenix table already exists", (Throwable)e);
                    }
                    throw new TrinoException((ErrorCodeSupplier)PhoenixErrorCode.PHOENIX_METADATA_ERROR, "Error creating Phoenix table", (Throwable)e);
                }
            }
            connection.close();
        }
        return phoenixOutputTableHandle;
    }

    protected void renameTable(ConnectorSession session, String catalogName, String schemaName, String tableName, SchemaTableName newTable) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support renaming tables");
    }

    public Map<String, Object> getTableProperties(ConnectorSession session, JdbcTableHandle handle) {
        ImmutableMap.Builder properties = ImmutableMap.builder();
        try (java.sql.Connection connection = this.connectionFactory.openConnection(session);
             Admin admin = connection.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
            HColumnDescriptor[] columnFamilies;
            String schemaName = MetadataUtil.toPhoenixSchemaName(handle.getSchemaName());
            PTable table = PhoenixRuntime.getTable((java.sql.Connection)connection, (String)SchemaUtil.getTableName((String)schemaName, (String)handle.getTableName()));
            boolean salted = table.getBucketNum() != null;
            StringJoiner joiner = new StringJoiner(",");
            List pkColumns = table.getPKColumns();
            for (PColumn pkColumn : pkColumns.subList(salted ? 1 : 0, pkColumns.size())) {
                joiner.add(pkColumn.getName().getString());
            }
            properties.put((Object)"rowkeys", (Object)joiner.toString());
            if (table.getBucketNum() != null) {
                properties.put((Object)"salt_buckets", (Object)table.getBucketNum());
            }
            if (table.isWALDisabled()) {
                properties.put((Object)"disable_wal", (Object)table.isWALDisabled());
            }
            if (table.isImmutableRows()) {
                properties.put((Object)"immutable_rows", (Object)table.isImmutableRows());
            }
            String defaultFamilyName = "0";
            if (table.getDefaultFamilyName() != null) {
                defaultFamilyName = table.getDefaultFamilyName().getString();
                properties.put((Object)"default_column_family", (Object)defaultFamilyName);
            }
            HTableDescriptor tableDesc = admin.getTableDescriptor(TableName.valueOf((byte[])table.getPhysicalName().getBytes()));
            for (HColumnDescriptor columnFamily : columnFamilies = tableDesc.getColumnFamilies()) {
                if (!columnFamily.getNameAsString().equals(defaultFamilyName)) continue;
                if (columnFamily.getBloomFilterType() != BloomType.NONE) {
                    properties.put((Object)"bloomfilter", (Object)columnFamily.getBloomFilterType());
                }
                if (columnFamily.getMaxVersions() != 1) {
                    properties.put((Object)"versions", (Object)columnFamily.getMaxVersions());
                }
                if (columnFamily.getMinVersions() > 0) {
                    properties.put((Object)"min_versions", (Object)columnFamily.getMinVersions());
                }
                if (columnFamily.getCompression() != Compression.Algorithm.NONE) {
                    properties.put((Object)"compression", (Object)columnFamily.getCompression());
                }
                if (columnFamily.getTimeToLive() < Integer.MAX_VALUE) {
                    properties.put((Object)"ttl", (Object)columnFamily.getTimeToLive());
                }
                if (columnFamily.getDataBlockEncoding() != DataBlockEncoding.NONE) {
                    properties.put((Object)"data_block_encoding", (Object)columnFamily.getDataBlockEncoding());
                }
                break;
            }
        }
        catch (IOException | SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)PhoenixErrorCode.PHOENIX_METADATA_ERROR, "Couldn't get Phoenix table properties", (Throwable)e);
        }
        return properties.build();
    }

    private static ColumnMapping arrayColumnMapping(ConnectorSession session, ArrayType arrayType, String elementJdbcTypeName) {
        return ColumnMapping.objectMapping((Type)arrayType, (ObjectReadFunction)PhoenixClient.arrayReadFunction(session, arrayType.getElementType()), (ObjectWriteFunction)PhoenixClient.arrayWriteFunction(session, arrayType.getElementType(), elementJdbcTypeName));
    }

    private static ObjectReadFunction arrayReadFunction(ConnectorSession session, Type elementType) {
        return ObjectReadFunction.of(Block.class, (resultSet, columnIndex) -> {
            Object[] objectArray = TypeUtils.toBoxedArray(resultSet.getArray(columnIndex).getArray());
            return TypeUtils.jdbcObjectArrayToBlock(session, elementType, objectArray);
        });
    }

    private static ObjectWriteFunction arrayWriteFunction(ConnectorSession session, Type elementType, String elementJdbcTypeName) {
        return ObjectWriteFunction.of(Block.class, (statement, index, block) -> {
            Array jdbcArray = statement.getConnection().createArrayOf(elementJdbcTypeName, TypeUtils.getJdbcObjectArray(session, elementType, block));
            statement.setArray(index, jdbcArray);
        });
    }

    private JdbcTypeHandle getArrayElementTypeHandle(JdbcTypeHandle arrayTypeHandle) {
        String arrayTypeName = (String)arrayTypeHandle.getJdbcTypeName().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)PhoenixErrorCode.PHOENIX_METADATA_ERROR, "Type name is missing for jdbc type: " + JDBCType.valueOf(arrayTypeHandle.getJdbcType())));
        Preconditions.checkArgument((boolean)arrayTypeName.endsWith(" ARRAY"), (Object)"array type must end with ' ARRAY'");
        arrayTypeName = arrayTypeName.substring(0, arrayTypeName.length() - " ARRAY".length());
        Verify.verify((boolean)arrayTypeHandle.getCaseSensitivity().isEmpty(), (String)"Case sensitivity not supported", (Object[])new Object[0]);
        return new JdbcTypeHandle(PDataType.fromSqlTypeName((String)arrayTypeName).getSqlType(), Optional.of(arrayTypeName), arrayTypeHandle.getColumnSize(), arrayTypeHandle.getDecimalDigits(), arrayTypeHandle.getArrayDimensions(), Optional.empty());
    }

    public QueryPlan getQueryPlan(PhoenixPreparedStatement inputQuery) {
        try {
            QueryPlan queryPlan = inputQuery.optimizeQuery();
            queryPlan.iterator((ParallelScanGrouper)MapReduceParallelScanGrouper.getInstance());
            return queryPlan;
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)PhoenixErrorCode.PHOENIX_QUERY_ERROR, "Failed to get the Phoenix query plan", (Throwable)e);
        }
    }

    private static ResultSet getResultSet(PhoenixInputSplit split, QueryPlan queryPlan) {
        List scans = split.getScans();
        try {
            PeekingResultIterator iterator;
            ArrayList<PeekingResultIterator> iterators = new ArrayList<PeekingResultIterator>(scans.size());
            StatementContext context = queryPlan.getContext();
            PName physicalTableName = queryPlan.getTableRef().getTable().getPhysicalName();
            PhoenixConnection phoenixConnection = context.getConnection();
            ConnectionQueryServices services = phoenixConnection.getQueryServices();
            services.clearTableRegionCache(TableName.valueOf((byte[])physicalTableName.getBytes()));
            for (Scan scan : scans) {
                scan = new Scan(scan);
                scan.setAttribute("_SKIP_REGION_BOUNDARY_CHECK", Bytes.toBytes((boolean)true));
                ScanMetricsHolder scanMetricsHolder = ScanMetricsHolder.getInstance((ReadMetricQueue)context.getReadMetricsQueue(), (String)physicalTableName.getString(), (Scan)scan, (LogLevel)phoenixConnection.getLogLevel());
                TableResultIterator tableResultIterator = new TableResultIterator(phoenixConnection.getMutationState(), scan, scanMetricsHolder, services.getRenewLeaseThresholdMilliSeconds(), queryPlan, (ParallelScanGrouper)MapReduceParallelScanGrouper.getInstance());
                iterators.add(LookAheadResultIterator.wrap((ResultIterator)tableResultIterator));
            }
            Object object = iterator = queryPlan.useRoundRobinIterator() ? RoundRobinResultIterator.newIterator(iterators, (QueryPlan)queryPlan) : ConcatResultIterator.newIterator(iterators);
            if (context.getSequenceManager().getSequenceCount() > 0) {
                iterator = new SequenceResultIterator((ResultIterator)iterator, context.getSequenceManager());
            }
            return new PhoenixResultSet((ResultIterator)iterator, queryPlan.getProjector().cloneIfNecessary(), context);
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)PhoenixErrorCode.PHOENIX_QUERY_ERROR, "Error while setting up Phoenix ResultSet", (Throwable)e);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)PhoenixErrorCode.PHOENIX_INTERNAL_ERROR, "Error while copying scan", (Throwable)e);
        }
    }
}

