/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.phoenix5;

import com.google.common.collect.ImmutableList;
import io.airlift.log.Logger;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.phoenix5.PhoenixClient;
import io.trino.plugin.phoenix5.PhoenixErrorCode;
import io.trino.plugin.phoenix5.PhoenixSplit;
import io.trino.plugin.phoenix5.WrappedPhoenixInputSplit;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.HostAddress;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.mapreduce.PhoenixInputSplit;
import org.apache.phoenix.query.KeyRange;

public class PhoenixSplitManager
implements ConnectorSplitManager {
    private static final Logger log = Logger.get(PhoenixSplitManager.class);
    private final PhoenixClient phoenixClient;

    @Inject
    public PhoenixSplitManager(PhoenixClient phoenixClient) {
        this.phoenixClient = Objects.requireNonNull(phoenixClient, "phoenixClient is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle table, ConnectorSplitManager.SplitSchedulingStrategy splitSchedulingStrategy, DynamicFilter dynamicFilter) {
        FixedSplitSource fixedSplitSource;
        block8: {
            JdbcTableHandle tableHandle = (JdbcTableHandle)table;
            java.sql.Connection connection = this.phoenixClient.getConnection(session);
            try {
                List columns = tableHandle.getColumns().map(columnSet -> columnSet.stream().map(JdbcColumnHandle.class::cast).collect(Collectors.toList())).orElseGet(() -> this.phoenixClient.getColumns(session, tableHandle));
                PhoenixPreparedStatement inputQuery = (PhoenixPreparedStatement)this.phoenixClient.prepareStatement(session, connection, tableHandle, columns, Optional.empty());
                List splits = (List)this.getSplits(inputQuery).stream().map(PhoenixInputSplit.class::cast).map(split -> new PhoenixSplit(this.getSplitAddresses((PhoenixInputSplit)split), new WrappedPhoenixInputSplit((PhoenixInputSplit)split))).collect(ImmutableList.toImmutableList());
                fixedSplitSource = new FixedSplitSource((Iterable)splits);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | SQLException e) {
                    throw new TrinoException((ErrorCodeSupplier)PhoenixErrorCode.PHOENIX_SPLIT_ERROR, "Couldn't get Phoenix splits", (Throwable)e);
                }
            }
            connection.close();
        }
        return fixedSplitSource;
    }

    private List<HostAddress> getSplitAddresses(PhoenixInputSplit split) {
        try {
            return ImmutableList.of((Object)HostAddress.fromString((String)split.getLocations()[0]));
        }
        catch (IOException | InterruptedException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new TrinoException((ErrorCodeSupplier)PhoenixErrorCode.PHOENIX_INTERNAL_ERROR, "Exception when getting split addresses", (Throwable)e);
        }
    }

    private List<InputSplit> getSplits(PhoenixPreparedStatement inputQuery) throws IOException {
        QueryPlan queryPlan = this.phoenixClient.getQueryPlan(inputQuery);
        return this.generateSplits(queryPlan, queryPlan.getSplits());
    }

    private List<InputSplit> generateSplits(QueryPlan queryPlan, List<KeyRange> splits) throws IOException {
        Objects.requireNonNull(queryPlan, "queryPlan is null");
        Objects.requireNonNull(splits, "splits is null");
        try (Connection connection = this.phoenixClient.getHConnection();){
            RegionLocator regionLocator = connection.getRegionLocator(TableName.valueOf((String)queryPlan.getTableRef().getTable().getPhysicalName().toString()));
            long regionSize = -1L;
            ArrayList<PhoenixInputSplit> inputSplits = new ArrayList<PhoenixInputSplit>(splits.size());
            for (List scans : queryPlan.getScans()) {
                HRegionLocation location = regionLocator.getRegionLocation(((Scan)scans.get(0)).getStartRow(), false);
                String regionLocation = location.getHostname();
                if (log.isDebugEnabled()) {
                    log.debug("Scan count[%d] : %s ~ %s", new Object[]{scans.size(), Bytes.toStringBinary((byte[])((Scan)scans.get(0)).getStartRow()), Bytes.toStringBinary((byte[])((Scan)scans.get(scans.size() - 1)).getStopRow())});
                    log.debug("First scan : %swith scanAttribute : %s [scanCache, cacheBlock, scanBatch] : [%d, %s, %d] and  regionLocation : %s", new Object[]{scans.get(0), ((Scan)scans.get(0)).getAttributesMap(), ((Scan)scans.get(0)).getCaching(), ((Scan)scans.get(0)).getCacheBlocks(), ((Scan)scans.get(0)).getBatch(), regionLocation});
                    int limit = scans.size();
                    for (int i = 0; i < limit; ++i) {
                        log.debug("EXPECTED_UPPER_REGION_KEY[%d] : %s", new Object[]{i, Bytes.toStringBinary((byte[])((Scan)scans.get(i)).getAttribute("_ExpectedUpperRegionKey"))});
                    }
                }
                inputSplits.add(new PhoenixInputSplit(scans, regionSize, regionLocation));
            }
            ArrayList<PhoenixInputSplit> arrayList = inputSplits;
            return arrayList;
        }
    }
}

