/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.phoenix5;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.io.ByteStreams;
import java.io.DataInput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.mapreduce.PhoenixInputSplit;

public class WrappedPhoenixInputSplit {
    private final PhoenixInputSplit phoenixInputSplit;

    public WrappedPhoenixInputSplit(PhoenixInputSplit phoenixInputSplit) {
        this.phoenixInputSplit = phoenixInputSplit;
    }

    public PhoenixInputSplit getPhoenixInputSplit() {
        return this.phoenixInputSplit;
    }

    @JsonValue
    public byte[] toBytes() {
        return WritableUtils.toByteArray((Writable[])new Writable[]{this.phoenixInputSplit});
    }

    @JsonCreator
    public static WrappedPhoenixInputSplit fromBytes(byte[] bytes) throws IOException {
        PhoenixInputSplit materialized = new PhoenixInputSplit();
        materialized.readFields((DataInput)ByteStreams.newDataInput((byte[])bytes));
        return new WrappedPhoenixInputSplit(materialized);
    }

    public int hashCode() {
        return this.phoenixInputSplit.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof WrappedPhoenixInputSplit) {
            PhoenixInputSplit otherSplit = ((WrappedPhoenixInputSplit)obj).getPhoenixInputSplit();
            return this.phoenixInputSplit.equals((Object)otherSplit);
        }
        return false;
    }
}

