/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.phoenix5;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import io.trino.plugin.base.expression.ConnectorExpressionRewriter;
import io.trino.plugin.base.expression.ConnectorExpressionRule;
import io.trino.plugin.base.mapping.IdentifierMapping;
import io.trino.plugin.base.mapping.RemoteIdentifiers;
import io.trino.plugin.jdbc.BaseJdbcClient;
import io.trino.plugin.jdbc.BooleanWriteFunction;
import io.trino.plugin.jdbc.ColumnMapping;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DecimalConfig;
import io.trino.plugin.jdbc.DecimalSessionSessionProperties;
import io.trino.plugin.jdbc.DoubleWriteFunction;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcOutputTableHandle;
import io.trino.plugin.jdbc.JdbcSortItem;
import io.trino.plugin.jdbc.JdbcSplit;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.LongReadFunction;
import io.trino.plugin.jdbc.LongWriteFunction;
import io.trino.plugin.jdbc.ObjectReadFunction;
import io.trino.plugin.jdbc.ObjectWriteFunction;
import io.trino.plugin.jdbc.PredicatePushdownController;
import io.trino.plugin.jdbc.PreparedQuery;
import io.trino.plugin.jdbc.QueryBuilder;
import io.trino.plugin.jdbc.RemoteTableName;
import io.trino.plugin.jdbc.SliceWriteFunction;
import io.trino.plugin.jdbc.StandardColumnMappings;
import io.trino.plugin.jdbc.TypeHandlingJdbcSessionProperties;
import io.trino.plugin.jdbc.UnsupportedTypeHandling;
import io.trino.plugin.jdbc.WriteFunction;
import io.trino.plugin.jdbc.WriteMapping;
import io.trino.plugin.jdbc.expression.JdbcConnectorExpressionRewriterBuilder;
import io.trino.plugin.jdbc.expression.ParameterizedExpression;
import io.trino.plugin.jdbc.expression.RewriteComparison;
import io.trino.plugin.jdbc.logging.RemoteQueryModifier;
import io.trino.plugin.phoenix5.ConfigurationInstantiator;
import io.trino.plugin.phoenix5.MetadataUtil;
import io.trino.plugin.phoenix5.PhoenixClientModule;
import io.trino.plugin.phoenix5.PhoenixColumnProperties;
import io.trino.plugin.phoenix5.PhoenixConfig;
import io.trino.plugin.phoenix5.PhoenixErrorCode;
import io.trino.plugin.phoenix5.PhoenixOutputTableHandle;
import io.trino.plugin.phoenix5.PhoenixSplit;
import io.trino.plugin.phoenix5.PhoenixTableProperties;
import io.trino.plugin.phoenix5.TypeUtils;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.math.RoundingMode;
import java.sql.Array;
import java.sql.DatabaseMetaData;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.iterate.ConcatResultIterator;
import org.apache.phoenix.iterate.LookAheadResultIterator;
import org.apache.phoenix.iterate.MapReduceParallelScanGrouper;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.iterate.SequenceResultIterator;
import org.apache.phoenix.iterate.TableResultIterator;
import org.apache.phoenix.jdbc.DelegatePreparedStatement;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.log.LogLevel;
import org.apache.phoenix.mapreduce.PhoenixInputSplit;
import org.apache.phoenix.monitoring.ReadMetricQueue;
import org.apache.phoenix.monitoring.ScanMetricsHolder;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.HBaseFactoryProvider;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.TableProperty;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PhoenixArray;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.SchemaUtil;

public class PhoenixClient
extends BaseJdbcClient {
    public static final String MERGE_ROW_ID_COLUMN_NAME = "$merge_row_id";
    public static final String ROWKEY = "ROWKEY";
    public static final JdbcColumnHandle ROWKEY_COLUMN_HANDLE = new JdbcColumnHandle("ROWKEY", new JdbcTypeHandle(-5, Optional.of("BIGINT"), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()), (Type)BigintType.BIGINT);
    private static final String DATE_FORMAT = "y-MM-dd G";
    private static final DateTimeFormatter LOCAL_DATE_FORMATTER = DateTimeFormatter.ofPattern("y-MM-dd G");
    public static final int DEFAULT_DOMAIN_COMPACTION_THRESHOLD = 5000;
    private final Configuration configuration = ConfigurationInstantiator.newEmptyConfiguration();
    private final ConnectorExpressionRewriter<ParameterizedExpression> connectorExpressionRewriter;

    @Inject
    public PhoenixClient(PhoenixConfig config, ConnectionFactory connectionFactory, QueryBuilder queryBuilder, IdentifierMapping identifierMapping, RemoteQueryModifier queryModifier) throws SQLException {
        super("\"", connectionFactory, queryBuilder, (Set)ImmutableSet.of(), identifierMapping, queryModifier, false);
        PhoenixClientModule.getConnectionProperties(config).forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.configuration.set((String)k, (String)v)));
        this.connectorExpressionRewriter = ((JdbcConnectorExpressionRewriterBuilder)((JdbcConnectorExpressionRewriterBuilder)((JdbcConnectorExpressionRewriterBuilder)((JdbcConnectorExpressionRewriterBuilder)((JdbcConnectorExpressionRewriterBuilder)((JdbcConnectorExpressionRewriterBuilder)JdbcConnectorExpressionRewriterBuilder.newBuilder().addStandardRules(arg_0 -> ((PhoenixClient)this).quoted(arg_0)).add((ConnectorExpressionRule)new RewriteComparison((Set)ImmutableSet.of((Object)RewriteComparison.ComparisonOperator.EQUAL, (Object)RewriteComparison.ComparisonOperator.NOT_EQUAL))).withTypeClass("integer_type", (Set)ImmutableSet.of((Object)"tinyint", (Object)"smallint", (Object)"integer", (Object)"bigint")).map("$add(left: integer_type, right: integer_type)").to("left + right")).map("$subtract(left: integer_type, right: integer_type)").to("left - right")).map("$multiply(left: integer_type, right: integer_type)").to("left * right")).map("$divide(left: integer_type, right: integer_type)").to("left / right")).map("$modulus(left: integer_type, right: integer_type)").to("left % right")).map("$negate(value: integer_type)").to("-value")).build();
    }

    public Optional<ParameterizedExpression> convertPredicate(ConnectorSession session, ConnectorExpression expression, Map<String, ColumnHandle> assignments) {
        return this.connectorExpressionRewriter.rewrite(session, expression, assignments);
    }

    public java.sql.Connection getConnection(ConnectorSession session) throws SQLException {
        return this.connectionFactory.openConnection(session);
    }

    public Connection getHConnection() throws IOException {
        return HBaseFactoryProvider.getHConnectionFactory().createConnection(this.configuration);
    }

    public void execute(ConnectorSession session, String statement) {
        super.execute(session, statement);
    }

    public Collection<String> listSchemas(java.sql.Connection connection) {
        ImmutableSet immutableSet;
        block9: {
            ResultSet resultSet = connection.getMetaData().getSchemas();
            try {
                ImmutableSet.Builder schemaNames = ImmutableSet.builder();
                schemaNames.add((Object)"default");
                while (resultSet.next()) {
                    String schemaName = this.getTableSchemaName(resultSet);
                    if (!this.filterSchema(schemaName)) continue;
                    schemaNames.add((Object)schemaName);
                }
                immutableSet = schemaNames.build();
                if (resultSet == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new TrinoException((ErrorCodeSupplier)PhoenixErrorCode.PHOENIX_METADATA_ERROR, (Throwable)e);
                }
            }
            resultSet.close();
        }
        return immutableSet;
    }

    public PreparedStatement buildSql(ConnectorSession session, java.sql.Connection connection, JdbcSplit split, JdbcTableHandle table, List<JdbcColumnHandle> columnHandles) throws SQLException {
        PreparedStatement query = this.prepareStatement(session, connection, table, columnHandles, Optional.of(split));
        QueryPlan queryPlan = this.getQueryPlan(query.unwrap(PhoenixPreparedStatement.class));
        final ResultSet resultSet = PhoenixClient.getResultSet(((PhoenixSplit)split).getPhoenixInputSplit(), queryPlan);
        return new DelegatePreparedStatement(query){

            public ResultSet executeQuery() {
                return resultSet;
            }
        };
    }

    public PreparedStatement prepareStatement(ConnectorSession session, java.sql.Connection connection, JdbcTableHandle table, List<JdbcColumnHandle> columns, Optional<JdbcSplit> split) throws SQLException {
        PreparedQuery preparedQuery = this.prepareQuery(session, connection, table, Optional.empty(), columns, (Map)ImmutableMap.of(), split);
        return this.queryBuilder.prepareStatement((JdbcClient)this, session, connection, preparedQuery, Optional.of(columns.size()));
    }

    public boolean supportsTopN(ConnectorSession session, JdbcTableHandle handle, List<JdbcSortItem> sortOrder) {
        return true;
    }

    protected Optional<BaseJdbcClient.TopNFunction> topNFunction() {
        return Optional.of(BaseJdbcClient.TopNFunction.sqlStandard(arg_0 -> ((PhoenixClient)this).quoted(arg_0)));
    }

    public boolean isTopNGuaranteed(ConnectorSession session) {
        return false;
    }

    public OptionalLong update(ConnectorSession session, JdbcTableHandle handle) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support modifying table rows");
    }

    protected Optional<BiFunction<String, Long, String>> limitFunction() {
        return Optional.of((sql, limit) -> sql + " LIMIT " + limit);
    }

    public boolean isLimitGuaranteed(ConnectorSession session) {
        return false;
    }

    public String buildInsertSql(JdbcOutputTableHandle handle, List<WriteFunction> columnWriters) {
        PhoenixOutputTableHandle outputHandle = (PhoenixOutputTableHandle)handle;
        Object params = columnWriters.stream().map(WriteFunction::getBindExpression).collect(Collectors.joining(","));
        Object columns = handle.getColumnNames().stream().map(SchemaUtil::getEscapedArgument).collect(Collectors.joining(","));
        if (outputHandle.rowkeyColumn().isPresent()) {
            String nextId = String.format("NEXT VALUE FOR %s, ", this.quoted(null, handle.getSchemaName(), handle.getTableName() + "_sequence"));
            params = nextId + (String)params;
            columns = outputHandle.rowkeyColumn().get() + ", " + (String)columns;
        }
        return String.format("UPSERT INTO %s (%s) VALUES (%s)", this.quoted(null, handle.getSchemaName(), handle.getTableName()), columns, params);
    }

    public ResultSet getTables(java.sql.Connection connection, Optional<String> schemaName, Optional<String> tableName) throws SQLException {
        return super.getTables(connection, schemaName.map(MetadataUtil::toPhoenixSchemaName), tableName);
    }

    protected String getTableSchemaName(ResultSet resultSet) throws SQLException {
        return (String)MoreObjects.firstNonNull((Object)resultSet.getString("TABLE_SCHEM"), (Object)"default");
    }

    protected ResultSet getColumns(JdbcTableHandle handle, DatabaseMetaData metadata) throws SQLException {
        try {
            return super.getColumns(handle, metadata);
        }
        catch (org.apache.phoenix.schema.TableNotFoundException e) {
            RemoteTableName remoteTableName = handle.getRequiredNamedRelation().getRemoteTableName();
            throw new TableNotFoundException(new SchemaTableName((String)remoteTableName.getSchemaName().orElse(null), remoteTableName.getTableName()));
        }
    }

    public Optional<ColumnMapping> toColumnMapping(ConnectorSession session, java.sql.Connection connection, JdbcTypeHandle typeHandle) {
        Optional mapping = this.getForcedMappingToVarchar(typeHandle);
        if (mapping.isPresent()) {
            return mapping;
        }
        switch (typeHandle.getJdbcType()) {
            case 16: {
                return Optional.of(StandardColumnMappings.booleanColumnMapping());
            }
            case -6: {
                return Optional.of(StandardColumnMappings.tinyintColumnMapping());
            }
            case 5: {
                return Optional.of(StandardColumnMappings.smallintColumnMapping());
            }
            case 4: {
                return Optional.of(StandardColumnMappings.integerColumnMapping());
            }
            case -5: {
                return Optional.of(StandardColumnMappings.bigintColumnMapping());
            }
            case 6: {
                return Optional.of(StandardColumnMappings.realColumnMapping());
            }
            case 8: {
                return Optional.of(StandardColumnMappings.doubleColumnMapping());
            }
            case 3: {
                Optional columnSize = typeHandle.getColumnSize();
                int precision = columnSize.orElse(38);
                int decimalDigits = typeHandle.getDecimalDigits().orElse(0);
                if (DecimalSessionSessionProperties.getDecimalRounding((ConnectorSession)session) == DecimalConfig.DecimalMapping.ALLOW_OVERFLOW && columnSize.isEmpty()) {
                    return Optional.of(StandardColumnMappings.decimalColumnMapping((DecimalType)DecimalType.createDecimalType((int)38, (int)DecimalSessionSessionProperties.getDecimalDefaultScale((ConnectorSession)session)), (RoundingMode)DecimalSessionSessionProperties.getDecimalRoundingMode((ConnectorSession)session)));
                }
                if ((precision += Math.max(-decimalDigits, 0)) > 38) break;
                return Optional.of(StandardColumnMappings.decimalColumnMapping((DecimalType)DecimalType.createDecimalType((int)precision, (int)Math.max(decimalDigits, 0)), (RoundingMode)RoundingMode.UNNECESSARY));
            }
            case 1: {
                return Optional.of(StandardColumnMappings.defaultCharColumnMapping((int)typeHandle.getRequiredColumnSize(), (boolean)true));
            }
            case -16: 
            case -9: 
            case -1: 
            case 12: {
                if (typeHandle.getColumnSize().isEmpty()) {
                    return Optional.of(StandardColumnMappings.varcharColumnMapping((VarcharType)VarcharType.createUnboundedVarcharType(), (boolean)true));
                }
                return Optional.of(StandardColumnMappings.defaultVarcharColumnMapping((int)typeHandle.getRequiredColumnSize(), (boolean)true));
            }
            case -3: 
            case -2: {
                return Optional.of(StandardColumnMappings.varbinaryColumnMapping());
            }
            case 91: {
                return Optional.of(ColumnMapping.longMapping((Type)DateType.DATE, (LongReadFunction)PhoenixClient.dateReadFunction(), (LongWriteFunction)PhoenixClient.dateWriteFunctionUsingString()));
            }
            case 93: 
            case 2013: 
            case 2014: {
                if (TypeHandlingJdbcSessionProperties.getUnsupportedTypeHandling((ConnectorSession)session) == UnsupportedTypeHandling.CONVERT_TO_VARCHAR) {
                    return PhoenixClient.mapToUnboundedVarchar((JdbcTypeHandle)typeHandle);
                }
                return Optional.empty();
            }
            case 2003: {
                JdbcTypeHandle elementTypeHandle = this.getArrayElementTypeHandle(typeHandle);
                if (elementTypeHandle.getJdbcType() == -3) {
                    return Optional.empty();
                }
                return this.toColumnMapping(session, connection, elementTypeHandle).map(elementMapping -> {
                    ArrayType trinoArrayType = new ArrayType(elementMapping.getType());
                    String jdbcTypeName = (String)elementTypeHandle.getJdbcTypeName().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)PhoenixErrorCode.PHOENIX_METADATA_ERROR, "Type name is missing for jdbc type: " + JDBCType.valueOf(elementTypeHandle.getJdbcType())));
                    PredicatePushdownController pushdownController = elementTypeHandle.getJdbcType() == 1 ? PredicatePushdownController.DISABLE_PUSHDOWN : PredicatePushdownController.FULL_PUSHDOWN;
                    return PhoenixClient.arrayColumnMapping(session, trinoArrayType, jdbcTypeName, pushdownController);
                });
            }
        }
        if (TypeHandlingJdbcSessionProperties.getUnsupportedTypeHandling((ConnectorSession)session) == UnsupportedTypeHandling.CONVERT_TO_VARCHAR) {
            return PhoenixClient.mapToUnboundedVarchar((JdbcTypeHandle)typeHandle);
        }
        return Optional.empty();
    }

    public WriteMapping toWriteMapping(ConnectorSession session, Type type) {
        if (type == BooleanType.BOOLEAN) {
            return WriteMapping.booleanMapping((String)"boolean", (BooleanWriteFunction)StandardColumnMappings.booleanWriteFunction());
        }
        if (type == TinyintType.TINYINT) {
            return WriteMapping.longMapping((String)"tinyint", (LongWriteFunction)StandardColumnMappings.tinyintWriteFunction());
        }
        if (type == SmallintType.SMALLINT) {
            return WriteMapping.longMapping((String)"smallint", (LongWriteFunction)StandardColumnMappings.smallintWriteFunction());
        }
        if (type == IntegerType.INTEGER) {
            return WriteMapping.longMapping((String)"integer", (LongWriteFunction)StandardColumnMappings.integerWriteFunction());
        }
        if (type == BigintType.BIGINT) {
            return WriteMapping.longMapping((String)"bigint", (LongWriteFunction)StandardColumnMappings.bigintWriteFunction());
        }
        if (type == RealType.REAL) {
            return WriteMapping.longMapping((String)"float", (LongWriteFunction)StandardColumnMappings.realWriteFunction());
        }
        if (type == DoubleType.DOUBLE) {
            return WriteMapping.doubleMapping((String)"double", (DoubleWriteFunction)StandardColumnMappings.doubleWriteFunction());
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            String dataType = String.format("decimal(%s, %s)", decimalType.getPrecision(), decimalType.getScale());
            if (decimalType.isShort()) {
                return WriteMapping.longMapping((String)dataType, (LongWriteFunction)StandardColumnMappings.shortDecimalWriteFunction((DecimalType)decimalType));
            }
            return WriteMapping.objectMapping((String)dataType, (ObjectWriteFunction)StandardColumnMappings.longDecimalWriteFunction((DecimalType)decimalType));
        }
        if (type instanceof CharType) {
            CharType charType = (CharType)type;
            return WriteMapping.sliceMapping((String)("char(" + charType.getLength() + ")"), (SliceWriteFunction)StandardColumnMappings.charWriteFunction());
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            Object dataType = varcharType.isUnbounded() ? "varchar" : "varchar(" + varcharType.getBoundedLength() + ")";
            return WriteMapping.sliceMapping((String)dataType, (SliceWriteFunction)StandardColumnMappings.varcharWriteFunction());
        }
        if (type instanceof VarbinaryType) {
            return WriteMapping.sliceMapping((String)"varbinary", (SliceWriteFunction)StandardColumnMappings.varbinaryWriteFunction());
        }
        if (type == DateType.DATE) {
            return WriteMapping.longMapping((String)"date", (LongWriteFunction)PhoenixClient.dateWriteFunctionUsingString());
        }
        if (TimeType.TIME_MILLIS.equals((Object)type)) {
            return WriteMapping.longMapping((String)"time", (LongWriteFunction)StandardColumnMappings.timeWriteFunctionUsingSqlTime());
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            Type elementType = arrayType.getElementType();
            String elementDataType = this.toWriteMapping(session, elementType).getDataType().toUpperCase(Locale.ENGLISH);
            String elementWriteName = TypeUtils.getArrayElementPhoenixTypeName(session, this, elementType);
            return WriteMapping.objectMapping((String)(elementDataType + " ARRAY"), (ObjectWriteFunction)PhoenixClient.arrayWriteFunction(session, elementType, elementWriteName));
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported column type: " + type.getDisplayName());
    }

    public Optional<String> getTableComment(ResultSet resultSet) {
        return Optional.empty();
    }

    public JdbcOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        PhoenixOutputTableHandle phoenixOutputTableHandle;
        block15: {
            if (tableMetadata.getComment().isPresent()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support creating tables with table comment");
            }
            SchemaTableName schemaTableName = tableMetadata.getTable();
            String schema = schemaTableName.getSchemaName();
            String table = schemaTableName.getTableName();
            if (!this.getSchemaNames(session).contains(schema)) {
                throw new SchemaNotFoundException(schema);
            }
            java.sql.Connection connection = this.connectionFactory.openConnection(session);
            try {
                ConnectorIdentity identity = session.getIdentity();
                RemoteIdentifiers remoteIdentifiers = this.getRemoteIdentifiers(connection);
                schema = this.getIdentifierMapping().toRemoteSchemaName(remoteIdentifiers, identity, schema);
                table = this.getIdentifierMapping().toRemoteTableName(remoteIdentifiers, identity, schema, table);
                schema = MetadataUtil.toPhoenixSchemaName(schema);
                LinkedList tableColumns = new LinkedList(tableMetadata.getColumns());
                Map tableProperties = tableMetadata.getProperties();
                Optional<Boolean> immutableRows = PhoenixTableProperties.getImmutableRows(tableProperties);
                String immutable = immutableRows.isPresent() && immutableRows.get() != false ? "IMMUTABLE" : "";
                ImmutableList.Builder columnNames = ImmutableList.builder();
                ImmutableList.Builder columnTypes = ImmutableList.builder();
                ImmutableList.Builder columnList = ImmutableList.builder();
                Set rowkeyColumns = tableColumns.stream().filter(col -> PhoenixColumnProperties.isPrimaryKey(col, tableProperties)).collect(Collectors.toSet());
                ImmutableList.Builder pkNames = ImmutableList.builder();
                Optional<String> rowkeyColumn = Optional.empty();
                if (rowkeyColumns.isEmpty()) {
                    columnList.add((Object)"ROWKEY bigint not null");
                    pkNames.add((Object)ROWKEY);
                    this.execute(session, String.format("CREATE SEQUENCE %s", MetadataUtil.getEscapedTableName(schema, table + "_sequence")));
                    rowkeyColumn = Optional.of(ROWKEY);
                }
                for (ColumnMetadata column : tableColumns) {
                    if (column.getComment() != null) {
                        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support creating tables with column comment");
                    }
                    String columnName = this.getIdentifierMapping().toRemoteColumnName(remoteIdentifiers, column.getName());
                    columnNames.add((Object)columnName);
                    columnTypes.add((Object)column.getType());
                    Object typeStatement = this.toWriteMapping(session, column.getType()).getDataType();
                    if (rowkeyColumns.contains(column)) {
                        typeStatement = (String)typeStatement + " not null";
                        pkNames.add((Object)columnName);
                    }
                    columnList.add((Object)String.format("%s %s", SchemaUtil.getEscapedArgument((String)columnName), typeStatement));
                }
                ImmutableList.Builder tableOptions = ImmutableList.builder();
                PhoenixTableProperties.getSaltBuckets(tableProperties).ifPresent(value -> tableOptions.add((Object)(TableProperty.SALT_BUCKETS + "=" + value)));
                PhoenixTableProperties.getSplitOn(tableProperties).ifPresent(value -> tableOptions.add((Object)("SPLIT ON (" + value.replace('\"', '\'') + ")")));
                PhoenixTableProperties.getDisableWal(tableProperties).ifPresent(value -> tableOptions.add((Object)(TableProperty.DISABLE_WAL + "=" + value)));
                PhoenixTableProperties.getDefaultColumnFamily(tableProperties).ifPresent(value -> tableOptions.add((Object)(TableProperty.DEFAULT_COLUMN_FAMILY + "=" + value)));
                PhoenixTableProperties.getBloomfilter(tableProperties).ifPresent(value -> tableOptions.add((Object)("BLOOMFILTER='" + value + "'")));
                PhoenixTableProperties.getVersions(tableProperties).ifPresent(value -> tableOptions.add((Object)("VERSIONS=" + value)));
                PhoenixTableProperties.getMinVersions(tableProperties).ifPresent(value -> tableOptions.add((Object)("MIN_VERSIONS=" + value)));
                PhoenixTableProperties.getCompression(tableProperties).ifPresent(value -> tableOptions.add((Object)("COMPRESSION='" + value + "'")));
                PhoenixTableProperties.getTimeToLive(tableProperties).ifPresent(value -> tableOptions.add((Object)("TTL=" + value)));
                PhoenixTableProperties.getDataBlockEncoding(tableProperties).ifPresent(value -> tableOptions.add((Object)("DATA_BLOCK_ENCODING='" + value + "'")));
                String sql = String.format("CREATE %s TABLE %s (%s , CONSTRAINT PK PRIMARY KEY (%s)) %s", immutable, MetadataUtil.getEscapedTableName(schema, table), String.join((CharSequence)", ", (Iterable<? extends CharSequence>)columnList.build()), String.join((CharSequence)", ", (Iterable<? extends CharSequence>)pkNames.build()), String.join((CharSequence)", ", (Iterable<? extends CharSequence>)tableOptions.build()));
                this.execute(session, sql);
                phoenixOutputTableHandle = new PhoenixOutputTableHandle(schema, table, (List<String>)columnNames.build(), (List<Type>)columnTypes.build(), Optional.empty(), rowkeyColumn);
                if (connection == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == SQLExceptionCode.TABLE_ALREADY_EXIST.getErrorCode()) {
                        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Phoenix table already exists", (Throwable)e);
                    }
                    throw new TrinoException((ErrorCodeSupplier)PhoenixErrorCode.PHOENIX_METADATA_ERROR, "Error creating Phoenix table", (Throwable)e);
                }
            }
            connection.close();
        }
        return phoenixOutputTableHandle;
    }

    protected void renameTable(ConnectorSession session, String catalogName, String schemaName, String tableName, SchemaTableName newTable) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support renaming tables");
    }

    public void renameSchema(ConnectorSession session, String schemaName, String newSchemaName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support renaming schemas");
    }

    public Map<String, Object> getTableProperties(ConnectorSession session, JdbcTableHandle handle) {
        ImmutableMap.Builder properties = ImmutableMap.builder();
        RemoteTableName remoteTableName = handle.getRequiredNamedRelation().getRemoteTableName();
        try (java.sql.Connection connection = this.connectionFactory.openConnection(session);
             Admin admin = connection.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
            HColumnDescriptor[] columnFamilies;
            String schemaName = MetadataUtil.toPhoenixSchemaName(remoteTableName.getSchemaName().orElse(null));
            PTable table = PhoenixRuntime.getTable((java.sql.Connection)connection, (String)SchemaUtil.getTableName((String)schemaName, (String)remoteTableName.getTableName()));
            boolean salted = table.getBucketNum() != null;
            StringJoiner joiner = new StringJoiner(",");
            List pkColumns = table.getPKColumns();
            for (PColumn pkColumn : pkColumns.subList(salted ? 1 : 0, pkColumns.size())) {
                joiner.add(pkColumn.getName().getString());
            }
            properties.put((Object)"rowkeys", (Object)joiner.toString());
            if (table.getBucketNum() != null) {
                properties.put((Object)"salt_buckets", (Object)table.getBucketNum());
            }
            if (table.isWALDisabled()) {
                properties.put((Object)"disable_wal", (Object)table.isWALDisabled());
            }
            if (table.isImmutableRows()) {
                properties.put((Object)"immutable_rows", (Object)table.isImmutableRows());
            }
            String defaultFamilyName = "0";
            if (table.getDefaultFamilyName() != null) {
                defaultFamilyName = table.getDefaultFamilyName().getString();
                properties.put((Object)"default_column_family", (Object)defaultFamilyName);
            }
            HTableDescriptor tableDesc = admin.getTableDescriptor(TableName.valueOf((byte[])table.getPhysicalName().getBytes()));
            for (HColumnDescriptor columnFamily : columnFamilies = tableDesc.getColumnFamilies()) {
                if (!columnFamily.getNameAsString().equals(defaultFamilyName)) continue;
                if (columnFamily.getBloomFilterType() != BloomType.NONE) {
                    properties.put((Object)"bloomfilter", (Object)columnFamily.getBloomFilterType());
                }
                if (columnFamily.getMaxVersions() != 1) {
                    properties.put((Object)"versions", (Object)columnFamily.getMaxVersions());
                }
                if (columnFamily.getMinVersions() > 0) {
                    properties.put((Object)"min_versions", (Object)columnFamily.getMinVersions());
                }
                if (columnFamily.getCompression() != Compression.Algorithm.NONE) {
                    properties.put((Object)"compression", (Object)columnFamily.getCompression());
                }
                if (columnFamily.getTimeToLive() < Integer.MAX_VALUE) {
                    properties.put((Object)"ttl", (Object)columnFamily.getTimeToLive());
                }
                if (columnFamily.getDataBlockEncoding() != DataBlockEncoding.NONE) {
                    properties.put((Object)"data_block_encoding", (Object)columnFamily.getDataBlockEncoding());
                }
                break;
            }
        }
        catch (org.apache.phoenix.schema.TableNotFoundException e) {
            throw new TableNotFoundException(new SchemaTableName((String)remoteTableName.getSchemaName().orElse(null), remoteTableName.getTableName()));
        }
        catch (IOException | SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)PhoenixErrorCode.PHOENIX_METADATA_ERROR, "Couldn't get Phoenix table properties", (Throwable)e);
        }
        return properties.buildOrThrow();
    }

    public void setColumnType(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column, Type type) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support setting column types");
    }

    private static LongReadFunction dateReadFunction() {
        return (resultSet, index) -> LocalDate.parse(new SimpleDateFormat(DATE_FORMAT).format(resultSet.getDate(index)), LOCAL_DATE_FORMATTER).toEpochDay();
    }

    private static LongWriteFunction dateWriteFunctionUsingString() {
        return new LongWriteFunction(){

            public String getBindExpression() {
                return "TO_DATE(?, 'y-MM-dd G', 'local')";
            }

            public void set(PreparedStatement statement, int index, long value) throws SQLException {
                statement.setString(index, LOCAL_DATE_FORMATTER.format(LocalDate.ofEpochDay(value)));
            }
        };
    }

    private static ColumnMapping arrayColumnMapping(ConnectorSession session, ArrayType arrayType, String elementJdbcTypeName, PredicatePushdownController pushdownController) {
        return ColumnMapping.objectMapping((Type)arrayType, (ObjectReadFunction)PhoenixClient.arrayReadFunction(session, arrayType.getElementType()), (ObjectWriteFunction)PhoenixClient.arrayWriteFunction(session, arrayType.getElementType(), elementJdbcTypeName), (PredicatePushdownController)pushdownController);
    }

    private static ObjectReadFunction arrayReadFunction(ConnectorSession session, Type elementType) {
        return ObjectReadFunction.of(Block.class, (resultSet, columnIndex) -> {
            Object[] objectArray = TypeUtils.toBoxedArray(resultSet.getArray(columnIndex).getArray());
            return TypeUtils.jdbcObjectArrayToBlock(session, elementType, objectArray);
        });
    }

    private static ObjectWriteFunction arrayWriteFunction(ConnectorSession session, Type elementType, String elementJdbcTypeName) {
        return ObjectWriteFunction.of(Block.class, (statement, index, block) -> {
            Object[] jdbcObjectArray = TypeUtils.getJdbcObjectArray(session, elementType, block);
            PhoenixArray phoenixArray = (PhoenixArray)statement.getConnection().createArrayOf(elementJdbcTypeName, jdbcObjectArray);
            for (int i = 0; i < jdbcObjectArray.length; ++i) {
                if (jdbcObjectArray[i] != null || phoenixArray.getElement(i) == null) continue;
                throw new TrinoException((ErrorCodeSupplier)PhoenixErrorCode.PHOENIX_QUERY_ERROR, String.format("Phoenix JDBC driver replaced 'null' with '%s' at index %s in %s", phoenixArray.getElement(i), i + 1, phoenixArray));
            }
            statement.setArray(index, (Array)phoenixArray);
        });
    }

    private JdbcTypeHandle getArrayElementTypeHandle(JdbcTypeHandle arrayTypeHandle) {
        String arrayTypeName = (String)arrayTypeHandle.getJdbcTypeName().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)PhoenixErrorCode.PHOENIX_METADATA_ERROR, "Type name is missing for jdbc type: " + JDBCType.valueOf(arrayTypeHandle.getJdbcType())));
        Preconditions.checkArgument((boolean)arrayTypeName.endsWith(" ARRAY"), (Object)"array type must end with ' ARRAY'");
        arrayTypeName = arrayTypeName.substring(0, arrayTypeName.length() - " ARRAY".length());
        Verify.verify((boolean)arrayTypeHandle.getCaseSensitivity().isEmpty(), (String)"Case sensitivity not supported", (Object[])new Object[0]);
        return new JdbcTypeHandle(PDataType.fromSqlTypeName((String)arrayTypeName).getSqlType(), Optional.of(arrayTypeName), arrayTypeHandle.getColumnSize(), arrayTypeHandle.getDecimalDigits(), arrayTypeHandle.getArrayDimensions(), Optional.empty());
    }

    public QueryPlan getQueryPlan(PhoenixPreparedStatement inputQuery) {
        try {
            QueryPlan queryPlan = inputQuery.optimizeQuery();
            queryPlan.iterator((ParallelScanGrouper)MapReduceParallelScanGrouper.getInstance());
            return queryPlan;
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)PhoenixErrorCode.PHOENIX_QUERY_ERROR, "Failed to get the Phoenix query plan", (Throwable)e);
        }
    }

    private static ResultSet getResultSet(PhoenixInputSplit split, QueryPlan queryPlan) {
        List scans = split.getScans();
        try {
            ArrayList<PeekingResultIterator> iterators = new ArrayList<PeekingResultIterator>(scans.size());
            StatementContext context = queryPlan.getContext();
            PName physicalTableName = queryPlan.getTableRef().getTable().getPhysicalName();
            PhoenixConnection phoenixConnection = context.getConnection();
            ConnectionQueryServices services = phoenixConnection.getQueryServices();
            services.clearTableRegionCache(TableName.valueOf((byte[])physicalTableName.getBytes()));
            for (Scan scan : scans) {
                scan = new Scan(scan);
                scan.setAttribute("_SKIP_REGION_BOUNDARY_CHECK", Bytes.toBytes((boolean)true));
                ScanMetricsHolder scanMetricsHolder = ScanMetricsHolder.getInstance((ReadMetricQueue)context.getReadMetricsQueue(), (String)physicalTableName.getString(), (Scan)scan, (LogLevel)phoenixConnection.getLogLevel());
                TableResultIterator tableResultIterator = new TableResultIterator(phoenixConnection.getMutationState(), scan, scanMetricsHolder, services.getRenewLeaseThresholdMilliSeconds(), queryPlan, (ParallelScanGrouper)MapReduceParallelScanGrouper.getInstance());
                iterators.add(LookAheadResultIterator.wrap((ResultIterator)tableResultIterator));
            }
            PeekingResultIterator iterator = ConcatResultIterator.newIterator(iterators);
            if (context.getSequenceManager().getSequenceCount() > 0) {
                iterator = new SequenceResultIterator((ResultIterator)iterator, context.getSequenceManager());
            }
            return new PhoenixResultSet((ResultIterator)iterator, queryPlan.getProjector().cloneIfNecessary(), context);
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)PhoenixErrorCode.PHOENIX_QUERY_ERROR, "Error while setting up Phoenix ResultSet", (Throwable)e);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)PhoenixErrorCode.PHOENIX_INTERNAL_ERROR, "Error while copying scan", (Throwable)e);
        }
    }

    public JdbcTableHandle buildPlainTable(JdbcTableHandle handle) {
        Preconditions.checkArgument((boolean)handle.isNamedRelation(), (Object)"Only allow build plain table from named relation table");
        SchemaTableName schemaTableName = handle.getRequiredNamedRelation().getSchemaTableName();
        RemoteTableName remoteTableName = handle.getRequiredNamedRelation().getRemoteTableName();
        return new JdbcTableHandle(schemaTableName, remoteTableName, Optional.empty());
    }

    public JdbcTableHandle updatedScanColumnTable(ConnectorSession session, ConnectorTableHandle table, Optional<List<JdbcColumnHandle>> originalColumns, JdbcColumnHandle mergeRowIdColumnHandle) {
        JdbcTableHandle tableHandle = (JdbcTableHandle)table;
        if (originalColumns.isEmpty()) {
            return tableHandle;
        }
        List<JdbcColumnHandle> scanColumnHandles = originalColumns.get();
        Preconditions.checkArgument((!scanColumnHandles.isEmpty() ? 1 : 0) != 0, (Object)"Scan columns should not empty");
        Preconditions.checkArgument((boolean)Iterators.tryFind(scanColumnHandles.iterator(), column -> MERGE_ROW_ID_COLUMN_NAME.equalsIgnoreCase(column.getColumnName())).isPresent(), (Object)"Merge row id column must exist in original columns");
        return new JdbcTableHandle(tableHandle.getRelationHandle(), tableHandle.getConstraint(), tableHandle.getConstraintExpressions(), tableHandle.getSortOrder(), tableHandle.getLimit(), Optional.of(this.getUpdatedScanColumnHandles(session, tableHandle, scanColumnHandles, mergeRowIdColumnHandle)), tableHandle.getOtherReferencedTables(), tableHandle.getNextSyntheticColumnId(), tableHandle.getAuthorization(), tableHandle.getUpdateAssignments());
    }

    private List<JdbcColumnHandle> getUpdatedScanColumnHandles(ConnectorSession session, JdbcTableHandle tableHandle, List<JdbcColumnHandle> scanColumnHandles, JdbcColumnHandle mergeRowIdColumnHandle) {
        RowType columnType = (RowType)mergeRowIdColumnHandle.getColumnType();
        List<JdbcColumnHandle> primaryKeyColumnHandles = this.getPrimaryKeyColumnHandles(session, tableHandle);
        Set mergeRowIdFieldNames = (Set)columnType.getFields().stream().map(RowType.Field::getName).filter(Optional::isPresent).map(Optional::get).collect(ImmutableSet.toImmutableSet());
        Set primaryKeyColumnNames = (Set)primaryKeyColumnHandles.stream().map(JdbcColumnHandle::getColumnName).collect(ImmutableSet.toImmutableSet());
        Preconditions.checkArgument((boolean)mergeRowIdFieldNames.containsAll(primaryKeyColumnNames), (Object)"Merge row id fields should contains all primary keys");
        ImmutableList.Builder columnHandleBuilder = ImmutableList.builder();
        scanColumnHandles.stream().filter(jdbcColumnHandle -> !MERGE_ROW_ID_COLUMN_NAME.equalsIgnoreCase(jdbcColumnHandle.getColumnName())).forEach(arg_0 -> ((ImmutableList.Builder)columnHandleBuilder).add(arg_0));
        for (JdbcColumnHandle columnHandle : primaryKeyColumnHandles) {
            String columnName = columnHandle.getColumnName();
            if (ROWKEY.equalsIgnoreCase(columnName)) {
                Preconditions.checkArgument((primaryKeyColumnHandles.size() == 1 ? 1 : 0) != 0, (Object)"Wrong primary keys");
                columnHandleBuilder.add((Object)ROWKEY_COLUMN_HANDLE);
                break;
            }
            if (Iterators.tryFind(scanColumnHandles.iterator(), column -> column.getColumnName().equalsIgnoreCase(columnName)).isPresent()) continue;
            columnHandleBuilder.add((Object)columnHandle);
        }
        return columnHandleBuilder.build();
    }

    public List<JdbcColumnHandle> getPrimaryKeyColumnHandles(ConnectorSession session, JdbcTableHandle tableHandle) {
        if (tableHandle.getColumns().isPresent()) {
            tableHandle = this.buildPlainTable(tableHandle);
        }
        Map<String, Object> tableProperties = this.getTableProperties(session, tableHandle);
        List primaryKeyColumnHandles = (List)this.getColumns(session, tableHandle).stream().filter(columnHandle -> PhoenixColumnProperties.isPrimaryKey(columnHandle.getColumnMetadata(), tableProperties)).collect(ImmutableList.toImmutableList());
        Verify.verify((!primaryKeyColumnHandles.isEmpty() ? 1 : 0) != 0, (String)"Phoenix primary key is empty", (Object[])new Object[0]);
        return primaryKeyColumnHandles;
    }
}

