/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.phoenix5;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcOutputTableHandle;
import io.trino.plugin.jdbc.JdbcPageSink;
import io.trino.plugin.jdbc.WriteFunction;
import io.trino.plugin.jdbc.logging.RemoteQueryModifier;
import io.trino.plugin.phoenix5.PhoenixClient;
import io.trino.plugin.phoenix5.PhoenixMergeTableHandle;
import io.trino.plugin.phoenix5.PhoenixOutputTableHandle;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.RowBlock;
import io.trino.spi.connector.ConnectorMergeSink;
import io.trino.spi.connector.ConnectorMergeTableHandle;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorPageSinkId;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.IntStream;
import org.apache.phoenix.util.SchemaUtil;

public class PhoenixMergeSink
implements ConnectorMergeSink {
    private final String schemaName;
    private final String tableName;
    private final boolean hasRowKey;
    private final int columnCount;
    private final List<String> mergeRowIdFieldNames;
    private final ConnectorPageSink insertSink;
    private final ConnectorPageSink updateSink;
    private final ConnectorPageSink deleteSink;

    public PhoenixMergeSink(PhoenixClient phoenixClient, RemoteQueryModifier remoteQueryModifier, ConnectorSession session, ConnectorMergeTableHandle mergeHandle, ConnectorPageSinkId pageSinkId) {
        PhoenixMergeTableHandle phoenixMergeTableHandle = (PhoenixMergeTableHandle)mergeHandle;
        PhoenixOutputTableHandle phoenixOutputTableHandle = phoenixMergeTableHandle.phoenixOutputTableHandle();
        this.schemaName = phoenixOutputTableHandle.getSchemaName();
        this.tableName = phoenixOutputTableHandle.getTableName();
        this.hasRowKey = phoenixOutputTableHandle.rowkeyColumn().isPresent();
        this.columnCount = phoenixOutputTableHandle.getColumnNames().size();
        this.insertSink = new JdbcPageSink(session, (JdbcOutputTableHandle)phoenixOutputTableHandle, (JdbcClient)phoenixClient, pageSinkId, remoteQueryModifier);
        this.updateSink = this.createUpdateSink(session, phoenixOutputTableHandle, phoenixClient, pageSinkId, remoteQueryModifier);
        ImmutableList.Builder mergeRowIdFieldNamesBuilder = ImmutableList.builder();
        ImmutableList.Builder mergeRowIdFieldTypesBuilder = ImmutableList.builder();
        RowType mergeRowIdColumnType = (RowType)phoenixMergeTableHandle.mergeRowIdColumnHandle().getColumnType();
        for (RowType.Field field : mergeRowIdColumnType.getFields()) {
            Preconditions.checkArgument((boolean)field.getName().isPresent(), (Object)"Merge row id column field must have name");
            mergeRowIdFieldNamesBuilder.add((Object)SchemaUtil.getEscapedArgument((String)((String)field.getName().get())));
            mergeRowIdFieldTypesBuilder.add((Object)field.getType());
        }
        this.mergeRowIdFieldNames = mergeRowIdFieldNamesBuilder.build();
        this.deleteSink = this.createDeleteSink(session, (List<Type>)mergeRowIdFieldTypesBuilder.build(), phoenixClient, pageSinkId, remoteQueryModifier);
    }

    private ConnectorPageSink createUpdateSink(ConnectorSession session, PhoenixOutputTableHandle phoenixOutputTableHandle, PhoenixClient phoenixClient, ConnectorPageSinkId pageSinkId, RemoteQueryModifier remoteQueryModifier) {
        ImmutableList.Builder columnNamesBuilder = ImmutableList.builder();
        ImmutableList.Builder columnTypesBuilder = ImmutableList.builder();
        columnNamesBuilder.addAll((Iterable)phoenixOutputTableHandle.getColumnNames());
        columnTypesBuilder.addAll((Iterable)phoenixOutputTableHandle.getColumnTypes());
        if (this.hasRowKey) {
            columnNamesBuilder.add((Object)"ROWKEY");
            columnTypesBuilder.add((Object)PhoenixClient.ROWKEY_COLUMN_HANDLE.getColumnType());
        }
        PhoenixOutputTableHandle updateOutputTableHandle = new PhoenixOutputTableHandle(this.schemaName, this.tableName, (List<String>)columnNamesBuilder.build(), (List<Type>)columnTypesBuilder.build(), Optional.empty(), Optional.empty());
        return new JdbcPageSink(session, (JdbcOutputTableHandle)updateOutputTableHandle, (JdbcClient)phoenixClient, pageSinkId, remoteQueryModifier);
    }

    private ConnectorPageSink createDeleteSink(ConnectorSession session, List<Type> mergeRowIdFieldTypes, PhoenixClient phoenixClient, ConnectorPageSinkId pageSinkId, RemoteQueryModifier remoteQueryModifier) {
        Preconditions.checkArgument((this.mergeRowIdFieldNames.size() == mergeRowIdFieldTypes.size() ? 1 : 0) != 0, (Object)"Wrong merge row column, columns and types size not match");
        PhoenixOutputTableHandle deleteOutputTableHandle = new PhoenixOutputTableHandle(this.schemaName, this.tableName, this.mergeRowIdFieldNames, mergeRowIdFieldTypes, Optional.empty(), Optional.empty());
        return new DeleteSink(session, deleteOutputTableHandle, (JdbcClient)phoenixClient, pageSinkId, remoteQueryModifier);
    }

    public void storeMergedRows(Page page) {
        Preconditions.checkArgument((page.getChannelCount() == 2 + this.columnCount ? 1 : 0) != 0, (String)"The page size should be 2 + columnCount (%s), but is %s", (int)this.columnCount, (int)page.getChannelCount());
        int positionCount = page.getPositionCount();
        Block operationBlock = page.getBlock(this.columnCount);
        int[] dataChannel = IntStream.range(0, this.columnCount).toArray();
        Page dataPage = page.getColumns(dataChannel);
        int[] insertPositions = new int[positionCount];
        int insertPositionCount = 0;
        int[] deletePositions = new int[positionCount];
        int deletePositionCount = 0;
        int[] updatePositions = new int[positionCount];
        int updatePositionCount = 0;
        block5: for (int position = 0; position < positionCount; ++position) {
            byte operation = TinyintType.TINYINT.getByte(operationBlock, position);
            switch (operation) {
                case 1: {
                    insertPositions[insertPositionCount] = position;
                    ++insertPositionCount;
                    continue block5;
                }
                case 2: {
                    deletePositions[deletePositionCount] = position;
                    ++deletePositionCount;
                    continue block5;
                }
                case 3: {
                    updatePositions[updatePositionCount] = position;
                    ++updatePositionCount;
                    continue block5;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + operation);
                }
            }
        }
        if (insertPositionCount > 0) {
            this.insertSink.appendPage(dataPage.getPositions(insertPositions, 0, insertPositionCount));
        }
        List rowIdFields = RowBlock.getRowFieldsFromBlock((Block)page.getBlock(this.columnCount + 1));
        if (deletePositionCount > 0) {
            Block[] deleteBlocks = new Block[rowIdFields.size()];
            for (int field = 0; field < rowIdFields.size(); ++field) {
                deleteBlocks[field] = ((Block)rowIdFields.get(field)).getPositions(deletePositions, 0, deletePositionCount);
            }
            this.deleteSink.appendPage(new Page(deletePositionCount, deleteBlocks));
        }
        if (updatePositionCount > 0) {
            Page updatePage = dataPage.getPositions(updatePositions, 0, updatePositionCount);
            if (this.hasRowKey) {
                updatePage = updatePage.appendColumn(((Block)rowIdFields.get(0)).getPositions(updatePositions, 0, updatePositionCount));
            }
            this.updateSink.appendPage(updatePage);
        }
    }

    public CompletableFuture<Collection<Slice>> finish() {
        this.insertSink.finish();
        this.deleteSink.finish();
        this.updateSink.finish();
        return CompletableFuture.completedFuture(ImmutableList.of());
    }

    public void abort() {
        this.insertSink.abort();
        this.deleteSink.abort();
        this.updateSink.abort();
    }

    private class DeleteSink
    extends JdbcPageSink {
        public DeleteSink(ConnectorSession session, JdbcOutputTableHandle handle, JdbcClient jdbcClient, ConnectorPageSinkId pageSinkId, RemoteQueryModifier remoteQueryModifier) {
            super(session, handle, jdbcClient, pageSinkId, remoteQueryModifier);
        }

        protected String getSinkSql(JdbcClient jdbcClient, JdbcOutputTableHandle outputTableHandle, List<WriteFunction> columnWriters) {
            List conjuncts = (List)PhoenixMergeSink.this.mergeRowIdFieldNames.stream().map(name -> name + " = ? ").collect(ImmutableList.toImmutableList());
            Preconditions.checkArgument((!conjuncts.isEmpty() ? 1 : 0) != 0, (Object)"Merge row id fields should not empty");
            String whereCondition = Joiner.on((String)" AND ").join((Iterable)conjuncts);
            return String.format("DELETE FROM %s.%s WHERE %s", PhoenixMergeSink.this.schemaName, PhoenixMergeSink.this.tableName, whereCondition);
        }
    }
}

