/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.aggregation;

import com.google.common.base.Verify;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.base.aggregation.AggregateFunctionPatterns;
import io.trino.plugin.base.aggregation.AggregateFunctionRule;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcExpression;
import io.trino.plugin.jdbc.expression.ParameterizedExpression;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Variable;
import io.trino.spi.type.CharType;
import io.trino.spi.type.VarcharType;
import java.util.Optional;
import java.util.Set;

public class ImplementMinMax
implements AggregateFunctionRule<JdbcExpression, ParameterizedExpression> {
    private static final Capture<Variable> ARGUMENT = Capture.newCapture();
    private final boolean isRemoteCollationSensitive;

    public ImplementMinMax(boolean isRemoteCollationSensitive) {
        this.isRemoteCollationSensitive = isRemoteCollationSensitive;
    }

    public Pattern<AggregateFunction> getPattern() {
        return AggregateFunctionPatterns.basicAggregation().with(AggregateFunctionPatterns.functionName().matching(Set.of("min", "max")::contains)).with(AggregateFunctionPatterns.singleArgument().matching(AggregateFunctionPatterns.variable().capturedAs(ARGUMENT)));
    }

    public Optional<JdbcExpression> rewrite(AggregateFunction aggregateFunction, Captures captures, AggregateFunctionRule.RewriteContext<ParameterizedExpression> context) {
        Variable argument = (Variable)captures.get(ARGUMENT);
        JdbcColumnHandle columnHandle = (JdbcColumnHandle)context.getAssignment(argument.getName());
        Verify.verify((boolean)columnHandle.getColumnType().equals(aggregateFunction.getOutputType()));
        if (!this.isRemoteCollationSensitive && (columnHandle.getColumnType() instanceof CharType || columnHandle.getColumnType() instanceof VarcharType)) {
            return Optional.empty();
        }
        ParameterizedExpression rewrittenArgument = (ParameterizedExpression)context.rewriteExpression((ConnectorExpression)argument).orElseThrow();
        return Optional.of(new JdbcExpression(String.format("%s(%s)", aggregateFunction.getFunctionName(), rewrittenArgument.expression()), rewrittenArgument.parameters(), columnHandle.getJdbcTypeHandle()));
    }
}

