/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.classloader;

import com.google.common.collect.AbstractIterator;
import io.trino.spi.classloader.ThreadContextClassLoader;
import java.util.Iterator;
import java.util.Objects;

public final class ClassLoaderSafeIterator<T>
extends AbstractIterator<T> {
    private final Iterator<T> delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeIterator(Iterator<T> delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    protected T computeNext() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            if (!this.delegate.hasNext()) {
                Object object = this.endOfData();
                return (T)object;
            }
            T t = this.delegate.next();
            return t;
        }
    }
}

