/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.phoenix5;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.plugin.base.ClosingBinder;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorMetadata;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorPageSinkProvider;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorPageSourceProvider;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorSplitManager;
import io.trino.plugin.base.classloader.ForClassLoaderSafe;
import io.trino.plugin.base.mapping.IdentifierMappingModule;
import io.trino.plugin.jdbc.ConfiguringConnectionFactory;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DecimalModule;
import io.trino.plugin.jdbc.DefaultQueryBuilder;
import io.trino.plugin.jdbc.DriverConnectionFactory;
import io.trino.plugin.jdbc.DynamicFilteringStats;
import io.trino.plugin.jdbc.ForBaseJdbc;
import io.trino.plugin.jdbc.ForJdbcDynamicFiltering;
import io.trino.plugin.jdbc.ForRecordCursor;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcDiagnosticModule;
import io.trino.plugin.jdbc.JdbcDynamicFilteringConfig;
import io.trino.plugin.jdbc.JdbcDynamicFilteringSessionProperties;
import io.trino.plugin.jdbc.JdbcDynamicFilteringSplitManager;
import io.trino.plugin.jdbc.JdbcMetadataConfig;
import io.trino.plugin.jdbc.JdbcMetadataSessionProperties;
import io.trino.plugin.jdbc.JdbcModule;
import io.trino.plugin.jdbc.JdbcWriteConfig;
import io.trino.plugin.jdbc.JdbcWriteSessionProperties;
import io.trino.plugin.jdbc.LazyConnectionFactory;
import io.trino.plugin.jdbc.MaxDomainCompactionThreshold;
import io.trino.plugin.jdbc.QueryBuilder;
import io.trino.plugin.jdbc.RetryingConnectionFactoryModule;
import io.trino.plugin.jdbc.ReusableConnectionFactoryModule;
import io.trino.plugin.jdbc.StatsCollecting;
import io.trino.plugin.jdbc.TimestampTimeZoneDomain;
import io.trino.plugin.jdbc.TypeHandlingJdbcConfig;
import io.trino.plugin.jdbc.TypeHandlingJdbcSessionProperties;
import io.trino.plugin.jdbc.credential.CredentialProvider;
import io.trino.plugin.jdbc.credential.EmptyCredentialProvider;
import io.trino.plugin.jdbc.logging.RemoteQueryModifierModule;
import io.trino.plugin.phoenix5.ConfigurationInstantiator;
import io.trino.plugin.phoenix5.PhoenixClient;
import io.trino.plugin.phoenix5.PhoenixColumnProperties;
import io.trino.plugin.phoenix5.PhoenixConfig;
import io.trino.plugin.phoenix5.PhoenixConnector;
import io.trino.plugin.phoenix5.PhoenixErrorCode;
import io.trino.plugin.phoenix5.PhoenixMetadata;
import io.trino.plugin.phoenix5.PhoenixPageSinkProvider;
import io.trino.plugin.phoenix5.PhoenixPageSourceProvider;
import io.trino.plugin.phoenix5.PhoenixSessionProperties;
import io.trino.plugin.phoenix5.PhoenixSplitManager;
import io.trino.plugin.phoenix5.PhoenixTableProperties;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSplitManager;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.phoenix.jdbc.PhoenixDriver;
import org.apache.phoenix.jdbc.PhoenixEmbeddedDriver;
import org.weakref.jmx.guice.ExportBinder;

public class PhoenixClientModule
extends AbstractConfigurationAwareModule {
    private final String catalogName;

    public PhoenixClientModule(String catalogName) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
    }

    protected void setup(Binder binder) {
        this.install((Module)new RemoteQueryModifierModule());
        this.install((Module)new RetryingConnectionFactoryModule());
        binder.bind(ConnectorSplitManager.class).annotatedWith(ForJdbcDynamicFiltering.class).to(PhoenixSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorSplitManager.class).annotatedWith(ForClassLoaderSafe.class).to(JdbcDynamicFilteringSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorSplitManager.class).to(ClassLoaderSafeConnectorSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorPageSinkProvider.class).annotatedWith(ForClassLoaderSafe.class).to(PhoenixPageSinkProvider.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorPageSinkProvider.class).to(ClassLoaderSafeConnectorPageSinkProvider.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorPageSourceProvider.class).annotatedWith(ForClassLoaderSafe.class).to(PhoenixPageSourceProvider.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorPageSourceProvider.class).to(ClassLoaderSafeConnectorPageSourceProvider.class).in(Scopes.SINGLETON);
        binder.bind(QueryBuilder.class).to(DefaultQueryBuilder.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get(Integer.TYPE, MaxDomainCompactionThreshold.class));
        ConfigBinder.configBinder((Binder)binder).bindConfigDefaults(JdbcMetadataConfig.class, config -> config.setDomainCompactionThreshold(5000));
        ConfigBinder.configBinder((Binder)binder).bindConfig(TypeHandlingJdbcConfig.class);
        JdbcModule.bindSessionPropertiesProvider((Binder)binder, TypeHandlingJdbcSessionProperties.class);
        JdbcModule.bindSessionPropertiesProvider((Binder)binder, JdbcMetadataSessionProperties.class);
        JdbcModule.bindSessionPropertiesProvider((Binder)binder, JdbcWriteSessionProperties.class);
        JdbcModule.bindSessionPropertiesProvider((Binder)binder, PhoenixSessionProperties.class);
        JdbcModule.bindSessionPropertiesProvider((Binder)binder, JdbcDynamicFilteringSessionProperties.class);
        binder.bind(DynamicFilteringStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(DynamicFilteringStats.class).as(generator -> generator.generatedNameOf(DynamicFilteringStats.class, this.catalogName));
        ConfigBinder.configBinder((Binder)binder).bindConfig(JdbcMetadataConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(JdbcWriteConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(JdbcDynamicFilteringConfig.class);
        binder.bind(PhoenixClient.class).in(Scopes.SINGLETON);
        binder.bind(JdbcClient.class).annotatedWith(ForBaseJdbc.class).to(Key.get(PhoenixClient.class)).in(Scopes.SINGLETON);
        binder.bind(JdbcClient.class).to(Key.get(JdbcClient.class, StatsCollecting.class)).in(Scopes.SINGLETON);
        binder.bind(ConnectorMetadata.class).annotatedWith(ForClassLoaderSafe.class).to(PhoenixMetadata.class).in(Scopes.SINGLETON);
        binder.bind(TimestampTimeZoneDomain.class).toInstance((Object)TimestampTimeZoneDomain.ANY);
        binder.bind(ConnectorMetadata.class).to(ClassLoaderSafeConnectorMetadata.class).in(Scopes.SINGLETON);
        this.install(ConditionalModule.conditionalModule(PhoenixConfig.class, PhoenixConfig::isReuseConnection, (Module)new ReusableConnectionFactoryModule(), innerBinder -> innerBinder.bind(ConnectionFactory.class).to(LazyConnectionFactory.class).in(Scopes.SINGLETON)));
        JdbcModule.bindTablePropertiesProvider((Binder)binder, PhoenixTableProperties.class);
        binder.bind(PhoenixColumnProperties.class).in(Scopes.SINGLETON);
        binder.bind(PhoenixConnector.class).in(Scopes.SINGLETON);
        this.checkConfiguration(((PhoenixConfig)this.buildConfigObject(PhoenixConfig.class)).getConnectionUrl());
        this.install((Module)new JdbcDiagnosticModule());
        this.install((Module)new IdentifierMappingModule());
        this.install((Module)new DecimalModule());
        ClosingBinder.closingBinder((Binder)binder).registerExecutor(Key.get(ExecutorService.class, ForRecordCursor.class));
    }

    private void checkConfiguration(String connectionUrl) {
        try {
            PhoenixDriver driver = PhoenixDriver.INSTANCE;
            Preconditions.checkArgument((boolean)driver.acceptsURL(connectionUrl), (Object)"Invalid JDBC URL for Phoenix connector");
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)PhoenixErrorCode.PHOENIX_CONFIG_ERROR, (Throwable)e);
        }
    }

    @Provides
    @Singleton
    @ForBaseJdbc
    public ConnectionFactory getConnectionFactory(PhoenixConfig config, OpenTelemetry openTelemetry) throws SQLException {
        return new ConfiguringConnectionFactory((ConnectionFactory)DriverConnectionFactory.builder((Driver)PhoenixDriver.INSTANCE, (String)config.getConnectionUrl(), (CredentialProvider)new EmptyCredentialProvider()).setConnectionProperties(PhoenixClientModule.getConnectionProperties(config)).setOpenTelemetry(openTelemetry).build(), connection -> connection.setAutoCommit(true));
    }

    public static Properties getConnectionProperties(PhoenixConfig config) throws SQLException {
        Configuration resourcesConfig = PhoenixClientModule.readConfig(config);
        Properties connectionProperties = new Properties();
        for (Map.Entry entry : resourcesConfig) {
            connectionProperties.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        PhoenixEmbeddedDriver.ConnectionInfo connectionInfo = PhoenixEmbeddedDriver.ConnectionInfo.create((String)config.getConnectionUrl());
        connectionInfo.asProps().asMap().forEach(connectionProperties::setProperty);
        return connectionProperties;
    }

    private static Configuration readConfig(PhoenixConfig config) {
        Configuration result = ConfigurationInstantiator.newEmptyConfiguration();
        for (String resourcePath : config.getResourceConfigFiles()) {
            result.addResource(new Path(resourcePath));
        }
        return result;
    }

    @Singleton
    @ForRecordCursor
    @Provides
    public ExecutorService createRecordCursorExecutor() {
        return MoreExecutors.newDirectExecutorService();
    }
}

