/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;

public class JdbcWriteConfig {
    public static final int MAX_ALLOWED_WRITE_BATCH_SIZE = 10000000;
    static final int DEFAULT_WRITE_PARALLELISM = 8;
    private int writeBatchSize = 1000;
    private int writeParallelism = 8;
    private boolean nonTransactionalInsert;

    @Min(value=1L)
    @Max(value=10000000L)
    public @Min(value=1L) @Max(value=10000000L) int getWriteBatchSize() {
        return this.writeBatchSize;
    }

    @Config(value="write.batch-size")
    @ConfigDescription(value="Maximum number of rows to write in a single batch")
    public JdbcWriteConfig setWriteBatchSize(int writeBatchSize) {
        this.writeBatchSize = writeBatchSize;
        return this;
    }

    public boolean isNonTransactionalInsert() {
        return this.nonTransactionalInsert;
    }

    @Config(value="insert.non-transactional-insert.enabled")
    @ConfigDescription(value="Do not create temporary table during insert. This means that the write operation can fail and leave the table in an inconsistent state.")
    public JdbcWriteConfig setNonTransactionalInsert(boolean nonTransactionalInsert) {
        this.nonTransactionalInsert = nonTransactionalInsert;
        return this;
    }

    @Min(value=1L)
    @Max(value=128L)
    public @Min(value=1L) @Max(value=128L) int getWriteParallelism() {
        return this.writeParallelism;
    }

    @Config(value="write.parallelism")
    @ConfigDescription(value="Maximum number of parallel write tasks")
    public JdbcWriteConfig setWriteParallelism(int writeParallelism) {
        this.writeParallelism = writeParallelism;
        return this;
    }
}

