/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.base.Throwables;
import com.google.inject.Inject;
import dev.failsafe.Failsafe;
import dev.failsafe.FailsafeException;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.jmx.StatisticsAwareConnectionFactory;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLTransientException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Set;

public class RetryingConnectionFactory
implements ConnectionFactory {
    private final RetryPolicy<Object> retryPolicy;
    private final ConnectionFactory delegate;

    @Inject
    public RetryingConnectionFactory(StatisticsAwareConnectionFactory delegate, Set<RetryStrategy> retryStrategies) {
        Objects.requireNonNull(retryStrategies);
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.retryPolicy = ((RetryPolicyBuilder)RetryPolicy.builder().withMaxDuration(Duration.of(30L, ChronoUnit.SECONDS)).withMaxAttempts(5).withBackoff(50L, 5000L, ChronoUnit.MILLIS, 4.0).handleIf(throwable -> RetryingConnectionFactory.isExceptionRecoverable(retryStrategies, throwable))).abortOn(TrinoException.class).build();
    }

    private static boolean isExceptionRecoverable(Set<RetryStrategy> retryStrategies, Throwable throwable) {
        return retryStrategies.stream().anyMatch(retryStrategy -> retryStrategy.isExceptionRecoverable(throwable));
    }

    @Override
    public Connection openConnection(ConnectorSession session) throws SQLException {
        try {
            return (Connection)Failsafe.with(this.retryPolicy, (Policy[])new RetryPolicy[0]).get(() -> this.delegate.openConnection(session));
        }
        catch (FailsafeException ex) {
            if (ex.getCause() instanceof SQLException) {
                throw (SQLException)ex.getCause();
            }
            throw ex;
        }
    }

    @Override
    public void close() throws SQLException {
        this.delegate.close();
    }

    public static interface RetryStrategy {
        public boolean isExceptionRecoverable(Throwable var1);
    }

    public static class DefaultRetryStrategy
    implements RetryStrategy {
        @Override
        public boolean isExceptionRecoverable(Throwable exception) {
            return Throwables.getCausalChain((Throwable)exception).stream().anyMatch(SQLTransientException.class::isInstance);
        }
    }
}

