/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.expression;

import com.google.common.collect.ImmutableList;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.base.expression.ConnectorExpressionPatterns;
import io.trino.plugin.base.expression.ConnectorExpressionRule;
import io.trino.plugin.jdbc.QueryParameter;
import io.trino.plugin.jdbc.expression.ParameterizedExpression;
import io.trino.spi.expression.Constant;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Optional;

public class RewriteVarcharConstant
implements ConnectorExpressionRule<Constant, ParameterizedExpression> {
    private static final Pattern<Constant> PATTERN = ConnectorExpressionPatterns.constant().with(ConnectorExpressionPatterns.type().matching(VarcharType.class::isInstance));

    public Pattern<Constant> getPattern() {
        return PATTERN;
    }

    public Optional<ParameterizedExpression> rewrite(Constant constant, Captures captures, ConnectorExpressionRule.RewriteContext<ParameterizedExpression> context) {
        Object value = constant.getValue();
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(new ParameterizedExpression("?", (List<QueryParameter>)ImmutableList.of((Object)new QueryParameter(constant.getType(), Optional.of(value)))));
    }
}

