/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.jdbc.JdbcWriteConfig;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.session.PropertyMetadata;
import java.util.List;

public class JdbcWriteSessionProperties
implements SessionPropertiesProvider {
    public static final String WRITE_BATCH_SIZE = "write_batch_size";
    public static final String NON_TRANSACTIONAL_INSERT = "non_transactional_insert";
    public static final String WRITE_PARALLELISM = "write_parallelism";
    private final List<PropertyMetadata<?>> properties;

    @Inject
    public JdbcWriteSessionProperties(JdbcWriteConfig writeConfig) {
        this.properties = ImmutableList.builder().add((Object)PropertyMetadata.integerProperty((String)WRITE_BATCH_SIZE, (String)"Maximum number of rows to write in a single batch", (Integer)writeConfig.getWriteBatchSize(), JdbcWriteSessionProperties::validateWriteBatchSize, (boolean)false)).add((Object)PropertyMetadata.booleanProperty((String)NON_TRANSACTIONAL_INSERT, (String)"Do not use temporary table on insert to table", (Boolean)writeConfig.isNonTransactionalInsert(), (boolean)false)).add((Object)PropertyMetadata.integerProperty((String)WRITE_PARALLELISM, (String)"Maximum number of parallel write tasks", (Integer)writeConfig.getWriteParallelism(), (boolean)false)).build();
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.properties;
    }

    public static int getWriteBatchSize(ConnectorSession session) {
        return (Integer)session.getProperty(WRITE_BATCH_SIZE, Integer.class);
    }

    public static int getWriteParallelism(ConnectorSession session) {
        return (Integer)session.getProperty(WRITE_PARALLELISM, Integer.class);
    }

    public static boolean isNonTransactionalInsert(ConnectorSession session) {
        return (Boolean)session.getProperty(NON_TRANSACTIONAL_INSERT, Boolean.class);
    }

    private static void validateWriteBatchSize(int maxBatchSize) {
        if (maxBatchSize < 1) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be greater than 0: %s", WRITE_BATCH_SIZE, maxBatchSize));
        }
        if (maxBatchSize > 10000000) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s cannot exceed %s: %s", WRITE_BATCH_SIZE, 10000000, maxBatchSize));
        }
    }
}

