/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.aggregation;

import com.google.common.base.Verify;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.base.aggregation.AggregateFunctionPatterns;
import io.trino.plugin.base.aggregation.AggregateFunctionRule;
import io.trino.plugin.base.expression.ConnectorExpressionPatterns;
import io.trino.plugin.jdbc.JdbcExpression;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.expression.ParameterizedExpression;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Variable;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import java.util.Optional;

public abstract class BaseImplementAvgBigint
implements AggregateFunctionRule<JdbcExpression, ParameterizedExpression> {
    private final Capture<Variable> argument = Capture.newCapture();

    public Pattern<AggregateFunction> getPattern() {
        return AggregateFunctionPatterns.basicAggregation().with(AggregateFunctionPatterns.functionName().equalTo((Object)"avg")).with(AggregateFunctionPatterns.singleArgument().matching(ConnectorExpressionPatterns.variable().with(ConnectorExpressionPatterns.type().matching(type -> type == BigintType.BIGINT)).capturedAs(this.argument)));
    }

    public Optional<JdbcExpression> rewrite(AggregateFunction aggregateFunction, Captures captures, AggregateFunctionRule.RewriteContext<ParameterizedExpression> context) {
        Variable argument = (Variable)captures.get(this.argument);
        Verify.verify((aggregateFunction.getOutputType() == DoubleType.DOUBLE ? 1 : 0) != 0);
        ParameterizedExpression rewrittenArgument = (ParameterizedExpression)context.rewriteExpression((ConnectorExpression)argument).orElseThrow();
        return Optional.of(new JdbcExpression(String.format(this.getRewriteFormatExpression(), rewrittenArgument.expression()), rewrittenArgument.parameters(), new JdbcTypeHandle(8, Optional.of("double"), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty())));
    }

    protected abstract String getRewriteFormatExpression();
}

