/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.credential;

import com.google.common.collect.ImmutableMap;
import io.trino.plugin.jdbc.credential.CredentialPropertiesProvider;
import io.trino.plugin.jdbc.credential.CredentialProvider;
import io.trino.spi.security.ConnectorIdentity;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DefaultCredentialPropertiesProvider
implements CredentialPropertiesProvider {
    private final CredentialProvider provider;

    public DefaultCredentialPropertiesProvider(CredentialProvider provider) {
        this.provider = Objects.requireNonNull(provider, "provider is null");
    }

    @Override
    public Map<String, Object> getCredentialProperties(ConnectorIdentity identity) {
        ImmutableMap.Builder properties = ImmutableMap.builder();
        this.provider.getConnectionUser(Optional.of(identity)).ifPresent(user -> properties.put((Object)"user", user));
        this.provider.getConnectionPassword(Optional.of(identity)).ifPresent(password -> properties.put((Object)"password", password));
        return properties.buildOrThrow();
    }
}

