/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.phoenix5;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcErrorCode;
import io.trino.plugin.jdbc.JdbcOutputTableHandle;
import io.trino.plugin.jdbc.JdbcPageSink;
import io.trino.plugin.jdbc.QueryBuilder;
import io.trino.plugin.jdbc.SinkSqlProvider;
import io.trino.plugin.jdbc.logging.RemoteQueryModifier;
import io.trino.plugin.phoenix5.PhoenixClient;
import io.trino.plugin.phoenix5.PhoenixMergeTableHandle;
import io.trino.plugin.phoenix5.PhoenixOutputTableHandle;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.RowBlock;
import io.trino.spi.connector.ConnectorMergeSink;
import io.trino.spi.connector.ConnectorMergeTableHandle;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorPageSinkId;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.IntStream;
import org.apache.phoenix.util.SchemaUtil;

public class PhoenixMergeSink
implements ConnectorMergeSink {
    private final boolean hasRowKey;
    private final int columnCount;
    private final ConnectorPageSink insertSink;
    private final ConnectorPageSink updateSink;
    private final ConnectorPageSink deleteSink;

    public PhoenixMergeSink(ConnectorSession session, ConnectorMergeTableHandle mergeHandle, PhoenixClient phoenixClient, ConnectorPageSinkId pageSinkId, RemoteQueryModifier remoteQueryModifier, QueryBuilder queryBuilder) {
        PhoenixMergeTableHandle phoenixMergeTableHandle = (PhoenixMergeTableHandle)mergeHandle;
        PhoenixOutputTableHandle phoenixOutputTableHandle = phoenixMergeTableHandle.phoenixOutputTableHandle();
        this.hasRowKey = phoenixOutputTableHandle.rowkeyColumn().isPresent();
        this.columnCount = phoenixOutputTableHandle.getColumnNames().size();
        this.insertSink = new JdbcPageSink(session, (JdbcOutputTableHandle)phoenixOutputTableHandle, (JdbcClient)phoenixClient, pageSinkId, remoteQueryModifier, JdbcClient::buildInsertSql);
        this.updateSink = PhoenixMergeSink.createUpdateSink(session, phoenixOutputTableHandle, phoenixClient, pageSinkId, remoteQueryModifier);
        ImmutableList.Builder mergeRowIdFieldNamesBuilder = ImmutableList.builder();
        ImmutableList.Builder mergeRowIdFieldTypesBuilder = ImmutableList.builder();
        RowType mergeRowIdColumnType = (RowType)phoenixMergeTableHandle.mergeRowIdColumnHandle().getColumnType();
        for (RowType.Field field : mergeRowIdColumnType.getFields()) {
            Preconditions.checkArgument((boolean)field.getName().isPresent(), (Object)"Merge row id column field must have name");
            mergeRowIdFieldNamesBuilder.add((Object)SchemaUtil.getEscapedArgument((String)((String)field.getName().get())));
            mergeRowIdFieldTypesBuilder.add((Object)field.getType());
        }
        ImmutableList mergeRowIdFieldNames = mergeRowIdFieldNamesBuilder.build();
        this.deleteSink = PhoenixMergeSink.createDeleteSink(session, (List<Type>)mergeRowIdFieldTypesBuilder.build(), phoenixClient, phoenixMergeTableHandle, (List<String>)mergeRowIdFieldNames, pageSinkId, remoteQueryModifier, queryBuilder);
    }

    private static ConnectorPageSink createUpdateSink(ConnectorSession session, PhoenixOutputTableHandle phoenixOutputTableHandle, PhoenixClient phoenixClient, ConnectorPageSinkId pageSinkId, RemoteQueryModifier remoteQueryModifier) {
        ImmutableList.Builder columnNamesBuilder = ImmutableList.builder();
        ImmutableList.Builder columnTypesBuilder = ImmutableList.builder();
        columnNamesBuilder.addAll((Iterable)phoenixOutputTableHandle.getColumnNames());
        columnTypesBuilder.addAll((Iterable)phoenixOutputTableHandle.getColumnTypes());
        if (phoenixOutputTableHandle.rowkeyColumn().isPresent()) {
            columnNamesBuilder.add((Object)"ROWKEY");
            columnTypesBuilder.add((Object)PhoenixClient.ROWKEY_COLUMN_HANDLE.getColumnType());
        }
        PhoenixOutputTableHandle updateOutputTableHandle = new PhoenixOutputTableHandle(phoenixOutputTableHandle.getRemoteTableName(), (List<String>)columnNamesBuilder.build(), (List<Type>)columnTypesBuilder.build(), Optional.empty(), Optional.empty());
        return new JdbcPageSink(session, (JdbcOutputTableHandle)updateOutputTableHandle, (JdbcClient)phoenixClient, pageSinkId, remoteQueryModifier, JdbcClient::buildInsertSql);
    }

    private static ConnectorPageSink createDeleteSink(ConnectorSession session, List<Type> mergeRowIdFieldTypes, PhoenixClient phoenixClient, PhoenixMergeTableHandle tableHandle, List<String> mergeRowIdFieldNames, ConnectorPageSinkId pageSinkId, RemoteQueryModifier remoteQueryModifier, QueryBuilder queryBuilder) {
        Preconditions.checkArgument((mergeRowIdFieldNames.size() == mergeRowIdFieldTypes.size() ? 1 : 0) != 0, (Object)"Wrong merge row column, columns and types size not match");
        PhoenixOutputTableHandle deleteOutputTableHandle = new PhoenixOutputTableHandle(tableHandle.phoenixOutputTableHandle().getRemoteTableName(), mergeRowIdFieldNames, mergeRowIdFieldTypes, Optional.empty(), Optional.empty());
        return new JdbcPageSink(session, (JdbcOutputTableHandle)deleteOutputTableHandle, (JdbcClient)phoenixClient, pageSinkId, remoteQueryModifier, PhoenixMergeSink.deleteSinkProvider(session, tableHandle, (JdbcClient)phoenixClient, queryBuilder));
    }

    private static SinkSqlProvider deleteSinkProvider(ConnectorSession session, PhoenixMergeTableHandle handle, JdbcClient jdbcClient, QueryBuilder queryBuilder) {
        SinkSqlProvider sinkSqlProvider;
        block8: {
            Connection connection = jdbcClient.getConnection(session);
            try {
                sinkSqlProvider = (jdbcClient2, jdbcOutputTableHandle, list) -> queryBuilder.prepareDeleteQuery(jdbcClient, session, connection, handle.tableHandle().getRequiredNamedRelation(), handle.primaryKeysDomain(), Optional.empty()).query();
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
                }
            }
            connection.close();
        }
        return sinkSqlProvider;
    }

    public void storeMergedRows(Page page) {
        Preconditions.checkArgument((page.getChannelCount() == 2 + this.columnCount ? 1 : 0) != 0, (String)"The page size should be 2 + columnCount (%s), but is %s", (int)this.columnCount, (int)page.getChannelCount());
        int positionCount = page.getPositionCount();
        Block operationBlock = page.getBlock(this.columnCount);
        int[] dataChannel = IntStream.range(0, this.columnCount).toArray();
        Page dataPage = page.getColumns(dataChannel);
        int[] insertPositions = new int[positionCount];
        int insertPositionCount = 0;
        int[] deletePositions = new int[positionCount];
        int deletePositionCount = 0;
        int[] updatePositions = new int[positionCount];
        int updatePositionCount = 0;
        block5: for (int position = 0; position < positionCount; ++position) {
            byte operation = TinyintType.TINYINT.getByte(operationBlock, position);
            switch (operation) {
                case 1: {
                    insertPositions[insertPositionCount] = position;
                    ++insertPositionCount;
                    continue block5;
                }
                case 2: {
                    deletePositions[deletePositionCount] = position;
                    ++deletePositionCount;
                    continue block5;
                }
                case 3: {
                    updatePositions[updatePositionCount] = position;
                    ++updatePositionCount;
                    continue block5;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + operation);
                }
            }
        }
        if (insertPositionCount > 0) {
            this.insertSink.appendPage(dataPage.getPositions(insertPositions, 0, insertPositionCount));
        }
        List rowIdFields = RowBlock.getRowFieldsFromBlock((Block)page.getBlock(this.columnCount + 1));
        if (deletePositionCount > 0) {
            Block[] deleteBlocks = new Block[rowIdFields.size()];
            for (int field = 0; field < rowIdFields.size(); ++field) {
                deleteBlocks[field] = ((Block)rowIdFields.get(field)).getPositions(deletePositions, 0, deletePositionCount);
            }
            this.deleteSink.appendPage(new Page(deletePositionCount, deleteBlocks));
        }
        if (updatePositionCount > 0) {
            Page updatePage = dataPage.getPositions(updatePositions, 0, updatePositionCount);
            if (this.hasRowKey) {
                updatePage = updatePage.appendColumn(((Block)rowIdFields.get(0)).getPositions(updatePositions, 0, updatePositionCount));
            }
            this.updateSink.appendPage(updatePage);
        }
    }

    public CompletableFuture<Collection<Slice>> finish() {
        this.insertSink.finish();
        this.deleteSink.finish();
        this.updateSink.finish();
        return CompletableFuture.completedFuture(ImmutableList.of());
    }

    public void abort() {
        this.insertSink.abort();
        this.deleteSink.abort();
        this.updateSink.abort();
    }
}

