/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.phoenix5;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import io.trino.plugin.jdbc.ForRecordCursor;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcRecordSetProvider;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.phoenix5.PhoenixClient;
import io.trino.plugin.phoenix5.PhoenixPageSource;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.RecordPageSource;
import io.trino.spi.type.RowType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;

public class PhoenixPageSourceProvider
implements ConnectorPageSourceProvider {
    private final JdbcRecordSetProvider recordSetProvider;
    private final PhoenixClient phoenixClient;

    @Inject
    public PhoenixPageSourceProvider(PhoenixClient phoenixClient, @ForRecordCursor ExecutorService executor) {
        this.recordSetProvider = new JdbcRecordSetProvider((JdbcClient)phoenixClient, executor);
        this.phoenixClient = Objects.requireNonNull(phoenixClient, "phoenixClient is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<ColumnHandle> columns, DynamicFilter dynamicFilter) {
        JdbcTableHandle tableHandle = (JdbcTableHandle)table;
        List columnHandles = (List)columns.stream().map(JdbcColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
        int mergeRowIdChannel = Iterators.indexOf(columnHandles.iterator(), column -> column.getColumnName().equalsIgnoreCase("$merge_row_id"));
        Optional scanColumnHandles = Optional.of(columnHandles);
        if (mergeRowIdChannel != -1) {
            JdbcColumnHandle mergeRowIdColumn = (JdbcColumnHandle)columnHandles.get(mergeRowIdChannel);
            tableHandle = this.phoenixClient.updatedScanColumnTable(session, (ConnectorTableHandle)tableHandle, scanColumnHandles, mergeRowIdColumn);
            scanColumnHandles = tableHandle.getColumns();
        }
        return new PhoenixPageSource((ConnectorPageSource)new RecordPageSource(this.recordSetProvider.getRecordSet(transaction, session, split, (ConnectorTableHandle)tableHandle, scanColumnHandles.orElse((List<JdbcColumnHandle>)ImmutableList.of()))), this.getColumnAdaptations(scanColumnHandles, mergeRowIdChannel, columnHandles));
    }

    private List<PhoenixPageSource.ColumnAdaptation> getColumnAdaptations(Optional<List<JdbcColumnHandle>> scanColumnHandles, int mergeRowIdChannel, List<JdbcColumnHandle> columnHandles) {
        if (mergeRowIdChannel == -1) {
            return ImmutableList.of();
        }
        List<JdbcColumnHandle> scanColumns = scanColumnHandles.get();
        Preconditions.checkArgument((!scanColumns.isEmpty() ? 1 : 0) != 0, (Object)"Scan column handles is empty");
        JdbcColumnHandle mergeRowIdColumn = columnHandles.get(mergeRowIdChannel);
        ImmutableList.Builder columnAdaptationBuilder = ImmutableList.builder();
        for (int index = 0; index < scanColumns.size(); ++index) {
            if (mergeRowIdChannel == index) {
                columnAdaptationBuilder.add((Object)this.buildMergeIdColumnAdaptation(scanColumns, mergeRowIdColumn));
            }
            columnAdaptationBuilder.add((Object)PhoenixPageSource.ColumnAdaptation.sourceColumn(index));
        }
        if (mergeRowIdChannel == scanColumns.size()) {
            columnAdaptationBuilder.add((Object)this.buildMergeIdColumnAdaptation(scanColumns, mergeRowIdColumn));
        }
        return columnAdaptationBuilder.build();
    }

    private PhoenixPageSource.ColumnAdaptation buildMergeIdColumnAdaptation(List<JdbcColumnHandle> scanColumns, JdbcColumnHandle mergeRowIdColumn) {
        RowType columnType = (RowType)mergeRowIdColumn.getColumnType();
        List mergeRowIdSourceChannels = (List)columnType.getFields().stream().map(RowType.Field::getName).map(Optional::get).map(fieldName -> Iterators.indexOf(scanColumns.iterator(), handle -> handle.getColumnName().equals(fieldName))).peek(fieldIndex -> Preconditions.checkArgument((fieldIndex != -1 ? 1 : 0) != 0, (Object)"Merge row id field must exist in scanned columns")).collect(ImmutableList.toImmutableList());
        return PhoenixPageSource.ColumnAdaptation.mergedRowColumns(mergeRowIdSourceChannels);
    }
}

