/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.phoenix5;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.phoenix5.PhoenixClient;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.sql.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;

public final class TypeUtils {
    private TypeUtils() {
    }

    public static String getArrayElementPhoenixTypeName(ConnectorSession session, PhoenixClient client, Type elementType) {
        if (elementType instanceof VarcharType) {
            return "VARCHAR";
        }
        if (elementType instanceof CharType) {
            return "CHAR";
        }
        if (elementType instanceof DecimalType) {
            return "DECIMAL";
        }
        return client.toWriteMapping(session, elementType).getDataType().toUpperCase(Locale.ENGLISH);
    }

    public static Block jdbcObjectArrayToBlock(ConnectorSession session, Type type, Object[] elements) {
        BlockBuilder builder = type.createBlockBuilder(null, elements.length);
        for (Object element : elements) {
            io.trino.spi.type.TypeUtils.writeNativeValue((Type)type, (BlockBuilder)builder, (Object)TypeUtils.jdbcObjectToTrinoNative(session, element, type));
        }
        return builder.build();
    }

    public static Object[] getJdbcObjectArray(ConnectorSession session, Type elementType, Block block) {
        int positionCount = block.getPositionCount();
        Object[] valuesArray = new Object[positionCount];
        int subArrayLength = 1;
        for (int i = 0; i < positionCount; ++i) {
            Object objectValue;
            valuesArray[i] = objectValue = TypeUtils.trinoNativeToJdbcObject(session, elementType, io.trino.spi.type.TypeUtils.readNativeValue((Type)elementType, (Block)block, (int)i));
            if (objectValue == null || !objectValue.getClass().isArray()) continue;
            subArrayLength = Math.max(subArrayLength, Array.getLength(objectValue));
        }
        if (elementType instanceof ArrayType) {
            TypeUtils.handleArrayNulls(valuesArray, subArrayLength);
        }
        return valuesArray;
    }

    public static Object[] toBoxedArray(Object jdbcArray) {
        Objects.requireNonNull(jdbcArray, "jdbcArray is null");
        Preconditions.checkArgument((boolean)jdbcArray.getClass().isArray(), (String)"object is not an array: %s", (Object)jdbcArray.getClass().getName());
        if (!jdbcArray.getClass().getComponentType().isPrimitive()) {
            return (Object[])jdbcArray;
        }
        int elementCount = Array.getLength(jdbcArray);
        Object[] elements = new Object[elementCount];
        for (int i = 0; i < elementCount; ++i) {
            elements[i] = Array.get(jdbcArray, i);
        }
        return elements;
    }

    private static void handleArrayNulls(Object[] valuesArray, int length) {
        for (int i = 0; i < valuesArray.length; ++i) {
            if (valuesArray[i] != null) continue;
            valuesArray[i] = new Object[length];
        }
    }

    private static Object jdbcObjectToTrinoNative(ConnectorSession session, Object jdbcObject, Type type) {
        if (jdbcObject == null) {
            return null;
        }
        if (BooleanType.BOOLEAN.equals((Object)type) || BigintType.BIGINT.equals((Object)type) || DoubleType.DOUBLE.equals((Object)type)) {
            return jdbcObject;
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            return (long)((Byte)jdbcObject).byteValue();
        }
        if (SmallintType.SMALLINT.equals((Object)type)) {
            return (long)((Short)jdbcObject).shortValue();
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            return (long)((Integer)jdbcObject).intValue();
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            return TypeUtils.jdbcObjectArrayToBlock(session, arrayType.getElementType(), (Object[])jdbcObject);
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            BigDecimal value = (BigDecimal)jdbcObject;
            if (decimalType.isShort()) {
                return Decimals.encodeShortScaledValue((BigDecimal)value, (int)decimalType.getScale());
            }
            return Decimals.encodeScaledValue((BigDecimal)value, (int)decimalType.getScale());
        }
        if (RealType.REAL.equals((Object)type)) {
            return (long)Float.floatToRawIntBits(((Float)jdbcObject).floatValue());
        }
        if (DateType.DATE.equals((Object)type)) {
            long localMillis = ((Date)jdbcObject).getTime();
            long utcMillis = ISOChronology.getInstance().getZone().getMillisKeepLocal(DateTimeZone.UTC, localMillis);
            return TimeUnit.MILLISECONDS.toDays(utcMillis);
        }
        if (type instanceof VarcharType) {
            return Slices.utf8Slice((String)((String)jdbcObject));
        }
        if (type instanceof CharType) {
            return Slices.utf8Slice((String)CharMatcher.is((char)' ').trimTrailingFrom((CharSequence)((String)jdbcObject)));
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported type %s and object type %s", type, jdbcObject.getClass()));
    }

    private static Object trinoNativeToJdbcObject(ConnectorSession session, Type type, Object object) {
        if (object == null) {
            return null;
        }
        if (DoubleType.DOUBLE.equals((Object)type) || BooleanType.BOOLEAN.equals((Object)type) || BigintType.BIGINT.equals((Object)type)) {
            return object;
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            if (decimalType.isShort()) {
                BigInteger unscaledValue = BigInteger.valueOf((Long)object);
                return new BigDecimal(unscaledValue, decimalType.getScale(), new MathContext(decimalType.getPrecision()));
            }
            BigInteger unscaledValue = ((Int128)object).toBigInteger();
            return new BigDecimal(unscaledValue, decimalType.getScale(), new MathContext(decimalType.getPrecision()));
        }
        if (RealType.REAL.equals((Object)type)) {
            return Float.valueOf(Float.intBitsToFloat(Math.toIntExact((Long)object)));
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            return SignedBytes.checkedCast((long)((Long)object));
        }
        if (SmallintType.SMALLINT.equals((Object)type)) {
            return Shorts.checkedCast((long)((Long)object));
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            return Math.toIntExact((Long)object);
        }
        if (DateType.DATE.equals((Object)type)) {
            long millis = TimeUnit.DAYS.toMillis((Long)object);
            return new Date(DateTimeZone.UTC.getMillisKeepLocal(DateTimeZone.getDefault(), millis));
        }
        if (type instanceof VarcharType || type instanceof CharType) {
            return ((Slice)object).toStringUtf8();
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            return TypeUtils.getJdbcObjectArray(session, arrayType.getElementType(), (Block)object);
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported type: " + String.valueOf(type));
    }
}

