/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.net.URI;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.validation.constraints.NotNull;

public class PinotConfig {
    private static final Splitter LIST_SPLITTER = Splitter.on((String)",").trimResults().omitEmptyStrings();
    private int maxConnectionsPerServer = 30;
    private List<URI> controllerUrls = ImmutableList.of();
    private Duration idleTimeout = new Duration(5.0, TimeUnit.MINUTES);
    private Duration connectionTimeout = new Duration(1.0, TimeUnit.MINUTES);
    private Duration requestTimeout = new Duration(30.0, TimeUnit.SECONDS);
    private int threadPoolSize = 30;
    private int minConnectionsPerServer = 10;
    private int maxBacklogPerServer = 30;
    private int estimatedSizeInBytesForNonNumericColumn = 20;
    private Duration metadataCacheExpiry = new Duration(2.0, TimeUnit.MINUTES);
    private boolean preferBrokerQueries;
    private boolean forbidSegmentQueries;
    private int segmentsPerSplit = 1;
    private int fetchRetryCount = 2;
    private int nonAggregateLimitForBrokerQueries = 25000;
    private int maxRowsPerSplitForSegmentQueries = 50000;
    private int maxRowsForBrokerQueries = 50000;
    private boolean aggregationPushdownEnabled = true;
    private boolean countDistinctPushdownEnabled = true;

    @NotNull
    public List<URI> getControllerUrls() {
        return this.controllerUrls;
    }

    @Config(value="pinot.controller-urls")
    public PinotConfig setControllerUrls(String controllerUrl) {
        this.controllerUrls = (List)LIST_SPLITTER.splitToList((CharSequence)controllerUrl).stream().map(PinotConfig::stringToUri).collect(ImmutableList.toImmutableList());
        return this;
    }

    @NotNull
    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    @Config(value="pinot.thread-pool-size")
    public PinotConfig setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
        return this;
    }

    @NotNull
    public int getMinConnectionsPerServer() {
        return this.minConnectionsPerServer;
    }

    @Config(value="pinot.min-connections-per-server")
    public PinotConfig setMinConnectionsPerServer(int minConnectionsPerServer) {
        this.minConnectionsPerServer = minConnectionsPerServer;
        return this;
    }

    @NotNull
    public int getMaxConnectionsPerServer() {
        return this.maxConnectionsPerServer;
    }

    @Config(value="pinot.max-connections-per-server")
    public PinotConfig setMaxConnectionsPerServer(int maxConnectionsPerServer) {
        this.maxConnectionsPerServer = maxConnectionsPerServer;
        return this;
    }

    @NotNull
    public int getMaxBacklogPerServer() {
        return this.maxBacklogPerServer;
    }

    @Config(value="pinot.max-backlog-per-server")
    public PinotConfig setMaxBacklogPerServer(int maxBacklogPerServer) {
        this.maxBacklogPerServer = maxBacklogPerServer;
        return this;
    }

    @MinDuration(value="15s")
    @NotNull
    public @MinDuration(value="15s") @NotNull Duration getIdleTimeout() {
        return this.idleTimeout;
    }

    @Config(value="pinot.idle-timeout")
    public PinotConfig setIdleTimeout(Duration idleTimeout) {
        this.idleTimeout = idleTimeout;
        return this;
    }

    @MinDuration(value="15s")
    @NotNull
    public @MinDuration(value="15s") @NotNull Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Config(value="pinot.connection-timeout")
    public PinotConfig setConnectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    @MinDuration(value="15s")
    @NotNull
    public @MinDuration(value="15s") @NotNull Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    @Config(value="pinot.request-timeout")
    public PinotConfig setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @MinDuration(value="0s")
    @NotNull
    public @MinDuration(value="0s") @NotNull Duration getMetadataCacheExpiry() {
        return this.metadataCacheExpiry;
    }

    @Config(value="pinot.metadata-expiry")
    public PinotConfig setMetadataCacheExpiry(Duration metadataCacheExpiry) {
        this.metadataCacheExpiry = metadataCacheExpiry;
        return this;
    }

    @NotNull
    public int getEstimatedSizeInBytesForNonNumericColumn() {
        return this.estimatedSizeInBytesForNonNumericColumn;
    }

    @Config(value="pinot.estimated-size-in-bytes-for-non-numeric-column")
    public PinotConfig setEstimatedSizeInBytesForNonNumericColumn(int estimatedSizeInBytesForNonNumericColumn) {
        this.estimatedSizeInBytesForNonNumericColumn = estimatedSizeInBytesForNonNumericColumn;
        return this;
    }

    public boolean isPreferBrokerQueries() {
        return this.preferBrokerQueries;
    }

    @Config(value="pinot.prefer-broker-queries")
    public PinotConfig setPreferBrokerQueries(boolean preferBrokerQueries) {
        this.preferBrokerQueries = preferBrokerQueries;
        return this;
    }

    public boolean isForbidSegmentQueries() {
        return this.forbidSegmentQueries;
    }

    @Config(value="pinot.forbid-segment-queries")
    public PinotConfig setForbidSegmentQueries(boolean forbidSegmentQueries) {
        this.forbidSegmentQueries = forbidSegmentQueries;
        return this;
    }

    public int getSegmentsPerSplit() {
        return this.segmentsPerSplit;
    }

    @Config(value="pinot.segments-per-split")
    public PinotConfig setSegmentsPerSplit(int segmentsPerSplit) {
        Preconditions.checkArgument((segmentsPerSplit > 0 ? 1 : 0) != 0, (Object)"Segments per split must be greater than zero");
        this.segmentsPerSplit = segmentsPerSplit;
        return this;
    }

    public int getFetchRetryCount() {
        return this.fetchRetryCount;
    }

    @Config(value="pinot.fetch-retry-count")
    public PinotConfig setFetchRetryCount(int fetchRetryCount) {
        this.fetchRetryCount = fetchRetryCount;
        return this;
    }

    public int getNonAggregateLimitForBrokerQueries() {
        return this.nonAggregateLimitForBrokerQueries;
    }

    @Config(value="pinot.non-aggregate-limit-for-broker-queries")
    public PinotConfig setNonAggregateLimitForBrokerQueries(int nonAggregateLimitForBrokerQueries) {
        this.nonAggregateLimitForBrokerQueries = nonAggregateLimitForBrokerQueries;
        return this;
    }

    public int getMaxRowsPerSplitForSegmentQueries() {
        return this.maxRowsPerSplitForSegmentQueries;
    }

    @Config(value="pinot.max-rows-per-split-for-segment-queries")
    public PinotConfig setMaxRowsPerSplitForSegmentQueries(int maxRowsPerSplitForSegmentQueries) {
        this.maxRowsPerSplitForSegmentQueries = maxRowsPerSplitForSegmentQueries;
        return this;
    }

    private static URI stringToUri(String server) {
        if (server.startsWith("http://") || server.startsWith("https://")) {
            return URI.create(server);
        }
        return URI.create("http://" + server);
    }

    public int getMaxRowsForBrokerQueries() {
        return this.maxRowsForBrokerQueries;
    }

    @Config(value="pinot.max-rows-for-broker-queries")
    public PinotConfig setMaxRowsForBrokerQueries(int maxRowsForBrokerQueries) {
        this.maxRowsForBrokerQueries = maxRowsForBrokerQueries;
        return this;
    }

    public boolean isAggregationPushdownEnabled() {
        return this.aggregationPushdownEnabled;
    }

    @Config(value="pinot.aggregation-pushdown.enabled")
    public PinotConfig setAggregationPushdownEnabled(boolean aggregationPushdownEnabled) {
        this.aggregationPushdownEnabled = aggregationPushdownEnabled;
        return this;
    }

    public boolean isCountDistinctPushdownEnabled() {
        return this.countDistinctPushdownEnabled;
    }

    @Config(value="pinot.count-distinct-pushdown.enabled")
    @ConfigDescription(value="Controls whether distinct count is pushed down to Pinot. Distinct count pushdown can cause Pinot to do a full scan. Aggregation pushdown must also be enabled in addition to this parameter otherwise no pushdowns will be enabled.")
    public PinotConfig setCountDistinctPushdownEnabled(boolean countDistinctPushdownEnabled) {
        this.countDistinctPushdownEnabled = countDistinctPushdownEnabled;
        return this;
    }

    @PostConstruct
    public void validate() {
        Preconditions.checkState((!this.countDistinctPushdownEnabled || this.aggregationPushdownEnabled ? 1 : 0) != 0, (Object)"Invalid configuration: pinot.aggregation-pushdown.enabled must be enabled if pinot.count-distinct-pushdown.enabled");
    }
}

