/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.trino.plugin.pinot.query.DynamicTable;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.predicate.TupleDomain;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;

public class PinotTableHandle
implements ConnectorTableHandle {
    private final String schemaName;
    private final String tableName;
    private final TupleDomain<ColumnHandle> constraint;
    private final OptionalLong limit;
    private final Optional<DynamicTable> query;

    public PinotTableHandle(String schemaName, String tableName) {
        this(schemaName, tableName, (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalLong.empty(), Optional.empty());
    }

    @JsonCreator
    public PinotTableHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="constraint") TupleDomain<ColumnHandle> constraint, @JsonProperty(value="limit") OptionalLong limit, @JsonProperty(value="query") Optional<DynamicTable> query) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.constraint = Objects.requireNonNull(constraint, "constraint is null");
        this.limit = Objects.requireNonNull(limit, "limit is null");
        this.query = Objects.requireNonNull(query, "query is null");
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getConstraint() {
        return this.constraint;
    }

    @JsonProperty
    public OptionalLong getLimit() {
        return this.limit;
    }

    @JsonProperty
    public Optional<DynamicTable> getQuery() {
        return this.query;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PinotTableHandle that = (PinotTableHandle)o;
        return Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.tableName, that.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.schemaName, this.tableName);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("schemaName", (Object)this.schemaName).add("tableName", (Object)this.tableName).add("constraint", this.constraint).add("limit", (Object)this.limit).add("query", this.query).toString();
    }
}

