/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.trino.collect.cache.NonEvictableLoadingCache;
import io.trino.collect.cache.SafeCaches;
import io.trino.plugin.base.aggregation.AggregateFunctionRewriter;
import io.trino.plugin.base.aggregation.AggregateFunctionRule;
import io.trino.plugin.base.expression.ConnectorExpressionRewriter;
import io.trino.plugin.pinot.ForPinot;
import io.trino.plugin.pinot.PinotColumnHandle;
import io.trino.plugin.pinot.PinotConfig;
import io.trino.plugin.pinot.PinotErrorCode;
import io.trino.plugin.pinot.PinotException;
import io.trino.plugin.pinot.PinotSessionProperties;
import io.trino.plugin.pinot.PinotTableHandle;
import io.trino.plugin.pinot.client.PinotClient;
import io.trino.plugin.pinot.query.AggregateExpression;
import io.trino.plugin.pinot.query.DynamicTable;
import io.trino.plugin.pinot.query.DynamicTableBuilder;
import io.trino.plugin.pinot.query.OrderByExpression;
import io.trino.plugin.pinot.query.aggregation.ImplementApproxDistinct;
import io.trino.plugin.pinot.query.aggregation.ImplementAvg;
import io.trino.plugin.pinot.query.aggregation.ImplementCountAll;
import io.trino.plugin.pinot.query.aggregation.ImplementCountDistinct;
import io.trino.plugin.pinot.query.aggregation.ImplementMinMax;
import io.trino.plugin.pinot.query.aggregation.ImplementSum;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.AggregationApplicationResult;
import io.trino.spi.connector.Assignment;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.LimitApplicationResult;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Variable;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.ArrayType;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import javax.inject.Inject;
import org.apache.pinot.spi.data.Schema;

public class PinotMetadata
implements ConnectorMetadata {
    public static final String PINOT_COLUMN_NAME_PROPERTY = "pinotColumnName";
    public static final String SCHEMA_NAME = "default";
    private final NonEvictableLoadingCache<String, List<ColumnMetadata>> pinotTableColumnCache;
    private final int maxRowsPerBrokerQuery;
    private final AggregateFunctionRewriter<AggregateExpression, Void> aggregateFunctionRewriter;
    private final ImplementCountDistinct implementCountDistinct;
    private final PinotClient pinotClient;

    @Inject
    public PinotMetadata(final PinotClient pinotClient, PinotConfig pinotConfig, @ForPinot ExecutorService executor) {
        Objects.requireNonNull(pinotConfig, "pinot config");
        this.pinotClient = Objects.requireNonNull(pinotClient, "pinotClient is null");
        long metadataCacheExpiryMillis = pinotConfig.getMetadataCacheExpiry().roundTo(TimeUnit.MILLISECONDS);
        this.pinotTableColumnCache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().refreshAfterWrite(metadataCacheExpiryMillis, TimeUnit.MILLISECONDS), (CacheLoader)CacheLoader.asyncReloading((CacheLoader)new CacheLoader<String, List<ColumnMetadata>>(){

            public List<ColumnMetadata> load(String tableName) throws Exception {
                Schema tablePinotSchema = pinotClient.getTableSchema(tableName);
                return PinotMetadata.this.getPinotColumnMetadataForPinotSchema(tablePinotSchema);
            }
        }, (Executor)executor));
        this.maxRowsPerBrokerQuery = pinotConfig.getMaxRowsForBrokerQueries();
        UnaryOperator<String> identifierQuote = UnaryOperator.identity();
        this.implementCountDistinct = new ImplementCountDistinct(identifierQuote);
        this.aggregateFunctionRewriter = new AggregateFunctionRewriter(new ConnectorExpressionRewriter((Set)ImmutableSet.of()), (Set)ImmutableSet.builder().add((Object)new ImplementCountAll()).add((Object)new ImplementAvg(identifierQuote)).add((Object)new ImplementMinMax(identifierQuote)).add((Object)new ImplementSum(identifierQuote)).add((Object)new ImplementApproxDistinct(identifierQuote)).add((Object)this.implementCountDistinct).build());
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return ImmutableList.of((Object)SCHEMA_NAME);
    }

    public PinotTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        if (tableName.getTableName().trim().startsWith("select ")) {
            DynamicTable dynamicTable = DynamicTableBuilder.buildFromPql(this, tableName, this.pinotClient);
            return new PinotTableHandle(tableName.getSchemaName(), dynamicTable.getTableName(), (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalLong.empty(), Optional.of(dynamicTable));
        }
        String pinotTableName = this.pinotClient.getPinotTableNameFromTrinoTableNameIfExists(tableName.getTableName());
        if (pinotTableName == null) {
            return null;
        }
        return new PinotTableHandle(tableName.getSchemaName(), pinotTableName);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        PinotTableHandle pinotTableHandle = (PinotTableHandle)table;
        if (pinotTableHandle.getQuery().isPresent()) {
            DynamicTable dynamicTable = pinotTableHandle.getQuery().get();
            ImmutableList.Builder columnMetadataBuilder = ImmutableList.builder();
            for (PinotColumnHandle pinotColumnHandle : dynamicTable.getProjections()) {
                columnMetadataBuilder.add((Object)pinotColumnHandle.getColumnMetadata());
            }
            dynamicTable.getAggregateColumns().forEach(columnHandle -> columnMetadataBuilder.add((Object)columnHandle.getColumnMetadata()));
            SchemaTableName schemaTableName = new SchemaTableName(pinotTableHandle.getSchemaName(), dynamicTable.getTableName());
            return new ConnectorTableMetadata(schemaTableName, (List)columnMetadataBuilder.build());
        }
        SchemaTableName tableName = new SchemaTableName(pinotTableHandle.getSchemaName(), pinotTableHandle.getTableName());
        return this.getTableMetadata(tableName);
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaNameOrNull) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String table : this.pinotClient.getPinotTableNames()) {
            builder.add((Object)new SchemaTableName(SCHEMA_NAME, table));
        }
        return ImmutableList.copyOf((Collection)builder.build());
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        PinotTableHandle pinotTableHandle = (PinotTableHandle)tableHandle;
        if (pinotTableHandle.getQuery().isPresent()) {
            return this.getDynamicTableColumnHandles(pinotTableHandle);
        }
        return this.getPinotColumnHandles(pinotTableHandle.getTableName());
    }

    public Map<String, ColumnHandle> getPinotColumnHandles(String tableName) {
        ImmutableMap.Builder columnHandlesBuilder = ImmutableMap.builder();
        for (ColumnMetadata columnMetadata : this.getColumnsMetadata(tableName)) {
            columnHandlesBuilder.put((Object)columnMetadata.getName(), (Object)PinotColumnHandle.fromColumnMetadata(columnMetadata));
        }
        return columnHandlesBuilder.buildOrThrow();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(session, prefix)) {
            ConnectorTableMetadata tableMetadata = this.getTableMetadata(tableName);
            if (tableMetadata == null) continue;
            columns.put((Object)tableName, (Object)tableMetadata.getColumns());
        }
        return columns.buildOrThrow();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((PinotColumnHandle)columnHandle).getColumnMetadata();
    }

    public Optional<Object> getInfo(ConnectorTableHandle table) {
        return Optional.empty();
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
        return new ConnectorTableProperties();
    }

    public Optional<LimitApplicationResult<ConnectorTableHandle>> applyLimit(ConnectorSession session, ConnectorTableHandle table, long limit) {
        PinotTableHandle handle = (PinotTableHandle)table;
        if (handle.getLimit().isPresent() && handle.getLimit().getAsLong() <= limit) {
            return Optional.empty();
        }
        Optional<DynamicTable> dynamicTable = handle.getQuery();
        if (dynamicTable.isPresent() && (dynamicTable.get().getLimit().isEmpty() || dynamicTable.get().getLimit().getAsLong() > limit)) {
            dynamicTable = Optional.of(new DynamicTable(dynamicTable.get().getTableName(), dynamicTable.get().getSuffix(), dynamicTable.get().getProjections(), dynamicTable.get().getFilter(), dynamicTable.get().getGroupingColumns(), dynamicTable.get().getAggregateColumns(), dynamicTable.get().getOrderBy(), OptionalLong.of(limit), dynamicTable.get().getOffset(), dynamicTable.get().getQuery()));
        }
        handle = new PinotTableHandle(handle.getSchemaName(), handle.getTableName(), handle.getConstraint(), OptionalLong.of(limit), dynamicTable);
        boolean singleSplit = dynamicTable.isPresent();
        return Optional.of(new LimitApplicationResult((Object)handle, singleSplit, false));
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle table, Constraint constraint) {
        TupleDomain remainingFilter;
        PinotTableHandle handle = (PinotTableHandle)table;
        TupleDomain<ColumnHandle> oldDomain = handle.getConstraint();
        TupleDomain newDomain = oldDomain.intersect(constraint.getSummary());
        if (newDomain.isNone()) {
            remainingFilter = TupleDomain.all();
        } else {
            Map domains = (Map)newDomain.getDomains().orElseThrow();
            HashMap<ColumnHandle, Domain> supported = new HashMap<ColumnHandle, Domain>();
            HashMap<ColumnHandle, Domain> unsupported = new HashMap<ColumnHandle, Domain>();
            for (Map.Entry entry : domains.entrySet()) {
                if (((PinotColumnHandle)entry.getKey()).getDataType() instanceof ArrayType) {
                    unsupported.put((ColumnHandle)entry.getKey(), (Domain)entry.getValue());
                    continue;
                }
                supported.put((ColumnHandle)entry.getKey(), (Domain)entry.getValue());
            }
            newDomain = TupleDomain.withColumnDomains(supported);
            remainingFilter = TupleDomain.withColumnDomains(unsupported);
        }
        if (oldDomain.equals((Object)newDomain)) {
            return Optional.empty();
        }
        handle = new PinotTableHandle(handle.getSchemaName(), handle.getTableName(), (TupleDomain<ColumnHandle>)newDomain, handle.getLimit(), handle.getQuery());
        return Optional.of(new ConstraintApplicationResult((Object)handle, remainingFilter, false));
    }

    public Optional<AggregationApplicationResult<ConnectorTableHandle>> applyAggregation(ConnectorSession session, ConnectorTableHandle handle, List<AggregateFunction> aggregates, Map<String, ColumnHandle> assignments, List<List<ColumnHandle>> groupingSets) {
        if (!PinotSessionProperties.isAggregationPushdownEnabled(session)) {
            return Optional.empty();
        }
        Verify.verify((!groupingSets.isEmpty() ? 1 : 0) != 0, (String)"No grouping sets provided", (Object[])new Object[0]);
        if (groupingSets.size() != 1) {
            return Optional.empty();
        }
        if (((List)Iterables.getOnlyElement(groupingSets)).stream().filter(columnHandle -> ((PinotColumnHandle)columnHandle).getDataType() instanceof ArrayType).findFirst().isPresent()) {
            return Optional.empty();
        }
        PinotTableHandle tableHandle = (PinotTableHandle)handle;
        if (tableHandle.getQuery().isPresent() && (!tableHandle.getQuery().get().getAggregateColumns().isEmpty() || tableHandle.getQuery().get().isAggregateInProjections() || tableHandle.getQuery().get().getOffset().isPresent())) {
            return Optional.empty();
        }
        ImmutableList.Builder projections = ImmutableList.builder();
        ImmutableList.Builder resultAssignments = ImmutableList.builder();
        ImmutableList.Builder aggregateColumnsBuilder = ImmutableList.builder();
        for (AggregateFunction aggregate : aggregates) {
            Optional<AggregateExpression> rewriteResult = this.aggregateFunctionRewriter.rewrite(session, aggregate, assignments);
            if ((rewriteResult = this.applyCountDistinct(session, aggregate, assignments, tableHandle, rewriteResult)).isEmpty()) {
                return Optional.empty();
            }
            AggregateExpression aggregateExpression2 = rewriteResult.get();
            PinotColumnHandle pinotColumnHandle = new PinotColumnHandle(aggregateExpression2.toFieldName(), aggregate.getOutputType(), aggregateExpression2.toExpression(), false, true, aggregateExpression2.isReturnNullOnEmptyGroup(), Optional.of(aggregateExpression2.getFunction()), Optional.of(aggregateExpression2.getArgument()));
            aggregateColumnsBuilder.add((Object)pinotColumnHandle);
            projections.add((Object)new Variable(pinotColumnHandle.getColumnName(), pinotColumnHandle.getDataType()));
            resultAssignments.add((Object)new Assignment(pinotColumnHandle.getColumnName(), (ColumnHandle)pinotColumnHandle, pinotColumnHandle.getDataType()));
        }
        List groupingColumns = (List)((List)Iterables.getOnlyElement(groupingSets)).stream().map(PinotColumnHandle.class::cast).map(PinotColumnHandle::fromNonAggregateColumnHandle).collect(ImmutableList.toImmutableList());
        OptionalLong limitForDynamicTable = OptionalLong.empty();
        if (tableHandle.getLimit().isEmpty() && !groupingColumns.isEmpty()) {
            limitForDynamicTable = OptionalLong.of(this.maxRowsPerBrokerQuery + 1);
        }
        Object aggregationColumns = aggregateColumnsBuilder.build();
        String newQuery = "";
        List newSelections = groupingColumns;
        if (tableHandle.getQuery().isPresent()) {
            newQuery = tableHandle.getQuery().get().getQuery();
            Map projectionsMap = (Map)tableHandle.getQuery().get().getProjections().stream().collect(ImmutableMap.toImmutableMap(PinotColumnHandle::getColumnName, UnaryOperator.identity()));
            groupingColumns = (List)groupingColumns.stream().map(groupIngColumn -> projectionsMap.getOrDefault(groupIngColumn.getColumnName(), groupIngColumn)).collect(ImmutableList.toImmutableList());
            ImmutableList.Builder newSelectionsBuilder = ImmutableList.builder().addAll((Iterable)groupingColumns);
            aggregationColumns = (List)aggregationColumns.stream().map(aggregateExpression -> PinotMetadata.resolveAggregateExpressionWithAlias(aggregateExpression, projectionsMap)).collect(ImmutableList.toImmutableList());
            newSelections = newSelectionsBuilder.build();
        }
        DynamicTable dynamicTable = new DynamicTable(tableHandle.getTableName(), Optional.empty(), newSelections, tableHandle.getQuery().flatMap(DynamicTable::getFilter), groupingColumns, (List<PinotColumnHandle>)aggregationColumns, (List<OrderByExpression>)ImmutableList.of(), limitForDynamicTable, OptionalLong.empty(), newQuery);
        tableHandle = new PinotTableHandle(tableHandle.getSchemaName(), tableHandle.getTableName(), tableHandle.getConstraint(), tableHandle.getLimit(), Optional.of(dynamicTable));
        return Optional.of(new AggregationApplicationResult((Object)tableHandle, (List)projections.build(), (List)resultAssignments.build(), (Map)ImmutableMap.of(), false));
    }

    private Optional<AggregateExpression> applyCountDistinct(final ConnectorSession session, AggregateFunction aggregate, final Map<String, ColumnHandle> assignments, PinotTableHandle tableHandle, Optional<AggregateExpression> rewriteResult) {
        AggregateFunctionRule.RewriteContext<Void> context = new AggregateFunctionRule.RewriteContext<Void>(){

            public Map<String, ColumnHandle> getAssignments() {
                return assignments;
            }

            public ConnectorSession getSession() {
                return session;
            }

            public Optional<Void> rewriteExpression(ConnectorExpression expression) {
                throw new UnsupportedOperationException();
            }
        };
        if (this.implementCountDistinct.getPattern().matches((Object)aggregate, (Object)context)) {
            Variable argument = (Variable)Iterables.getOnlyElement((Iterable)aggregate.getArguments());
            if (tableHandle.getQuery().isEmpty() || tableHandle.getQuery().get().getGroupingColumns().stream().noneMatch(groupingExpression -> groupingExpression.getColumnName().equals(argument.getName()))) {
                return Optional.empty();
            }
        }
        return rewriteResult;
    }

    private static PinotColumnHandle resolveAggregateExpressionWithAlias(PinotColumnHandle aggregateColumn, Map<String, PinotColumnHandle> projectionsMap) {
        Preconditions.checkState((aggregateColumn.isAggregate() && aggregateColumn.getPushedDownAggregateFunctionName().isPresent() && aggregateColumn.getPushedDownAggregateFunctionArgument().isPresent() ? 1 : 0) != 0, (Object)"Column is not a pushed down aggregate column");
        PinotColumnHandle selection = projectionsMap.get(aggregateColumn.getPushedDownAggregateFunctionArgument().get());
        if (selection != null && selection.isAliased()) {
            AggregateExpression pushedDownAggregateExpression = new AggregateExpression(aggregateColumn.getPushedDownAggregateFunctionName().get(), aggregateColumn.getPushedDownAggregateFunctionArgument().get(), aggregateColumn.isReturnNullOnEmptyGroup());
            AggregateExpression newPushedDownAggregateExpression = AggregateExpression.replaceIdentifier(pushedDownAggregateExpression, selection);
            return new PinotColumnHandle(pushedDownAggregateExpression.toFieldName(), aggregateColumn.getDataType(), newPushedDownAggregateExpression.toExpression(), true, aggregateColumn.isAggregate(), aggregateColumn.isReturnNullOnEmptyGroup(), aggregateColumn.getPushedDownAggregateFunctionName(), Optional.of(newPushedDownAggregateExpression.getArgument()));
        }
        return aggregateColumn;
    }

    @VisibleForTesting
    public List<ColumnMetadata> getColumnsMetadata(String tableName) {
        String pinotTableName = this.pinotClient.getPinotTableNameFromTrinoTableName(tableName);
        return PinotMetadata.getFromCache(this.pinotTableColumnCache, pinotTableName);
    }

    private static <K, V> V getFromCache(LoadingCache<K, V> cache, K key) {
        try {
            return (V)cache.get(key);
        }
        catch (ExecutionException e) {
            throw new PinotException(PinotErrorCode.PINOT_UNCLASSIFIED_ERROR, Optional.empty(), "Cannot fetch from cache " + key, e.getCause());
        }
    }

    private Map<String, ColumnHandle> getDynamicTableColumnHandles(PinotTableHandle pinotTableHandle) {
        Preconditions.checkState((boolean)pinotTableHandle.getQuery().isPresent(), (Object)"dynamic table not present");
        DynamicTable dynamicTable = pinotTableHandle.getQuery().get();
        ImmutableMap.Builder columnHandlesBuilder = ImmutableMap.builder();
        for (PinotColumnHandle pinotColumnHandle : dynamicTable.getProjections()) {
            columnHandlesBuilder.put((Object)pinotColumnHandle.getColumnName().toLowerCase(Locale.ENGLISH), (Object)pinotColumnHandle);
        }
        dynamicTable.getAggregateColumns().forEach(columnHandle -> columnHandlesBuilder.put((Object)columnHandle.getColumnName().toLowerCase(Locale.ENGLISH), columnHandle));
        return columnHandlesBuilder.buildOrThrow();
    }

    private ConnectorTableMetadata getTableMetadata(SchemaTableName tableName) {
        return new ConnectorTableMetadata(tableName, this.getColumnsMetadata(tableName.getTableName()));
    }

    private List<ColumnMetadata> getPinotColumnMetadataForPinotSchema(Schema pinotTableSchema) {
        return (List)pinotTableSchema.getColumnNames().stream().filter(columnName -> !columnName.startsWith("$")).map(columnName -> ColumnMetadata.builder().setName(columnName).setType(PinotColumnHandle.getTrinoTypeFromPinotType(pinotTableSchema.getFieldSpecFor(columnName))).setProperties((Map)ImmutableMap.builder().put((Object)PINOT_COLUMN_NAME_PROPERTY, columnName).buildOrThrow()).build()).collect(ImmutableList.toImmutableList());
    }

    private List<SchemaTableName> listTables(ConnectorSession session, SchemaTablePrefix prefix) {
        if (prefix.getSchema().isEmpty() || prefix.getTable().isEmpty()) {
            return this.listTables(session, Optional.empty());
        }
        return ImmutableList.of((Object)new SchemaTableName((String)prefix.getSchema().get(), (String)prefix.getTable().get()));
    }
}

