/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.concurrent.Threads;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.http.client.HttpClientBinder;
import io.airlift.json.JsonBinder;
import io.airlift.json.JsonCodecBinder;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.plugin.base.jmx.RebindSafeMBeanServer;
import io.trino.plugin.pinot.ForPinot;
import io.trino.plugin.pinot.PinotConfig;
import io.trino.plugin.pinot.PinotConnector;
import io.trino.plugin.pinot.PinotMetadata;
import io.trino.plugin.pinot.PinotNodePartitioningProvider;
import io.trino.plugin.pinot.PinotPageSourceProvider;
import io.trino.plugin.pinot.PinotSessionProperties;
import io.trino.plugin.pinot.PinotSplitManager;
import io.trino.plugin.pinot.client.IdentityPinotHostMapper;
import io.trino.plugin.pinot.client.PinotClient;
import io.trino.plugin.pinot.client.PinotDataFetcher;
import io.trino.plugin.pinot.client.PinotGrpcDataFetcher;
import io.trino.plugin.pinot.client.PinotGrpcServerQueryClientConfig;
import io.trino.plugin.pinot.client.PinotGrpcServerQueryClientTlsConfig;
import io.trino.plugin.pinot.client.PinotHostMapper;
import io.trino.plugin.pinot.client.PinotLegacyDataFetcher;
import io.trino.plugin.pinot.client.PinotLegacyServerQueryClientConfig;
import io.trino.spi.NodeManager;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import org.apache.pinot.common.utils.DataSchema;

public class PinotModule
extends AbstractConfigurationAwareModule {
    private final String catalogName;
    private final NodeManager nodeManager;

    public PinotModule(String catalogName, NodeManager nodeManager) {
        this.catalogName = catalogName;
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
    }

    public void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(PinotConfig.class);
        binder.bind(PinotConnector.class).in(Scopes.SINGLETON);
        binder.bind(PinotMetadata.class).in(Scopes.SINGLETON);
        binder.bind(PinotSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(PinotPageSourceProvider.class).in(Scopes.SINGLETON);
        binder.bind(PinotClient.class).in(Scopes.SINGLETON);
        binder.bind(ExecutorService.class).annotatedWith(ForPinot.class).toInstance((Object)Executors.newCachedThreadPool(Threads.threadsNamed((String)("pinot-metadata-fetcher-" + this.catalogName))));
        binder.bind(PinotSessionProperties.class).in(Scopes.SINGLETON);
        binder.bind(PinotNodePartitioningProvider.class).in(Scopes.SINGLETON);
        HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("pinot", ForPinot.class).withConfigDefaults(cfg -> {
            cfg.setIdleTimeout(new Duration(300.0, TimeUnit.SECONDS));
            cfg.setConnectTimeout(new Duration(300.0, TimeUnit.SECONDS));
            cfg.setRequestTimeout(new Duration(300.0, TimeUnit.SECONDS));
            cfg.setMaxConnectionsPerServer(250);
            cfg.setMaxContentLength(DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
            cfg.setSelectorCount(10);
            cfg.setTimeoutThreads(8);
            cfg.setTimeoutConcurrency(4);
        });
        JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(DataSchema.class).to(DataSchemaDeserializer.class);
        PinotClient.addJsonBinders(JsonCodecBinder.jsonCodecBinder((Binder)binder));
        binder.bind(MBeanServer.class).toInstance((Object)new RebindSafeMBeanServer(ManagementFactory.getPlatformMBeanServer()));
        binder.bind(NodeManager.class).toInstance((Object)this.nodeManager);
        binder.bind(ConnectorNodePartitioningProvider.class).to(PinotNodePartitioningProvider.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, PinotHostMapper.class).setDefault().to(IdentityPinotHostMapper.class).in(Scopes.SINGLETON);
        this.install(ConditionalModule.conditionalModule(PinotConfig.class, config -> config.isGrpcEnabled(), (Module)new PinotGrpcModule(), (Module)new LegacyClientModule()));
    }

    public static class LegacyClientModule
    extends AbstractConfigurationAwareModule {
        public void setup(Binder binder) {
            ConfigBinder.configBinder((Binder)binder).bindConfig(PinotLegacyServerQueryClientConfig.class);
            binder.bind(PinotDataFetcher.Factory.class).to(PinotLegacyDataFetcher.Factory.class).in(Scopes.SINGLETON);
        }
    }

    public static class PinotGrpcModule
    extends AbstractConfigurationAwareModule {
        public void setup(Binder binder) {
            ConfigBinder.configBinder((Binder)binder).bindConfig(PinotGrpcServerQueryClientConfig.class);
            binder.bind(PinotDataFetcher.Factory.class).to(PinotGrpcDataFetcher.Factory.class).in(Scopes.SINGLETON);
            this.install(ConditionalModule.conditionalModule(PinotGrpcServerQueryClientConfig.class, config -> config.isUsePlainText(), plainTextBinder -> plainTextBinder.bind(PinotGrpcDataFetcher.GrpcQueryClientFactory.class).to(PinotGrpcDataFetcher.PlainTextGrpcQueryClientFactory.class).in(Scopes.SINGLETON), tlsBinder -> {
                ConfigBinder.configBinder((Binder)tlsBinder).bindConfig(PinotGrpcServerQueryClientTlsConfig.class);
                tlsBinder.bind(PinotGrpcDataFetcher.GrpcQueryClientFactory.class).to(PinotGrpcDataFetcher.TlsGrpcQueryClientFactory.class).in(Scopes.SINGLETON);
            }));
        }
    }

    public static final class DataSchemaDeserializer
    extends JsonDeserializer<DataSchema> {
        public DataSchema deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode jsonNode = ctxt.readTree(p);
            ArrayNode columnDataTypes = (ArrayNode)jsonNode.get("columnDataTypes");
            DataSchema.ColumnDataType[] columnTypes = new DataSchema.ColumnDataType[columnDataTypes.size()];
            for (int i = 0; i < columnDataTypes.size(); ++i) {
                columnTypes[i] = DataSchema.ColumnDataType.valueOf((String)columnDataTypes.get(i).asText().toUpperCase(Locale.ENGLISH));
            }
            ArrayNode columnNamesJson = (ArrayNode)jsonNode.get("columnNames");
            String[] columnNames = new String[columnNamesJson.size()];
            for (int i = 0; i < columnNamesJson.size(); ++i) {
                columnNames[i] = columnNamesJson.get(i).asText();
            }
            return new DataSchema(columnNames, columnTypes);
        }
    }
}

