/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot;

import io.trino.plugin.pinot.PinotBrokerPageSource;
import io.trino.plugin.pinot.PinotColumnHandle;
import io.trino.plugin.pinot.PinotConfig;
import io.trino.plugin.pinot.PinotSegmentPageSource;
import io.trino.plugin.pinot.PinotSplit;
import io.trino.plugin.pinot.PinotTableHandle;
import io.trino.plugin.pinot.client.PinotClient;
import io.trino.plugin.pinot.client.PinotDataFetcher;
import io.trino.plugin.pinot.query.DynamicTable;
import io.trino.plugin.pinot.query.DynamicTablePqlExtractor;
import io.trino.plugin.pinot.query.PinotQueryBuilder;
import io.trino.plugin.pinot.query.PinotQueryInfo;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class PinotPageSourceProvider
implements ConnectorPageSourceProvider {
    private final PinotClient clusterInfoFetcher;
    private final int limitForSegmentQueries;
    private final int limitForBrokerQueries;
    private final long targetSegmentPageSizeBytes;
    private final PinotDataFetcher.Factory pinotDataFetcherFactory;

    @Inject
    public PinotPageSourceProvider(PinotConfig pinotConfig, PinotClient clusterInfoFetcher, PinotDataFetcher.Factory pinotDataFetcherFactory) {
        Objects.requireNonNull(pinotConfig, "pinotConfig is null");
        this.clusterInfoFetcher = Objects.requireNonNull(clusterInfoFetcher, "clusterInfoFetcher is null");
        this.pinotDataFetcherFactory = Objects.requireNonNull(pinotDataFetcherFactory, "pinotDataFetcherFactory is null");
        this.limitForSegmentQueries = pinotDataFetcherFactory.getRowLimit();
        this.limitForBrokerQueries = pinotConfig.getMaxRowsForBrokerQueries();
        this.targetSegmentPageSizeBytes = pinotConfig.getTargetSegmentPageSize().toBytes();
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle tableHandle, List<ColumnHandle> columns, DynamicFilter dynamicFilter) {
        Objects.requireNonNull(split, "split is null");
        PinotSplit pinotSplit = (PinotSplit)split;
        ArrayList<PinotColumnHandle> handles = new ArrayList<PinotColumnHandle>();
        for (ColumnHandle handle : columns) {
            handles.add((PinotColumnHandle)handle);
        }
        PinotTableHandle pinotTableHandle = (PinotTableHandle)tableHandle;
        String query = PinotQueryBuilder.generatePql(pinotTableHandle, handles, pinotSplit.getSuffix(), pinotSplit.getTimePredicate(), this.limitForSegmentQueries);
        switch (pinotSplit.getSplitType()) {
            case SEGMENT: {
                PinotDataFetcher pinotDataFetcher = this.pinotDataFetcherFactory.create(session, query, pinotSplit);
                return new PinotSegmentPageSource(this.targetSegmentPageSizeBytes, handles, pinotDataFetcher);
            }
            case BROKER: {
                PinotQueryInfo pinotQueryInfo;
                if (pinotTableHandle.getQuery().isPresent()) {
                    DynamicTable dynamicTable = pinotTableHandle.getQuery().get();
                    pinotQueryInfo = new PinotQueryInfo(dynamicTable.getTableName(), DynamicTablePqlExtractor.extractPql(dynamicTable, pinotTableHandle.getConstraint(), handles), dynamicTable.getGroupingColumns().size());
                } else {
                    pinotQueryInfo = new PinotQueryInfo(pinotTableHandle.getTableName(), query, 0);
                }
                return new PinotBrokerPageSource(session, pinotQueryInfo, handles, this.clusterInfoFetcher, this.limitForBrokerQueries);
            }
        }
        throw new UnsupportedOperationException("Unknown Pinot split type: " + pinotSplit.getSplitType());
    }
}

