/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot.client;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Closer;
import com.google.common.net.HostAndPort;
import io.trino.plugin.pinot.PinotErrorCode;
import io.trino.plugin.pinot.PinotException;
import io.trino.plugin.pinot.PinotSplit;
import io.trino.plugin.pinot.client.PinotDataFetcher;
import io.trino.plugin.pinot.client.PinotDataTableWithSize;
import io.trino.plugin.pinot.client.PinotGrpcServerQueryClientConfig;
import io.trino.plugin.pinot.client.PinotGrpcServerQueryClientTlsConfig;
import io.trino.plugin.pinot.client.PinotHostMapper;
import io.trino.spi.connector.ConnectorSession;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.pinot.common.proto.Server;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.utils.grpc.GrpcQueryClient;
import org.apache.pinot.common.utils.grpc.GrpcRequestBuilder;
import org.apache.pinot.core.common.datatable.DataTableFactory;
import org.apache.pinot.sql.parsers.CalciteSqlCompiler;

public class PinotGrpcDataFetcher
implements PinotDataFetcher {
    private final PinotSplit split;
    private final PinotGrpcServerQueryClient pinotGrpcClient;
    private final String query;
    private long readTimeNanos;
    private Iterator<PinotDataTableWithSize> responseIterator;
    private boolean isPinotDataFetched;
    private final PinotDataFetcher.RowCountChecker rowCountChecker;
    private long estimatedMemoryUsageInBytes;

    public PinotGrpcDataFetcher(PinotGrpcServerQueryClient pinotGrpcClient, PinotSplit split, String query, PinotDataFetcher.RowCountChecker rowCountChecker) {
        this.pinotGrpcClient = Objects.requireNonNull(pinotGrpcClient, "pinotGrpcClient is null");
        this.split = Objects.requireNonNull(split, "split is null");
        this.query = Objects.requireNonNull(query, "query is null");
        this.rowCountChecker = Objects.requireNonNull(rowCountChecker, "rowCountChecker is null");
    }

    @Override
    public long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    @Override
    public long getMemoryUsageBytes() {
        return this.estimatedMemoryUsageInBytes;
    }

    @Override
    public boolean endOfData() {
        return !this.responseIterator.hasNext();
    }

    @Override
    public boolean isDataFetched() {
        return this.isPinotDataFetched;
    }

    @Override
    public void fetchData() {
        long startTimeNanos = System.nanoTime();
        String serverHost = this.split.getSegmentHost().orElseThrow(() -> new PinotException(PinotErrorCode.PINOT_INVALID_PQL_GENERATED, Optional.empty(), "Expected the segment split to contain the host"));
        this.responseIterator = this.pinotGrpcClient.queryPinot(null, this.query, serverHost, this.split.getSegments());
        this.readTimeNanos += System.nanoTime() - startTimeNanos;
        this.isPinotDataFetched = true;
    }

    @Override
    public PinotDataTableWithSize getNextDataTable() {
        PinotDataTableWithSize dataTableWithSize = this.responseIterator.next();
        this.estimatedMemoryUsageInBytes = dataTableWithSize.getEstimatedSizeInBytes();
        this.rowCountChecker.checkTooManyRows(dataTableWithSize.getDataTable());
        this.checkExceptions(dataTableWithSize.getDataTable(), this.split, this.query);
        return dataTableWithSize;
    }

    public static class PinotGrpcServerQueryClient {
        private static final CalciteSqlCompiler REQUEST_COMPILER = new CalciteSqlCompiler();
        private final PinotHostMapper pinotHostMapper;
        private final Map<HostAndPort, GrpcQueryClient> clientCache = new ConcurrentHashMap<HostAndPort, GrpcQueryClient>();
        private final int grpcPort;
        private final GrpcQueryClientFactory grpcQueryClientFactory;
        private final Closer closer;

        private PinotGrpcServerQueryClient(PinotHostMapper pinotHostMapper, PinotGrpcServerQueryClientConfig pinotGrpcServerQueryClientConfig, GrpcQueryClientFactory grpcQueryClientFactory, Closer closer) {
            this.pinotHostMapper = Objects.requireNonNull(pinotHostMapper, "pinotHostMapper is null");
            Objects.requireNonNull(pinotGrpcServerQueryClientConfig, "pinotGrpcServerQueryClientConfig is null");
            this.grpcPort = pinotGrpcServerQueryClientConfig.getGrpcPort();
            this.grpcQueryClientFactory = Objects.requireNonNull(grpcQueryClientFactory, "grpcQueryClientFactory is null");
            this.closer = Objects.requireNonNull(closer, "closer is null");
        }

        public Iterator<PinotDataTableWithSize> queryPinot(ConnectorSession session, String query, String serverHost, List<String> segments) {
            HostAndPort mappedHostAndPort = this.pinotHostMapper.getServerGrpcHostAndPort(serverHost, this.grpcPort);
            GrpcQueryClient client = this.clientCache.computeIfAbsent(mappedHostAndPort, hostAndPort -> {
                GrpcQueryClient queryClient = this.grpcQueryClientFactory.create((HostAndPort)hostAndPort);
                this.closer.register(() -> ((GrpcQueryClient)queryClient).close());
                return queryClient;
            });
            BrokerRequest brokerRequest = REQUEST_COMPILER.compileToBrokerRequest(query);
            GrpcRequestBuilder requestBuilder = new GrpcRequestBuilder().setSql(query).setSegments(segments).setEnableStreaming(true).setBrokerRequest(brokerRequest);
            return new ResponseIterator(client.submit(requestBuilder.build()));
        }

        public static class ResponseIterator
        extends AbstractIterator<PinotDataTableWithSize> {
            private final Iterator<Server.ServerResponse> responseIterator;

            public ResponseIterator(Iterator<Server.ServerResponse> responseIterator) {
                this.responseIterator = Objects.requireNonNull(responseIterator, "responseIterator is null");
            }

            protected PinotDataTableWithSize computeNext() {
                if (!this.responseIterator.hasNext()) {
                    return (PinotDataTableWithSize)this.endOfData();
                }
                Server.ServerResponse response = this.responseIterator.next();
                String responseType = (String)response.getMetadataMap().get("responseType");
                if (responseType.equals("metadata")) {
                    return (PinotDataTableWithSize)this.endOfData();
                }
                ByteBuffer buffer = response.getPayload().asReadOnlyByteBuffer();
                try {
                    return new PinotDataTableWithSize(DataTableFactory.getDataTable((ByteBuffer)buffer), buffer.remaining());
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
    }

    public static class TlsGrpcQueryClientFactory
    implements GrpcQueryClientFactory {
        private static final String KEYSTORE_TYPE = "keystore.type";
        private static final String KEYSTORE_PATH = "keystore.path";
        private static final String KEYSTORE_PASSWORD = "keystore.password";
        private static final String TRUSTSTORE_TYPE = "truststore.type";
        private static final String TRUSTSTORE_PATH = "truststore.path";
        private static final String TRUSTSTORE_PASSWORD = "truststore.password";
        private static final String SSL_PROVIDER = "ssl.provider";
        private final GrpcQueryClient.Config config;

        @Inject
        public TlsGrpcQueryClientFactory(PinotGrpcServerQueryClientConfig grpcClientConfig, PinotGrpcServerQueryClientTlsConfig tlsConfig) {
            Objects.requireNonNull(grpcClientConfig, "grpcClientConfig is null");
            Objects.requireNonNull(tlsConfig, "tlsConfig is null");
            this.config = new GrpcQueryClient.Config((Map)ImmutableMap.builder().put((Object)"maxInboundMessageSizeBytes", (Object)String.valueOf(grpcClientConfig.getMaxInboundMessageSize().toBytes())).put((Object)"usePlainText", (Object)String.valueOf(grpcClientConfig.isUsePlainText())).put((Object)"tls.keystore.type", (Object)tlsConfig.getKeystoreType()).put((Object)"tls.keystore.path", (Object)tlsConfig.getKeystorePath()).put((Object)"tls.keystore.password", (Object)tlsConfig.getKeystorePassword()).put((Object)"tls.truststore.type", (Object)tlsConfig.getTruststoreType()).put((Object)"tls.truststore.path", (Object)tlsConfig.getTruststorePath()).put((Object)"tls.truststore.password", (Object)tlsConfig.getTruststorePassword()).put((Object)"tls.ssl.provider", (Object)tlsConfig.getSslProvider()).buildOrThrow());
        }

        @Override
        public GrpcQueryClient create(HostAndPort hostAndPort) {
            return new GrpcQueryClient(hostAndPort.getHost(), hostAndPort.getPort(), this.config);
        }
    }

    public static class PlainTextGrpcQueryClientFactory
    implements GrpcQueryClientFactory {
        private final GrpcQueryClient.Config config;

        @Inject
        public PlainTextGrpcQueryClientFactory(PinotGrpcServerQueryClientConfig grpcClientConfig) {
            Objects.requireNonNull(grpcClientConfig, "grpcClientConfig is null");
            this.config = new GrpcQueryClient.Config((Map)ImmutableMap.builder().put((Object)"maxInboundMessageSizeBytes", (Object)String.valueOf(grpcClientConfig.getMaxInboundMessageSize().toBytes())).put((Object)"usePlainText", (Object)String.valueOf(grpcClientConfig.isUsePlainText())).buildOrThrow());
        }

        @Override
        public GrpcQueryClient create(HostAndPort hostAndPort) {
            return new GrpcQueryClient(hostAndPort.getHost(), hostAndPort.getPort(), this.config);
        }
    }

    public static interface GrpcQueryClientFactory {
        public GrpcQueryClient create(HostAndPort var1);
    }

    public static class Factory
    implements PinotDataFetcher.Factory {
        private final PinotGrpcServerQueryClient queryClient;
        private final int limitForSegmentQueries;
        private final Closer closer = Closer.create();

        @Inject
        public Factory(PinotHostMapper pinotHostMapper, PinotGrpcServerQueryClientConfig pinotGrpcServerQueryClientConfig, GrpcQueryClientFactory grpcQueryClientFactory) {
            Objects.requireNonNull(pinotHostMapper, "pinotHostMapper is null");
            Objects.requireNonNull(pinotGrpcServerQueryClientConfig, "pinotGrpcServerQueryClientConfig is null");
            this.limitForSegmentQueries = pinotGrpcServerQueryClientConfig.getMaxRowsPerSplitForSegmentQueries();
            this.queryClient = new PinotGrpcServerQueryClient(pinotHostMapper, pinotGrpcServerQueryClientConfig, grpcQueryClientFactory, this.closer);
        }

        @PreDestroy
        public void shutdown() throws IOException {
            this.closer.close();
        }

        @Override
        public PinotDataFetcher create(ConnectorSession session, String query, PinotSplit split) {
            return new PinotGrpcDataFetcher(this.queryClient, split, query, new PinotDataFetcher.RowCountChecker(this.limitForSegmentQueries, query));
        }

        @Override
        public int getRowLimit() {
            return this.limitForSegmentQueries;
        }
    }
}

