/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot.query;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import io.trino.plugin.pinot.PinotColumnHandle;
import io.trino.plugin.pinot.PinotTableHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Hex;

public final class PinotQueryBuilder {
    private PinotQueryBuilder() {
    }

    public static String generatePql(PinotTableHandle tableHandle, List<PinotColumnHandle> columnHandles, Optional<String> tableNameSuffix, Optional<String> timePredicate, int limitForSegmentQueries) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        StringBuilder pqlBuilder = new StringBuilder();
        Object quotedColumnNames = columnHandles.isEmpty() ? ImmutableList.of((Object)"*") : (List)columnHandles.stream().map(column -> PinotQueryBuilder.quoteIdentifier(column.getColumnName())).collect(ImmutableList.toImmutableList());
        pqlBuilder.append("SELECT ");
        pqlBuilder.append(String.join((CharSequence)", ", (Iterable<? extends CharSequence>)quotedColumnNames)).append(" FROM ").append(PinotQueryBuilder.getTableName(tableHandle, tableNameSuffix)).append(" ");
        PinotQueryBuilder.generateFilterPql(pqlBuilder, tableHandle, timePredicate);
        OptionalLong appliedLimit = tableHandle.getLimit();
        long limit = limitForSegmentQueries + 1;
        if (appliedLimit.isPresent()) {
            limit = Math.min(limit, appliedLimit.getAsLong());
        }
        pqlBuilder.append(" LIMIT ").append(limit);
        return pqlBuilder.toString();
    }

    private static String getTableName(PinotTableHandle tableHandle, Optional<String> tableNameSuffix) {
        if (tableNameSuffix.isPresent()) {
            return tableHandle.getTableName() + tableNameSuffix.get();
        }
        return tableHandle.getTableName();
    }

    private static void generateFilterPql(StringBuilder pqlBuilder, PinotTableHandle tableHandle, Optional<String> timePredicate) {
        Optional<String> filterClause = PinotQueryBuilder.getFilterClause(tableHandle.getConstraint(), timePredicate);
        if (filterClause.isPresent()) {
            pqlBuilder.append(" WHERE ").append(filterClause.get());
        }
    }

    public static Optional<String> getFilterClause(TupleDomain<ColumnHandle> tupleDomain, Optional<String> timePredicate) {
        ImmutableList conjuncts;
        ImmutableList.Builder conjunctsBuilder = ImmutableList.builder();
        timePredicate.ifPresent(arg_0 -> ((ImmutableList.Builder)conjunctsBuilder).add(arg_0));
        if (!tupleDomain.equals((Object)TupleDomain.all())) {
            Map domains = (Map)tupleDomain.getDomains().orElseThrow();
            for (Map.Entry entry : domains.entrySet()) {
                conjunctsBuilder.add((Object)PinotQueryBuilder.toPredicate(((PinotColumnHandle)entry.getKey()).getColumnName(), (Domain)entry.getValue()));
            }
        }
        if (!(conjuncts = conjunctsBuilder.build()).isEmpty()) {
            return Optional.of(Joiner.on((String)" AND ").join((Iterable)conjuncts));
        }
        return Optional.empty();
    }

    private static String toPredicate(String columnName, Domain domain) {
        ArrayList<Object> disjuncts = new ArrayList<Object>();
        ArrayList<Object> singleValues = new ArrayList<Object>();
        for (Range range : domain.getValues().getRanges().getOrderedRanges()) {
            Preconditions.checkState((!range.isAll() ? 1 : 0) != 0);
            if (range.isSingleValue()) {
                singleValues.add(PinotQueryBuilder.convertValue(range.getType(), range.getSingleValue()));
                continue;
            }
            ArrayList<String> rangeConjuncts = new ArrayList<String>();
            if (!range.isLowUnbounded()) {
                rangeConjuncts.add(PinotQueryBuilder.toConjunct(columnName, range.isLowInclusive() ? ">=" : ">", PinotQueryBuilder.convertValue(range.getType(), range.getLowBoundedValue())));
            }
            if (!range.isHighUnbounded()) {
                rangeConjuncts.add(PinotQueryBuilder.toConjunct(columnName, range.isHighInclusive() ? "<=" : "<", PinotQueryBuilder.convertValue(range.getType(), range.getHighBoundedValue())));
            }
            Preconditions.checkState((!rangeConjuncts.isEmpty() ? 1 : 0) != 0);
            disjuncts.add("(" + Joiner.on((String)" AND ").join(rangeConjuncts) + ")");
        }
        if (singleValues.size() == 1) {
            disjuncts.add(PinotQueryBuilder.toConjunct(columnName, "=", Iterables.getOnlyElement(singleValues)));
        } else if (singleValues.size() > 1) {
            disjuncts.add(PinotQueryBuilder.inClauseValues(columnName, singleValues));
        }
        return "(" + Joiner.on((String)" OR ").join(disjuncts) + ")";
    }

    private static Object convertValue(Type type, Object value) {
        if (type instanceof RealType) {
            return Float.valueOf(Float.intBitsToFloat(Math.toIntExact((Long)value)));
        }
        if (type instanceof VarcharType) {
            return ((Slice)value).toStringUtf8();
        }
        if (type instanceof VarbinaryType) {
            return Hex.encodeHexString((byte[])((Slice)value).getBytes());
        }
        return value;
    }

    private static String toConjunct(String columnName, String operator, Object value) {
        if (value instanceof Slice) {
            value = ((Slice)value).toStringUtf8();
        }
        return String.format("%s %s %s", PinotQueryBuilder.quoteIdentifier(columnName), operator, PinotQueryBuilder.singleQuote(value));
    }

    private static String inClauseValues(String columnName, List<Object> singleValues) {
        return String.format("%s IN (%s)", PinotQueryBuilder.quoteIdentifier(columnName), singleValues.stream().map(PinotQueryBuilder::singleQuote).collect(Collectors.joining(", ")));
    }

    private static String singleQuote(Object value) {
        return String.format("'%s'", value);
    }

    private static String quoteIdentifier(String identifier) {
        return String.format("\"%s\"", identifier.replaceAll("\"", "\"\""));
    }
}

