/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot.query;

import com.google.common.collect.ImmutableMap;
import io.trino.plugin.pinot.PinotColumnHandle;
import io.trino.plugin.pinot.PinotErrorCode;
import io.trino.plugin.pinot.PinotException;
import io.trino.plugin.pinot.client.PinotClient;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunctionFactory;
import org.apache.pinot.segment.local.segment.index.datasource.EmptyDataSource;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.metadata.ColumnMetadataImpl;
import org.apache.pinot.spi.data.FieldSpec;

public class PinotTypeResolver {
    private final Map<String, DataSource> datasourceMap;

    public PinotTypeResolver(PinotClient pinotClient, String pinotTableName) {
        Objects.requireNonNull(pinotClient, "pinotClient is null");
        this.datasourceMap = PinotTypeResolver.getDataSourceMap(pinotClient, pinotTableName);
    }

    private static Map<String, DataSource> getDataSourceMap(PinotClient pinotClient, String pinotTableName) {
        try {
            return (Map)pinotClient.getTableSchema(pinotTableName).getFieldSpecMap().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> new EmptyDataSource((ColumnMetadata)new ColumnMetadataImpl.Builder().setFieldSpec((FieldSpec)entry.getValue()).build())));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public TransformResultMetadata resolveExpressionType(ExpressionContext expression, SchemaTableName schemaTableName, Map<String, ColumnHandle> columnHandles) {
        switch (expression.getType()) {
            case IDENTIFIER: {
                PinotColumnHandle columnHandle = (PinotColumnHandle)columnHandles.get(expression.getIdentifier().toLowerCase(Locale.ENGLISH));
                if (columnHandle == null) {
                    throw new ColumnNotFoundException(schemaTableName, expression.getIdentifier());
                }
                return PinotTypeResolver.fromTrinoType(columnHandle.getDataType());
            }
            case FUNCTION: {
                return TransformFunctionFactory.get((ExpressionContext)expression, this.datasourceMap).getResultMetadata();
            }
            case LITERAL: {
                FieldSpec.DataType literalDataType = new LiteralTransformFunction(expression.getLiteral()).getResultMetadata().getDataType();
                return new TransformResultMetadata(literalDataType, true, false);
            }
        }
        throw new PinotException(PinotErrorCode.PINOT_INVALID_PQL_GENERATED, Optional.empty(), String.format("Unsupported expression: '%s'", expression));
    }

    public static TransformResultMetadata fromTrinoType(Type type) {
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            Type elementType = arrayType.getElementType();
            return new TransformResultMetadata(PinotTypeResolver.fromPrimitiveTrinoType(elementType), false, false);
        }
        return new TransformResultMetadata(PinotTypeResolver.fromPrimitiveTrinoType(type), true, false);
    }

    private static FieldSpec.DataType fromPrimitiveTrinoType(Type type) {
        if (type instanceof VarcharType) {
            return FieldSpec.DataType.STRING;
        }
        if (type instanceof BigintType) {
            return FieldSpec.DataType.LONG;
        }
        if (type instanceof IntegerType) {
            return FieldSpec.DataType.INT;
        }
        if (type instanceof DoubleType) {
            return FieldSpec.DataType.DOUBLE;
        }
        if (type instanceof RealType) {
            return FieldSpec.DataType.FLOAT;
        }
        if (type instanceof BooleanType) {
            return FieldSpec.DataType.BOOLEAN;
        }
        if (type instanceof VarbinaryType) {
            return FieldSpec.DataType.BYTES;
        }
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_COLUMN_TYPE, Optional.empty(), "Unsupported column data type: " + type);
    }
}

