/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.trace;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pinot.spi.trace.InvocationRecording;
import org.apache.pinot.spi.trace.InvocationScope;
import org.apache.pinot.spi.trace.NoOpRecording;
import org.apache.pinot.spi.trace.Tracer;

public class Tracing {
    private static final AtomicReference<Tracer> REGISTRATION = new AtomicReference();

    private Tracing() {
    }

    public static boolean register(Tracer tracer) {
        return REGISTRATION.compareAndSet(null, tracer);
    }

    public static Tracer getTracer() {
        return Holder.TRACER;
    }

    public static InvocationRecording activeRecording() {
        return Tracing.getTracer().activeRecording();
    }

    private static Tracer createDefaultTracer() {
        String defaultImplementationClassName = "org.apache.pinot.core.util.trace.BuiltInTracer";
        try {
            Class<?> clazz = Class.forName(defaultImplementationClassName, false, Tracing.class.getClassLoader());
            return MethodHandles.publicLookup().findConstructor(clazz, MethodType.methodType(Void.TYPE)).invoke();
        }
        catch (Throwable missing) {
            return FallbackTracer.INSTANCE;
        }
    }

    private static final class FallbackTracer
    implements Tracer {
        static final FallbackTracer INSTANCE = new FallbackTracer();

        private FallbackTracer() {
        }

        @Override
        public void register(long requestId) {
        }

        @Override
        public void unregister() {
        }

        @Override
        public InvocationScope createScope(Class<?> clazz) {
            return NoOpRecording.INSTANCE;
        }

        @Override
        public InvocationRecording activeRecording() {
            return NoOpRecording.INSTANCE;
        }
    }

    private static final class Holder {
        static final Tracer TRACER = REGISTRATION.get() == null ? Tracing.createDefaultTracer() : REGISTRATION.get();

        private Holder() {
        }
    }
}

