/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.utils;

import org.apache.pinot.spi.config.instance.InstanceType;

public class InstanceTypeUtils {
    private InstanceTypeUtils() {
    }

    public static InstanceType getInstanceType(String instanceId) {
        if (instanceId.startsWith("Controller_")) {
            return InstanceType.CONTROLLER;
        }
        if (instanceId.startsWith("Broker_")) {
            return InstanceType.BROKER;
        }
        if (instanceId.startsWith("Minion_")) {
            return InstanceType.MINION;
        }
        return InstanceType.SERVER;
    }

    public static boolean isController(String instanceId) {
        return instanceId.startsWith("Controller_");
    }

    public static boolean isBroker(String instanceId) {
        return instanceId.startsWith("Broker_");
    }

    public static boolean isServer(String instanceId) {
        if (instanceId.startsWith("Server_")) {
            return true;
        }
        return !InstanceTypeUtils.isController(instanceId) && !InstanceTypeUtils.isBroker(instanceId) && !InstanceTypeUtils.isMinion(instanceId);
    }

    public static boolean isMinion(String instanceId) {
        return instanceId.startsWith("Minion_");
    }
}

