/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.utils;

import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.spi.data.FieldSpec;

public class NullValueUtils {
    private static final Map<FieldSpec.DataType, Object> FIELD_TYPE_DEFAULT_NULL_VALUE_MAP;

    private NullValueUtils() {
    }

    public static Object getDefaultNullValue(FieldSpec.DataType dataType) {
        return FIELD_TYPE_DEFAULT_NULL_VALUE_MAP.get((Object)dataType);
    }

    static {
        FieldSpec.DataType[] types;
        FIELD_TYPE_DEFAULT_NULL_VALUE_MAP = new HashMap<FieldSpec.DataType, Object>();
        for (FieldSpec.DataType type : types = new FieldSpec.DataType[]{FieldSpec.DataType.INT, FieldSpec.DataType.LONG, FieldSpec.DataType.FLOAT, FieldSpec.DataType.DOUBLE, FieldSpec.DataType.BIG_DECIMAL, FieldSpec.DataType.BOOLEAN, FieldSpec.DataType.TIMESTAMP, FieldSpec.DataType.STRING, FieldSpec.DataType.JSON, FieldSpec.DataType.BYTES}) {
            FieldSpec.FieldType fieldType = type.equals((Object)FieldSpec.DataType.BIG_DECIMAL) ? FieldSpec.FieldType.METRIC : FieldSpec.FieldType.DIMENSION;
            FIELD_TYPE_DEFAULT_NULL_VALUE_MAP.put(type, FieldSpec.getDefaultNullValue(fieldType, type, null));
        }
    }
}

