/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.api;

import java.io.IOException;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import org.glassfish.hk2.api.DescriptorFileFinder;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.Populator;
import org.glassfish.hk2.api.PopulatorPostProcessor;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.ClasspathDescriptorFileFinder;
import org.glassfish.hk2.utilities.DuplicatePostProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceAutoDiscoveryFeature
implements Feature {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceAutoDiscoveryFeature.class);
    @Inject
    ServiceLocator _serviceLocator;

    public boolean configure(FeatureContext context) {
        DynamicConfigurationService dcs = (DynamicConfigurationService)this._serviceLocator.getService(DynamicConfigurationService.class, new Annotation[0]);
        Populator populator = dcs.getPopulator();
        try {
            populator.populate((DescriptorFileFinder)new ClasspathDescriptorFileFinder(this.getClass().getClassLoader()), new PopulatorPostProcessor[]{new DuplicatePostProcessor()});
        }
        catch (IOException | MultiException ex) {
            LOGGER.error("Failed to register service locator. Auto-discovery will fail, but app will continue", ex);
        }
        return true;
    }
}

