/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.common;

import java.math.BigDecimal;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.core.common.DataFetcher;
import org.apache.pinot.segment.spi.evaluator.TransformEvaluator;
import org.apache.pinot.spi.data.FieldSpec;

public class DataBlockCache {
    private final DataFetcher _dataFetcher;
    private final Set<String> _columnDictIdLoaded = new HashSet<String>();
    private final Map<FieldSpec.DataType, Set<String>> _columnValueLoaded = new EnumMap<FieldSpec.DataType, Set<String>>(FieldSpec.DataType.class);
    private final Set<String> _columnNumValuesLoaded = new HashSet<String>();
    private final Map<String, Object> _dictIdsMap = new HashMap<String, Object>();
    private final Map<FieldSpec.DataType, Map<String, Object>> _valuesMap = new HashMap<FieldSpec.DataType, Map<String, Object>>();
    private final Map<String, int[]> _numValuesMap = new HashMap<String, int[]>();
    private int[] _docIds;
    private int _length;

    public DataBlockCache(DataFetcher dataFetcher) {
        this._dataFetcher = dataFetcher;
    }

    public void initNewBlock(int[] docIds, int length) {
        this._docIds = docIds;
        if (length > this._length) {
            this._dictIdsMap.clear();
            this._valuesMap.clear();
            this._numValuesMap.clear();
        }
        this._length = length;
        this._columnDictIdLoaded.clear();
        for (Set<String> columns : this._columnValueLoaded.values()) {
            columns.clear();
        }
        this._columnNumValuesLoaded.clear();
    }

    public int getNumDocs() {
        return this._length;
    }

    public int[] getDocIds() {
        return this._docIds;
    }

    public int[] getDictIdsForSVColumn(String column) {
        int[] dictIds = (int[])this._dictIdsMap.get(column);
        if (this._columnDictIdLoaded.add(column)) {
            if (dictIds == null) {
                dictIds = new int[this._length];
                this._dictIdsMap.put(column, dictIds);
            }
            this._dataFetcher.fetchDictIds(column, this._docIds, this._length, dictIds);
        }
        return dictIds;
    }

    public int[] getIntValuesForSVColumn(String column) {
        int[] intValues = (int[])this.getValues(FieldSpec.DataType.INT, column);
        if (this.markLoaded(FieldSpec.DataType.INT, column)) {
            if (intValues == null) {
                intValues = new int[this._length];
                this.putValues(FieldSpec.DataType.INT, column, intValues);
            }
            this._dataFetcher.fetchIntValues(column, this._docIds, this._length, intValues);
        }
        return intValues;
    }

    public void fillValues(String column, TransformEvaluator evaluator, int[] buffer) {
        this._dataFetcher.fetchIntValues(column, evaluator, this._docIds, this._length, buffer);
    }

    public long[] getLongValuesForSVColumn(String column) {
        long[] longValues = (long[])this.getValues(FieldSpec.DataType.LONG, column);
        if (this.markLoaded(FieldSpec.DataType.LONG, column)) {
            if (longValues == null) {
                longValues = new long[this._length];
                this.putValues(FieldSpec.DataType.LONG, column, longValues);
            }
            this._dataFetcher.fetchLongValues(column, this._docIds, this._length, longValues);
        }
        return longValues;
    }

    public void fillValues(String column, TransformEvaluator evaluator, long[] buffer) {
        this._dataFetcher.fetchLongValues(column, evaluator, this._docIds, this._length, buffer);
    }

    public float[] getFloatValuesForSVColumn(String column) {
        float[] floatValues = (float[])this.getValues(FieldSpec.DataType.FLOAT, column);
        if (this.markLoaded(FieldSpec.DataType.FLOAT, column)) {
            if (floatValues == null) {
                floatValues = new float[this._length];
                this.putValues(FieldSpec.DataType.FLOAT, column, floatValues);
            }
            this._dataFetcher.fetchFloatValues(column, this._docIds, this._length, floatValues);
        }
        return floatValues;
    }

    public void fillValues(String column, TransformEvaluator evaluator, float[] buffer) {
        this._dataFetcher.fetchFloatValues(column, evaluator, this._docIds, this._length, buffer);
    }

    public double[] getDoubleValuesForSVColumn(String column) {
        double[] doubleValues = (double[])this.getValues(FieldSpec.DataType.DOUBLE, column);
        if (this.markLoaded(FieldSpec.DataType.DOUBLE, column)) {
            if (doubleValues == null) {
                doubleValues = new double[this._length];
                this.putValues(FieldSpec.DataType.DOUBLE, column, doubleValues);
            }
            this._dataFetcher.fetchDoubleValues(column, this._docIds, this._length, doubleValues);
        }
        return doubleValues;
    }

    public void fillValues(String column, TransformEvaluator evaluator, double[] buffer) {
        this._dataFetcher.fetchDoubleValues(column, evaluator, this._docIds, this._length, buffer);
    }

    public BigDecimal[] getBigDecimalValuesForSVColumn(String column) {
        BigDecimal[] bigDecimalValues = (BigDecimal[])this.getValues(FieldSpec.DataType.BIG_DECIMAL, column);
        if (this.markLoaded(FieldSpec.DataType.BIG_DECIMAL, column)) {
            if (bigDecimalValues == null) {
                bigDecimalValues = new BigDecimal[this._length];
                this.putValues(FieldSpec.DataType.BIG_DECIMAL, column, bigDecimalValues);
            }
            this._dataFetcher.fetchBigDecimalValues(column, this._docIds, this._length, bigDecimalValues);
        }
        return bigDecimalValues;
    }

    public void fillValues(String column, TransformEvaluator evaluator, BigDecimal[] buffer) {
        this._dataFetcher.fetchBigDecimalValues(column, evaluator, this._docIds, this._length, buffer);
    }

    public String[] getStringValuesForSVColumn(String column) {
        String[] stringValues = (String[])this.getValues(FieldSpec.DataType.STRING, column);
        if (this.markLoaded(FieldSpec.DataType.STRING, column)) {
            if (stringValues == null) {
                stringValues = new String[this._length];
                this.putValues(FieldSpec.DataType.STRING, column, stringValues);
            }
            this._dataFetcher.fetchStringValues(column, this._docIds, this._length, stringValues);
        }
        return stringValues;
    }

    public void fillValues(String column, TransformEvaluator evaluator, String[] buffer) {
        this._dataFetcher.fetchStringValues(column, evaluator, this._docIds, this._length, buffer);
    }

    public byte[][] getBytesValuesForSVColumn(String column) {
        Object bytesValues = (byte[][])this.getValues(FieldSpec.DataType.BYTES, column);
        if (this.markLoaded(FieldSpec.DataType.BYTES, column)) {
            if (bytesValues == null) {
                bytesValues = new byte[this._length][];
                this.putValues(FieldSpec.DataType.BYTES, column, bytesValues);
            }
            this._dataFetcher.fetchBytesValues(column, this._docIds, this._length, (byte[][])bytesValues);
        }
        return bytesValues;
    }

    public int[][] getDictIdsForMVColumn(String column) {
        Object dictIds = (int[][])this._dictIdsMap.get(column);
        if (this._columnDictIdLoaded.add(column)) {
            if (dictIds == null) {
                dictIds = new int[this._length][];
                this._dictIdsMap.put(column, dictIds);
            }
            this._dataFetcher.fetchDictIds(column, this._docIds, this._length, (int[][])dictIds);
        }
        return dictIds;
    }

    public int[][] getIntValuesForMVColumn(String column) {
        Object intValues = (int[][])this.getValues(FieldSpec.DataType.INT, column);
        if (this.markLoaded(FieldSpec.DataType.INT, column)) {
            if (intValues == null) {
                intValues = new int[this._length][];
                this.putValues(FieldSpec.DataType.INT, column, intValues);
            }
            this._dataFetcher.fetchIntValues(column, this._docIds, this._length, (int[][])intValues);
        }
        return intValues;
    }

    public void fillValues(String column, TransformEvaluator evaluator, int[][] buffer) {
        this._dataFetcher.fetchIntValues(column, evaluator, this._docIds, this._length, buffer);
    }

    public long[][] getLongValuesForMVColumn(String column) {
        Object longValues = (long[][])this.getValues(FieldSpec.DataType.LONG, column);
        if (this.markLoaded(FieldSpec.DataType.LONG, column)) {
            if (longValues == null) {
                longValues = new long[this._length][];
                this.putValues(FieldSpec.DataType.LONG, column, longValues);
            }
            this._dataFetcher.fetchLongValues(column, this._docIds, this._length, (long[][])longValues);
        }
        return longValues;
    }

    public void fillValues(String column, TransformEvaluator evaluator, long[][] buffer) {
        this._dataFetcher.fetchLongValues(column, evaluator, this._docIds, this._length, buffer);
    }

    public float[][] getFloatValuesForMVColumn(String column) {
        Object floatValues = (float[][])this.getValues(FieldSpec.DataType.FLOAT, column);
        if (this.markLoaded(FieldSpec.DataType.FLOAT, column)) {
            if (floatValues == null) {
                floatValues = new float[this._length][];
                this.putValues(FieldSpec.DataType.FLOAT, column, floatValues);
            }
            this._dataFetcher.fetchFloatValues(column, this._docIds, this._length, (float[][])floatValues);
        }
        return floatValues;
    }

    public void fillValues(String column, TransformEvaluator evaluator, float[][] buffer) {
        this._dataFetcher.fetchFloatValues(column, evaluator, this._docIds, this._length, buffer);
    }

    public double[][] getDoubleValuesForMVColumn(String column) {
        Object doubleValues = (double[][])this.getValues(FieldSpec.DataType.DOUBLE, column);
        if (this.markLoaded(FieldSpec.DataType.DOUBLE, column)) {
            if (doubleValues == null) {
                doubleValues = new double[this._length][];
                this.putValues(FieldSpec.DataType.DOUBLE, column, doubleValues);
            }
            this._dataFetcher.fetchDoubleValues(column, this._docIds, this._length, (double[][])doubleValues);
        }
        return doubleValues;
    }

    public void fillValues(String column, TransformEvaluator evaluator, double[][] buffer) {
        this._dataFetcher.fetchDoubleValues(column, evaluator, this._docIds, this._length, buffer);
    }

    public String[][] getStringValuesForMVColumn(String column) {
        String[][] stringValues = (String[][])this.getValues(FieldSpec.DataType.STRING, column);
        if (this.markLoaded(FieldSpec.DataType.STRING, column)) {
            if (stringValues == null) {
                stringValues = new String[this._length][];
                this.putValues(FieldSpec.DataType.STRING, column, stringValues);
            }
            this._dataFetcher.fetchStringValues(column, this._docIds, this._length, stringValues);
        }
        return stringValues;
    }

    public void fillValues(String column, TransformEvaluator evaluator, String[][] buffer) {
        this._dataFetcher.fetchStringValues(column, evaluator, this._docIds, this._length, buffer);
    }

    public int[] getNumValuesForMVColumn(String column) {
        int[] numValues = this._numValuesMap.get(column);
        if (this._columnNumValuesLoaded.add(column)) {
            if (numValues == null) {
                numValues = new int[this._length];
                this._numValuesMap.put(column, numValues);
            }
            this._dataFetcher.fetchNumValues(column, this._docIds, this._length, numValues);
        }
        return numValues;
    }

    private boolean markLoaded(FieldSpec.DataType dataType, String column) {
        return this._columnValueLoaded.computeIfAbsent(dataType, k -> new HashSet()).add(column);
    }

    private <T> T getValues(FieldSpec.DataType dataType, String column) {
        return (T)this._valuesMap.computeIfAbsent(dataType, k -> new HashMap()).get(column);
    }

    private void putValues(FieldSpec.DataType dataType, String column, Object values) {
        this._valuesMap.get(dataType).put(column, values);
    }
}

