/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.common.datablock;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.datablock.BaseDataBlock;
import org.apache.pinot.core.common.datablock.DataBlockUtils;

public class ColumnarDataBlock
extends BaseDataBlock {
    private static final int VERSION = 1;
    protected int[] _cumulativeColumnOffsetSizeInBytes;
    protected int[] _columnSizeInBytes;

    public ColumnarDataBlock() {
    }

    public ColumnarDataBlock(int numRows, DataSchema dataSchema, String[] stringDictionary, byte[] fixedSizeDataBytes, byte[] variableSizeDataBytes) {
        super(numRows, dataSchema, stringDictionary, fixedSizeDataBytes, variableSizeDataBytes);
        this.computeBlockObjectConstants();
    }

    public ColumnarDataBlock(ByteBuffer byteBuffer) throws IOException {
        super(byteBuffer);
        this.computeBlockObjectConstants();
    }

    protected void computeBlockObjectConstants() {
        if (this._dataSchema != null) {
            this._cumulativeColumnOffsetSizeInBytes = new int[this._numColumns];
            this._columnSizeInBytes = new int[this._numColumns];
            DataBlockUtils.computeColumnSizeInBytes(this._dataSchema, this._columnSizeInBytes);
            int cumulativeColumnOffset = 0;
            for (int i = 0; i < this._numColumns; ++i) {
                this._cumulativeColumnOffsetSizeInBytes[i] = cumulativeColumnOffset;
                cumulativeColumnOffset += this._columnSizeInBytes[i] * this._numRows;
            }
        }
    }

    @Override
    protected int getDataBlockVersionType() {
        return 1 + (BaseDataBlock.Type.COLUMNAR.ordinal() << 5);
    }

    @Override
    protected int getOffsetInFixedBuffer(int rowId, int colId) {
        return this._cumulativeColumnOffsetSizeInBytes[colId] + this._columnSizeInBytes[colId] * rowId;
    }

    @Override
    protected int positionOffsetInVariableBufferAndGetLength(int rowId, int colId) {
        int offset = this.getOffsetInFixedBuffer(rowId, colId);
        this._variableSizeData.position(this._fixedSizeData.getInt(offset));
        return this._fixedSizeData.getInt(offset + 4);
    }

    public ColumnarDataBlock toMetadataOnlyDataTable() {
        ColumnarDataBlock metadataOnlyDataTable = new ColumnarDataBlock();
        metadataOnlyDataTable._metadata.putAll(this._metadata);
        metadataOnlyDataTable._errCodeToExceptionMap.putAll(this._errCodeToExceptionMap);
        return metadataOnlyDataTable;
    }

    public ColumnarDataBlock toDataOnlyDataTable() {
        return new ColumnarDataBlock(this._numRows, this._dataSchema, this._stringDictionary, this._fixedSizeDataBytes, this._variableSizeDataBytes);
    }
}

