/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.common.datablock;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.core.common.datablock.BaseDataBlock;
import org.apache.pinot.core.common.datablock.ColumnarDataBlock;
import org.apache.pinot.core.common.datablock.DataBlockUtils;
import org.apache.pinot.core.common.datablock.RowDataBlock;
import org.apache.pinot.spi.utils.ArrayCopyUtils;
import org.apache.pinot.spi.utils.BigDecimalUtils;
import org.apache.pinot.spi.utils.ByteArray;
import org.roaringbitmap.RoaringBitmap;

public class DataBlockBuilder {
    private final DataSchema _dataSchema;
    private final BaseDataBlock.Type _blockType;
    private final DataSchema.ColumnDataType[] _columnDataType;
    private int[] _columnOffsets;
    private int _rowSizeInBytes;
    private int[] _cumulativeColumnOffsetSizeInBytes;
    private int[] _columnSizeInBytes;
    private int _numRows;
    private int _numColumns;
    private final Object2IntOpenHashMap<String> _dictionary = new Object2IntOpenHashMap();
    private final ByteArrayOutputStream _fixedSizeDataByteArrayOutputStream = new ByteArrayOutputStream();
    private final DataOutputStream _fixedSizeDataOutputStream = new DataOutputStream(this._fixedSizeDataByteArrayOutputStream);
    private final ByteArrayOutputStream _variableSizeDataByteArrayOutputStream = new ByteArrayOutputStream();
    private final DataOutputStream _variableSizeDataOutputStream = new DataOutputStream(this._variableSizeDataByteArrayOutputStream);

    private DataBlockBuilder(DataSchema dataSchema, BaseDataBlock.Type blockType) {
        this._dataSchema = dataSchema;
        this._columnDataType = dataSchema.getStoredColumnDataTypes();
        this._blockType = blockType;
        this._numColumns = dataSchema.size();
        if (this._blockType == BaseDataBlock.Type.COLUMNAR) {
            this._cumulativeColumnOffsetSizeInBytes = new int[this._numColumns];
            this._columnSizeInBytes = new int[this._numColumns];
            DataBlockUtils.computeColumnSizeInBytes(this._dataSchema, this._columnSizeInBytes);
            int cumulativeColumnOffset = 0;
            for (int i = 0; i < this._numColumns; ++i) {
                this._cumulativeColumnOffsetSizeInBytes[i] = cumulativeColumnOffset;
                cumulativeColumnOffset += this._columnSizeInBytes[i] * this._numRows;
            }
        } else if (this._blockType == BaseDataBlock.Type.ROW) {
            this._columnOffsets = new int[this._numColumns];
            this._rowSizeInBytes = DataBlockUtils.computeColumnOffsets(dataSchema, this._columnOffsets);
        }
    }

    public void setNullRowIds(@Nullable RoaringBitmap nullRowIds) throws IOException {
        this._fixedSizeDataOutputStream.writeInt(this._variableSizeDataByteArrayOutputStream.size());
        if (nullRowIds == null || nullRowIds.isEmpty()) {
            this._fixedSizeDataOutputStream.writeInt(0);
        } else {
            byte[] bitmapBytes = ObjectSerDeUtils.ROARING_BITMAP_SER_DE.serialize(nullRowIds);
            this._fixedSizeDataOutputStream.writeInt(bitmapBytes.length);
            this._variableSizeDataByteArrayOutputStream.write(bitmapBytes);
        }
    }

    public static RowDataBlock buildFromRows(List<Object[]> rows, @Nullable RoaringBitmap[] colNullBitmaps, DataSchema dataSchema) throws IOException {
        DataBlockBuilder rowBuilder = new DataBlockBuilder(dataSchema, BaseDataBlock.Type.ROW);
        rowBuilder._numRows = rows.size();
        for (Object[] row : rows) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(rowBuilder._rowSizeInBytes);
            block16: for (int i = 0; i < rowBuilder._numColumns; ++i) {
                Object value = row[i];
                switch (rowBuilder._columnDataType[i]) {
                    case INT: {
                        byteBuffer.putInt(((Number)value).intValue());
                        continue block16;
                    }
                    case LONG: {
                        byteBuffer.putLong(((Number)value).longValue());
                        continue block16;
                    }
                    case FLOAT: {
                        byteBuffer.putFloat(((Number)value).floatValue());
                        continue block16;
                    }
                    case DOUBLE: {
                        byteBuffer.putDouble(((Number)value).doubleValue());
                        continue block16;
                    }
                    case BIG_DECIMAL: {
                        DataBlockBuilder.setColumn(rowBuilder, byteBuffer, (BigDecimal)value);
                        continue block16;
                    }
                    case STRING: {
                        DataBlockBuilder.setColumn(rowBuilder, byteBuffer, (String)value);
                        continue block16;
                    }
                    case BYTES: {
                        DataBlockBuilder.setColumn(rowBuilder, byteBuffer, (ByteArray)value);
                        continue block16;
                    }
                    case OBJECT: {
                        DataBlockBuilder.setColumn(rowBuilder, byteBuffer, value);
                        continue block16;
                    }
                    case BOOLEAN_ARRAY: 
                    case INT_ARRAY: {
                        DataBlockBuilder.setColumn(rowBuilder, byteBuffer, (int[])value);
                        continue block16;
                    }
                    case TIMESTAMP_ARRAY: 
                    case LONG_ARRAY: {
                        int length;
                        int[] ints;
                        if (value instanceof int[]) {
                            ints = (int[])value;
                            length = ints.length;
                            long[] longs = new long[length];
                            ArrayCopyUtils.copy((int[])ints, (long[])longs, (int)length);
                            DataBlockBuilder.setColumn(rowBuilder, byteBuffer, longs);
                            continue block16;
                        }
                        DataBlockBuilder.setColumn(rowBuilder, byteBuffer, (long[])value);
                        continue block16;
                    }
                    case FLOAT_ARRAY: {
                        DataBlockBuilder.setColumn(rowBuilder, byteBuffer, (float[])value);
                        continue block16;
                    }
                    case DOUBLE_ARRAY: {
                        double[] doubles;
                        int length;
                        int[] ints;
                        if (value instanceof int[]) {
                            ints = (int[])value;
                            length = ints.length;
                            doubles = new double[length];
                            ArrayCopyUtils.copy((int[])ints, (double[])doubles, (int)length);
                            DataBlockBuilder.setColumn(rowBuilder, byteBuffer, doubles);
                            continue block16;
                        }
                        if (value instanceof long[]) {
                            long[] longs = (long[])value;
                            length = longs.length;
                            doubles = new double[length];
                            ArrayCopyUtils.copy((long[])longs, (double[])doubles, (int)length);
                            DataBlockBuilder.setColumn(rowBuilder, byteBuffer, doubles);
                            continue block16;
                        }
                        if (value instanceof float[]) {
                            float[] floats = (float[])value;
                            length = floats.length;
                            doubles = new double[length];
                            ArrayCopyUtils.copy((float[])floats, (double[])doubles, (int)length);
                            DataBlockBuilder.setColumn(rowBuilder, byteBuffer, doubles);
                            continue block16;
                        }
                        DataBlockBuilder.setColumn(rowBuilder, byteBuffer, (double[])value);
                        continue block16;
                    }
                    case BYTES_ARRAY: 
                    case STRING_ARRAY: {
                        DataBlockBuilder.setColumn(rowBuilder, byteBuffer, (String[])value);
                        continue block16;
                    }
                    default: {
                        throw new IllegalStateException(String.format("Unsupported data type: %s for column: %s", rowBuilder._columnDataType[i], rowBuilder._dataSchema.getColumnName(i)));
                    }
                }
            }
            rowBuilder._fixedSizeDataByteArrayOutputStream.write(byteBuffer.array(), 0, byteBuffer.position());
        }
        if (colNullBitmaps != null) {
            for (RoaringBitmap nullBitmap : colNullBitmaps) {
                rowBuilder.setNullRowIds(nullBitmap);
            }
        }
        return DataBlockBuilder.buildRowBlock(rowBuilder);
    }

    public static ColumnarDataBlock buildFromColumns(List<Object[]> columns, @Nullable RoaringBitmap[] colNullBitmaps, DataSchema dataSchema) throws IOException {
        DataBlockBuilder columnarBuilder = new DataBlockBuilder(dataSchema, BaseDataBlock.Type.COLUMNAR);
        for (int i = 0; i < columns.size(); ++i) {
            Object[] column = columns.get(i);
            columnarBuilder._numRows = column.length;
            ByteBuffer byteBuffer = ByteBuffer.allocate(columnarBuilder._numRows * columnarBuilder._columnSizeInBytes[i]);
            switch (columnarBuilder._columnDataType[i]) {
                case INT: {
                    for (Object value : column) {
                        byteBuffer.putInt(((Number)value).intValue());
                    }
                    break;
                }
                case LONG: {
                    for (Object value : column) {
                        byteBuffer.putLong(((Number)value).longValue());
                    }
                    break;
                }
                case FLOAT: {
                    for (Object value : column) {
                        byteBuffer.putFloat(((Number)value).floatValue());
                    }
                    break;
                }
                case DOUBLE: {
                    for (Object value : column) {
                        byteBuffer.putDouble(((Number)value).doubleValue());
                    }
                    break;
                }
                case BIG_DECIMAL: {
                    for (Object value : column) {
                        DataBlockBuilder.setColumn(columnarBuilder, byteBuffer, (BigDecimal)value);
                    }
                    break;
                }
                case STRING: {
                    for (Object value : column) {
                        DataBlockBuilder.setColumn(columnarBuilder, byteBuffer, (String)value);
                    }
                    break;
                }
                case BYTES: {
                    for (Object value : column) {
                        DataBlockBuilder.setColumn(columnarBuilder, byteBuffer, (ByteArray)value);
                    }
                    break;
                }
                case OBJECT: {
                    for (Object value : column) {
                        DataBlockBuilder.setColumn(columnarBuilder, byteBuffer, value);
                    }
                    break;
                }
                case BOOLEAN_ARRAY: 
                case INT_ARRAY: {
                    for (Object value : column) {
                        DataBlockBuilder.setColumn(columnarBuilder, byteBuffer, (int[])value);
                    }
                    break;
                }
                case TIMESTAMP_ARRAY: 
                case LONG_ARRAY: {
                    int length;
                    int[] ints;
                    for (Object value : column) {
                        if (value instanceof int[]) {
                            ints = (int[])value;
                            length = ints.length;
                            long[] longs = new long[length];
                            ArrayCopyUtils.copy((int[])ints, (long[])longs, (int)length);
                            DataBlockBuilder.setColumn(columnarBuilder, byteBuffer, longs);
                            continue;
                        }
                        DataBlockBuilder.setColumn(columnarBuilder, byteBuffer, (long[])value);
                    }
                    break;
                }
                case FLOAT_ARRAY: {
                    for (Object value : column) {
                        DataBlockBuilder.setColumn(columnarBuilder, byteBuffer, (float[])value);
                    }
                    break;
                }
                case DOUBLE_ARRAY: {
                    int length;
                    int[] ints;
                    for (Object value : column) {
                        double[] doubles;
                        if (value instanceof int[]) {
                            ints = (int[])value;
                            length = ints.length;
                            doubles = new double[length];
                            ArrayCopyUtils.copy((int[])ints, (double[])doubles, (int)length);
                            DataBlockBuilder.setColumn(columnarBuilder, byteBuffer, doubles);
                            continue;
                        }
                        if (value instanceof long[]) {
                            long[] longs = (long[])value;
                            length = longs.length;
                            doubles = new double[length];
                            ArrayCopyUtils.copy((long[])longs, (double[])doubles, (int)length);
                            DataBlockBuilder.setColumn(columnarBuilder, byteBuffer, doubles);
                            continue;
                        }
                        if (value instanceof float[]) {
                            float[] floats = (float[])value;
                            length = floats.length;
                            doubles = new double[length];
                            ArrayCopyUtils.copy((float[])floats, (double[])doubles, (int)length);
                            DataBlockBuilder.setColumn(columnarBuilder, byteBuffer, doubles);
                            continue;
                        }
                        DataBlockBuilder.setColumn(columnarBuilder, byteBuffer, (double[])value);
                    }
                    break;
                }
                case BYTES_ARRAY: 
                case STRING_ARRAY: {
                    for (Object value : column) {
                        DataBlockBuilder.setColumn(columnarBuilder, byteBuffer, (String[])value);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Unsupported data type: %s for column: %s", columnarBuilder._columnDataType[i], columnarBuilder._dataSchema.getColumnName(i)));
                }
            }
            columnarBuilder._fixedSizeDataByteArrayOutputStream.write(byteBuffer.array(), 0, byteBuffer.position());
        }
        if (colNullBitmaps != null) {
            for (RoaringBitmap nullBitmap : colNullBitmaps) {
                columnarBuilder.setNullRowIds(nullBitmap);
            }
        }
        return DataBlockBuilder.buildColumnarBlock(columnarBuilder);
    }

    private static RowDataBlock buildRowBlock(DataBlockBuilder builder) {
        return new RowDataBlock(builder._numRows, builder._dataSchema, DataBlockBuilder.getReverseDictionary(builder._dictionary), builder._fixedSizeDataByteArrayOutputStream.toByteArray(), builder._variableSizeDataByteArrayOutputStream.toByteArray());
    }

    private static ColumnarDataBlock buildColumnarBlock(DataBlockBuilder builder) {
        return new ColumnarDataBlock(builder._numRows, builder._dataSchema, DataBlockBuilder.getReverseDictionary(builder._dictionary), builder._fixedSizeDataByteArrayOutputStream.toByteArray(), builder._variableSizeDataByteArrayOutputStream.toByteArray());
    }

    private static String[] getReverseDictionary(Object2IntOpenHashMap<String> dictionary) {
        String[] reverseDictionary = new String[dictionary.size()];
        for (Object2IntMap.Entry entry : dictionary.object2IntEntrySet()) {
            reverseDictionary[entry.getIntValue()] = (String)entry.getKey();
        }
        return reverseDictionary;
    }

    private static void setColumn(DataBlockBuilder builder, ByteBuffer byteBuffer, BigDecimal value) throws IOException {
        byteBuffer.putInt(builder._variableSizeDataByteArrayOutputStream.size());
        byte[] bytes = BigDecimalUtils.serialize((BigDecimal)value);
        byteBuffer.putInt(bytes.length);
        builder._variableSizeDataByteArrayOutputStream.write(bytes);
    }

    private static void setColumn(DataBlockBuilder builder, ByteBuffer byteBuffer, String value) {
        Object2IntOpenHashMap<String> dictionary = builder._dictionary;
        int dictId = dictionary.computeIntIfAbsent((Object)value, k -> dictionary.size());
        byteBuffer.putInt(dictId);
    }

    private static void setColumn(DataBlockBuilder builder, ByteBuffer byteBuffer, ByteArray value) throws IOException {
        byteBuffer.putInt(builder._variableSizeDataByteArrayOutputStream.size());
        byte[] bytes = value.getBytes();
        byteBuffer.putInt(bytes.length);
        builder._variableSizeDataByteArrayOutputStream.write(bytes);
    }

    private static void setColumn(DataBlockBuilder builder, ByteBuffer byteBuffer, Object value) throws IOException {
        byteBuffer.putInt(builder._variableSizeDataByteArrayOutputStream.size());
        int objectTypeValue = ObjectSerDeUtils.ObjectType.getObjectType(value).getValue();
        if (objectTypeValue == ObjectSerDeUtils.ObjectType.Null.getValue()) {
            byteBuffer.putInt(0);
            builder._variableSizeDataOutputStream.writeInt(objectTypeValue);
        } else {
            byte[] bytes = ObjectSerDeUtils.serialize(value, objectTypeValue);
            byteBuffer.putInt(bytes.length);
            builder._variableSizeDataOutputStream.writeInt(objectTypeValue);
            builder._variableSizeDataByteArrayOutputStream.write(bytes);
        }
    }

    private static void setColumn(DataBlockBuilder builder, ByteBuffer byteBuffer, int[] values) throws IOException {
        byteBuffer.putInt(builder._variableSizeDataByteArrayOutputStream.size());
        byteBuffer.putInt(values.length);
        for (int value : values) {
            builder._variableSizeDataOutputStream.writeInt(value);
        }
    }

    private static void setColumn(DataBlockBuilder builder, ByteBuffer byteBuffer, long[] values) throws IOException {
        byteBuffer.putInt(builder._variableSizeDataByteArrayOutputStream.size());
        byteBuffer.putInt(values.length);
        for (long value : values) {
            builder._variableSizeDataOutputStream.writeLong(value);
        }
    }

    private static void setColumn(DataBlockBuilder builder, ByteBuffer byteBuffer, float[] values) throws IOException {
        byteBuffer.putInt(builder._variableSizeDataByteArrayOutputStream.size());
        byteBuffer.putInt(values.length);
        for (float value : values) {
            builder._variableSizeDataOutputStream.writeFloat(value);
        }
    }

    private static void setColumn(DataBlockBuilder builder, ByteBuffer byteBuffer, double[] values) throws IOException {
        byteBuffer.putInt(builder._variableSizeDataByteArrayOutputStream.size());
        byteBuffer.putInt(values.length);
        for (double value : values) {
            builder._variableSizeDataOutputStream.writeDouble(value);
        }
    }

    private static void setColumn(DataBlockBuilder builder, ByteBuffer byteBuffer, String[] values) throws IOException {
        byteBuffer.putInt(builder._variableSizeDataByteArrayOutputStream.size());
        byteBuffer.putInt(values.length);
        Object2IntOpenHashMap<String> dictionary = builder._dictionary;
        for (String value : values) {
            int dictId = dictionary.computeIntIfAbsent((Object)value, k -> dictionary.size());
            builder._variableSizeDataOutputStream.writeInt(dictId);
        }
    }
}

