/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.common.datablock;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.datablock.BaseDataBlock;
import org.apache.pinot.core.common.datablock.ColumnarDataBlock;
import org.apache.pinot.core.common.datablock.MetadataBlock;
import org.apache.pinot.core.common.datablock.RowDataBlock;

public final class DataBlockUtils {
    protected static final int VERSION_TYPE_SHIFT = 5;

    private DataBlockUtils() {
    }

    public static MetadataBlock getErrorDataBlock(Exception e) {
        if (e instanceof ProcessingException) {
            return DataBlockUtils.getErrorDataBlock(Collections.singletonMap(((ProcessingException)e).getErrorCode(), e.getMessage()));
        }
        return DataBlockUtils.getErrorDataBlock(Collections.singletonMap(1000, e.getMessage()));
    }

    public static MetadataBlock getErrorDataBlock(Map<Integer, String> exceptions) {
        MetadataBlock errorBlock = new MetadataBlock();
        for (Map.Entry<Integer, String> exception : exceptions.entrySet()) {
            errorBlock.addException(exception.getKey(), exception.getValue());
        }
        return errorBlock;
    }

    public static MetadataBlock getEndOfStreamDataBlock(@Nonnull DataSchema dataSchema) {
        return new MetadataBlock(dataSchema);
    }

    public static BaseDataBlock getDataBlock(ByteBuffer byteBuffer) throws IOException {
        int versionType = byteBuffer.getInt();
        int version = versionType & 0x1F;
        BaseDataBlock.Type type = BaseDataBlock.Type.fromOrdinal(versionType >> 5);
        switch (type) {
            case COLUMNAR: {
                return new ColumnarDataBlock(byteBuffer);
            }
            case ROW: {
                return new RowDataBlock(byteBuffer);
            }
            case METADATA: {
                return new MetadataBlock(byteBuffer);
            }
        }
        throw new UnsupportedOperationException("Unsupported data table version: " + version + " with type: " + type);
    }

    public static List<Object[]> extraRows(BaseDataBlock dataBlock) {
        DataSchema dataSchema = dataBlock.getDataSchema();
        DataSchema.ColumnDataType[] storedColumnDataTypes = dataSchema.getStoredColumnDataTypes();
        int numRows = dataBlock.getNumberOfRows();
        int numColumns = storedColumnDataTypes.length;
        ArrayList<Object[]> rows = new ArrayList<Object[]>(numRows);
        for (int i = 0; i < numRows; ++i) {
            Object[] row = new Object[numColumns];
            block15: for (int j = 0; j < numColumns; ++j) {
                switch (storedColumnDataTypes[j]) {
                    case INT: {
                        row[j] = dataBlock.getInt(i, j);
                        continue block15;
                    }
                    case LONG: {
                        row[j] = dataBlock.getLong(i, j);
                        continue block15;
                    }
                    case FLOAT: {
                        row[j] = Float.valueOf(dataBlock.getFloat(i, j));
                        continue block15;
                    }
                    case DOUBLE: {
                        row[j] = dataBlock.getDouble(i, j);
                        continue block15;
                    }
                    case BIG_DECIMAL: {
                        row[j] = dataBlock.getBigDecimal(i, j);
                        continue block15;
                    }
                    case STRING: {
                        row[j] = dataBlock.getString(i, j);
                        continue block15;
                    }
                    case BYTES: {
                        row[j] = dataBlock.getBytes(i, j);
                        continue block15;
                    }
                    case INT_ARRAY: {
                        row[j] = dataBlock.getIntArray(i, j);
                        continue block15;
                    }
                    case LONG_ARRAY: {
                        row[j] = dataBlock.getLongArray(i, j);
                        continue block15;
                    }
                    case FLOAT_ARRAY: {
                        row[j] = dataBlock.getFloatArray(i, j);
                        continue block15;
                    }
                    case DOUBLE_ARRAY: {
                        row[j] = dataBlock.getDoubleArray(i, j);
                        continue block15;
                    }
                    case STRING_ARRAY: {
                        row[j] = dataBlock.getStringArray(i, j);
                        continue block15;
                    }
                    default: {
                        throw new IllegalStateException(String.format("Unsupported data type: %s for column: %s", storedColumnDataTypes[j], dataSchema.getColumnName(j)));
                    }
                }
            }
            rows.add(row);
        }
        return rows;
    }

    public static int computeColumnOffsets(DataSchema dataSchema, int[] columnOffsets) {
        int numColumns = columnOffsets.length;
        assert (numColumns == dataSchema.size());
        DataSchema.ColumnDataType[] storedColumnDataTypes = dataSchema.getStoredColumnDataTypes();
        int rowSizeInBytes = 0;
        block7: for (int i = 0; i < numColumns; ++i) {
            columnOffsets[i] = rowSizeInBytes;
            switch (storedColumnDataTypes[i]) {
                case INT: {
                    rowSizeInBytes += 4;
                    continue block7;
                }
                case LONG: {
                    rowSizeInBytes += 8;
                    continue block7;
                }
                case FLOAT: {
                    rowSizeInBytes += 4;
                    continue block7;
                }
                case DOUBLE: {
                    rowSizeInBytes += 8;
                    continue block7;
                }
                case STRING: {
                    rowSizeInBytes += 4;
                    continue block7;
                }
                default: {
                    rowSizeInBytes += 8;
                }
            }
        }
        return rowSizeInBytes;
    }

    public static void computeColumnSizeInBytes(DataSchema dataSchema, int[] columnSizes) {
        int numColumns = columnSizes.length;
        assert (numColumns == dataSchema.size());
        DataSchema.ColumnDataType[] storedColumnDataTypes = dataSchema.getStoredColumnDataTypes();
        block7: for (int i = 0; i < numColumns; ++i) {
            switch (storedColumnDataTypes[i]) {
                case INT: {
                    columnSizes[i] = 4;
                    continue block7;
                }
                case LONG: {
                    columnSizes[i] = 8;
                    continue block7;
                }
                case FLOAT: {
                    columnSizes[i] = 4;
                    continue block7;
                }
                case DOUBLE: {
                    columnSizes[i] = 8;
                    continue block7;
                }
                case STRING: {
                    columnSizes[i] = 4;
                    continue block7;
                }
                default: {
                    columnSizes[i] = 8;
                }
            }
        }
    }
}

