/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.common.datablock;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.core.common.datablock.BaseDataBlock;
import org.apache.pinot.core.common.datablock.DataBlockUtils;
import org.roaringbitmap.RoaringBitmap;

public class RowDataBlock
extends BaseDataBlock {
    private static final int VERSION = 1;
    protected int[] _columnOffsets;
    protected int _rowSizeInBytes;

    public RowDataBlock() {
    }

    public RowDataBlock(int numRows, DataSchema dataSchema, String[] stringDictionary, byte[] fixedSizeDataBytes, byte[] variableSizeDataBytes) {
        super(numRows, dataSchema, stringDictionary, fixedSizeDataBytes, variableSizeDataBytes);
        this.computeBlockObjectConstants();
    }

    public RowDataBlock(ByteBuffer byteBuffer) throws IOException {
        super(byteBuffer);
        this.computeBlockObjectConstants();
    }

    @Override
    @Nullable
    public RoaringBitmap getNullRowIds(int colId) {
        int position = this._numRows * this._rowSizeInBytes + colId * 4 * 2;
        if (this._fixedSizeData == null || position >= this._fixedSizeData.limit()) {
            return null;
        }
        this._fixedSizeData.position(position);
        int offset = this._fixedSizeData.getInt();
        int bytesLength = this._fixedSizeData.getInt();
        if (bytesLength > 0) {
            this._variableSizeData.position(offset);
            byte[] nullBitmapBytes = new byte[bytesLength];
            this._variableSizeData.get(nullBitmapBytes);
            return ObjectSerDeUtils.ROARING_BITMAP_SER_DE.deserialize(nullBitmapBytes);
        }
        return null;
    }

    protected void computeBlockObjectConstants() {
        if (this._dataSchema != null) {
            this._columnOffsets = new int[this._numColumns];
            this._rowSizeInBytes = DataBlockUtils.computeColumnOffsets(this._dataSchema, this._columnOffsets);
        }
    }

    @Override
    protected int getDataBlockVersionType() {
        return 1 + (BaseDataBlock.Type.ROW.ordinal() << 5);
    }

    @Override
    protected int getOffsetInFixedBuffer(int rowId, int colId) {
        return rowId * this._rowSizeInBytes + this._columnOffsets[colId];
    }

    @Override
    protected int positionOffsetInVariableBufferAndGetLength(int rowId, int colId) {
        int offset = this.getOffsetInFixedBuffer(rowId, colId);
        this._variableSizeData.position(this._fixedSizeData.getInt(offset));
        return this._fixedSizeData.getInt(offset + 4);
    }

    public RowDataBlock toMetadataOnlyDataTable() {
        RowDataBlock metadataOnlyDataTable = new RowDataBlock();
        metadataOnlyDataTable._metadata.putAll(this._metadata);
        metadataOnlyDataTable._errCodeToExceptionMap.putAll(this._errCodeToExceptionMap);
        return metadataOnlyDataTable;
    }

    public RowDataBlock toDataOnlyDataTable() {
        return new RowDataBlock(this._numRows, this._dataSchema, this._stringDictionary, this._fixedSizeDataBytes, this._variableSizeDataBytes);
    }
}

