/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.manager;

import java.io.File;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.helix.HelixManager;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.core.data.manager.realtime.SegmentUploader;
import org.apache.pinot.core.util.SegmentRefreshSemaphore;
import org.apache.pinot.segment.local.data.manager.TableDataManager;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.spi.env.PinotConfiguration;

@ThreadSafe
public interface InstanceDataManager {
    public void init(PinotConfiguration var1, HelixManager var2, ServerMetrics var3) throws ConfigurationException;

    public String getInstanceId();

    public void start();

    public void shutDown();

    public void deleteTable(String var1) throws Exception;

    public void addOfflineSegment(String var1, String var2, File var3) throws Exception;

    public void addRealtimeSegment(String var1, String var2) throws Exception;

    public void removeSegment(String var1, String var2) throws Exception;

    public void reloadSegment(String var1, String var2, boolean var3) throws Exception;

    public void reloadAllSegments(String var1, boolean var2, SegmentRefreshSemaphore var3) throws Exception;

    public void addOrReplaceSegment(String var1, String var2) throws Exception;

    public Set<String> getAllTables();

    @Nullable
    public TableDataManager getTableDataManager(String var1);

    @Nullable
    public SegmentMetadata getSegmentMetadata(String var1, String var2);

    public List<SegmentMetadata> getAllSegmentsMetadata(String var1);

    public File getSegmentDataDirectory(String var1, String var2);

    public String getSegmentFileDirectory();

    public int getMaxParallelRefreshThreads();

    public ZkHelixPropertyStore<ZNRecord> getPropertyStore();

    public SegmentUploader getSegmentUploader();

    public void forceCommit(String var1, Set<String> var2);
}

