/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.manager.offline;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.PrimaryKey;

class DimensionTable {
    private final Map<PrimaryKey, GenericRow> _lookupTable;
    private final Schema _tableSchema;
    private final List<String> _primaryKeyColumns;

    DimensionTable(Schema tableSchema, List<String> primaryKeyColumns) {
        this(tableSchema, primaryKeyColumns, new HashMap<PrimaryKey, GenericRow>());
    }

    DimensionTable(Schema tableSchema, List<String> primaryKeyColumns, Map<PrimaryKey, GenericRow> lookupTable) {
        this._lookupTable = lookupTable;
        this._tableSchema = tableSchema;
        this._primaryKeyColumns = primaryKeyColumns;
    }

    List<String> getPrimaryKeyColumns() {
        return this._primaryKeyColumns;
    }

    GenericRow get(PrimaryKey pk) {
        return this._lookupTable.get(pk);
    }

    boolean isEmpty() {
        return this._lookupTable.isEmpty();
    }

    FieldSpec getFieldSpecFor(String columnName) {
        return this._tableSchema.getFieldSpecFor(columnName);
    }
}

