/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.manager.realtime;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.helix.HelixManager;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.pinot.common.Utils;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.pinot.common.metadata.instance.InstanceZKMetadata;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerGauge;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.utils.LLCSegmentName;
import org.apache.pinot.common.utils.NamedThreadFactory;
import org.apache.pinot.common.utils.SegmentName;
import org.apache.pinot.common.utils.SegmentUtils;
import org.apache.pinot.common.utils.TarGzCompressionUtils;
import org.apache.pinot.common.utils.fetcher.SegmentFetcherFactory;
import org.apache.pinot.core.data.manager.BaseTableDataManager;
import org.apache.pinot.core.data.manager.offline.ImmutableSegmentDataManager;
import org.apache.pinot.core.data.manager.realtime.HLRealtimeSegmentDataManager;
import org.apache.pinot.core.data.manager.realtime.LLRealtimeSegmentDataManager;
import org.apache.pinot.core.data.manager.realtime.SegmentBuildTimeLeaseExtender;
import org.apache.pinot.core.util.PeerServerSegmentFinder;
import org.apache.pinot.segment.local.data.manager.SegmentDataManager;
import org.apache.pinot.segment.local.data.manager.TableDataManager;
import org.apache.pinot.segment.local.dedup.PartitionDedupMetadataManager;
import org.apache.pinot.segment.local.dedup.TableDedupMetadataManager;
import org.apache.pinot.segment.local.indexsegment.immutable.ImmutableSegmentImpl;
import org.apache.pinot.segment.local.indexsegment.immutable.ImmutableSegmentLoader;
import org.apache.pinot.segment.local.realtime.impl.RealtimeSegmentStatsHistory;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.segment.index.loader.LoaderUtils;
import org.apache.pinot.segment.local.segment.virtualcolumn.VirtualColumnProviderFactory;
import org.apache.pinot.segment.local.upsert.ConcurrentMapPartitionUpsertMetadataManager;
import org.apache.pinot.segment.local.upsert.PartitionUpsertMetadataManager;
import org.apache.pinot.segment.local.upsert.TableUpsertMetadataManager;
import org.apache.pinot.segment.local.upsert.TableUpsertMetadataManagerFactory;
import org.apache.pinot.segment.local.utils.SchemaUtils;
import org.apache.pinot.segment.local.utils.tablestate.TableStateUtils;
import org.apache.pinot.segment.spi.ImmutableSegment;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.creator.SegmentGeneratorConfig;
import org.apache.pinot.spi.config.table.DedupConfig;
import org.apache.pinot.spi.config.table.IndexingConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.UpsertConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.CommonConstants;

@ThreadSafe
public class RealtimeTableDataManager
extends BaseTableDataManager {
    private final ExecutorService _segmentAsyncExecutorService = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("SegmentAsyncExecutorService"));
    private SegmentBuildTimeLeaseExtender _leaseExtender;
    private RealtimeSegmentStatsHistory _statsHistory;
    private final Semaphore _segmentBuildSemaphore;
    private final Map<Integer, Semaphore> _partitionGroupIdToSemaphoreMap = new ConcurrentHashMap<Integer, Semaphore>();
    private static final String STATS_FILE_NAME = "segment-stats.ser";
    private static final String CONSUMERS_DIR = "consumers";
    private static final int MIN_INTERVAL_BETWEEN_STATS_UPDATES_MINUTES = 30;
    private final AtomicBoolean _allSegmentsLoaded = new AtomicBoolean();
    private TableDedupMetadataManager _tableDedupMetadataManager;
    private TableUpsertMetadataManager _tableUpsertMetadataManager;

    public RealtimeTableDataManager(Semaphore segmentBuildSemaphore) {
        this._segmentBuildSemaphore = segmentBuildSemaphore;
    }

    @Override
    protected void doInit() {
        UpsertConfig upsertConfig;
        boolean dedupEnabled;
        TableConfig tableConfig;
        this._leaseExtender = SegmentBuildTimeLeaseExtender.getOrCreate(this._instanceId, this._serverMetrics, this._tableNameWithType);
        File statsFile = new File(this._tableDataDir, STATS_FILE_NAME);
        try {
            this._statsHistory = RealtimeSegmentStatsHistory.deserialzeFrom((File)statsFile);
        }
        catch (IOException | ClassNotFoundException e) {
            this._logger.error("Error reading history object for table {} from {}", new Object[]{this._tableNameWithType, statsFile.getAbsolutePath(), e});
            File savedFile = new File(this._tableDataDir, "segment-stats.ser." + UUID.randomUUID());
            try {
                FileUtils.moveFile((File)statsFile, (File)savedFile);
            }
            catch (IOException e1) {
                this._logger.error("Could not move {} to {}", new Object[]{statsFile.getAbsolutePath(), savedFile.getAbsolutePath(), e1});
                throw new RuntimeException(e);
            }
            this._logger.warn("Saved unreadable {} into {}. Creating a fresh instance", (Object)statsFile.getAbsolutePath(), (Object)savedFile.getAbsolutePath());
            try {
                this._statsHistory = RealtimeSegmentStatsHistory.deserialzeFrom((File)statsFile);
            }
            catch (Exception e2) {
                Utils.rethrowException((Throwable)e2);
            }
        }
        this._statsHistory.setMinIntervalBetweenUpdatesMillis(TimeUnit.MILLISECONDS.convert(30L, TimeUnit.MINUTES));
        String consumerDirPath = this.getConsumerDir();
        File consumerDir = new File(consumerDirPath);
        if (consumerDir.exists()) {
            File[] segmentFiles = consumerDir.listFiles((dir, name) -> !name.equals(STATS_FILE_NAME));
            Preconditions.checkState((segmentFiles != null ? 1 : 0) != 0, (String)"Failed to list segment files from consumer dir: {} for table: {}", (Object)consumerDirPath, (Object)this._tableNameWithType);
            for (File file : segmentFiles) {
                if (file.delete()) {
                    this._logger.info("Deleted old file {}", (Object)file.getAbsolutePath());
                    continue;
                }
                this._logger.error("Cannot delete file {}", (Object)file.getAbsolutePath());
            }
        }
        Preconditions.checkState(((tableConfig = ZKMetadataProvider.getTableConfig((ZkHelixPropertyStore)this._propertyStore, (String)this._tableNameWithType)) != null ? 1 : 0) != 0, (String)"Failed to find table config for table: %s", (Object)this._tableNameWithType);
        DedupConfig dedupConfig = tableConfig.getDedupConfig();
        boolean bl = dedupEnabled = dedupConfig != null && dedupConfig.isDedupEnabled();
        if (dedupEnabled) {
            Schema schema = ZKMetadataProvider.getTableSchema((ZkHelixPropertyStore)this._propertyStore, (String)this._tableNameWithType);
            Preconditions.checkState((schema != null ? 1 : 0) != 0, (String)"Failed to find schema for table: %s", (Object)this._tableNameWithType);
            List primaryKeyColumns = schema.getPrimaryKeyColumns();
            Preconditions.checkState((!CollectionUtils.isEmpty((Collection)primaryKeyColumns) ? 1 : 0) != 0, (Object)"Primary key columns must be configured for dedup");
            this._tableDedupMetadataManager = new TableDedupMetadataManager(this._tableNameWithType, primaryKeyColumns, this._serverMetrics, dedupConfig.getHashFunction());
        }
        if ((upsertConfig = tableConfig.getUpsertConfig()) != null && upsertConfig.getMode() != UpsertConfig.Mode.NONE) {
            Preconditions.checkState((!dedupEnabled ? 1 : 0) != 0, (String)"Dedup and upsert cannot be both enabled for table: %s", (Object)this._tableUpsertMetadataManager);
            Schema schema = ZKMetadataProvider.getTableSchema((ZkHelixPropertyStore)this._propertyStore, (String)this._tableNameWithType);
            Preconditions.checkState((schema != null ? 1 : 0) != 0, (String)"Failed to find schema for table: %s", (Object)this._tableNameWithType);
            this._tableUpsertMetadataManager = TableUpsertMetadataManagerFactory.create((TableConfig)tableConfig, (Schema)schema, (TableDataManager)this, (ServerMetrics)this._serverMetrics);
        }
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doShutdown() {
        this._segmentAsyncExecutorService.shutdown();
        if (this._tableUpsertMetadataManager != null) {
            try {
                this._tableUpsertMetadataManager.close();
            }
            catch (IOException e) {
                this._logger.warn("Cannot close upsert metadata manager properly for table: {}", (Object)this._tableNameWithType, (Object)e);
            }
        }
        for (SegmentDataManager segmentDataManager : this._segmentDataManagerMap.values()) {
            segmentDataManager.destroy();
        }
        if (this._leaseExtender != null) {
            this._leaseExtender.shutDown();
        }
    }

    public RealtimeSegmentStatsHistory getStatsHistory() {
        return this._statsHistory;
    }

    public Semaphore getSegmentBuildSemaphore() {
        return this._segmentBuildSemaphore;
    }

    public String getConsumerDir() {
        File consumerDir;
        Object consumerDirPath = this._tableDataManagerConfig.getConsumerDir();
        if (consumerDirPath != null) {
            consumerDir = new File((String)consumerDirPath, this._tableNameWithType);
        } else {
            consumerDirPath = this._tableDataDir + File.separator + CONSUMERS_DIR;
            consumerDir = new File((String)consumerDirPath);
        }
        if (!consumerDir.exists() && !consumerDir.mkdirs()) {
            this._logger.error("Failed to create consumer directory {}", (Object)consumerDir.getAbsolutePath());
        }
        return consumerDir.getAbsolutePath();
    }

    public boolean isDedupEnabled() {
        return this._tableDedupMetadataManager != null;
    }

    public boolean isUpsertEnabled() {
        return this._tableUpsertMetadataManager != null;
    }

    public boolean isPartialUpsertEnabled() {
        return this._tableUpsertMetadataManager != null && this._tableUpsertMetadataManager.getUpsertMode() == UpsertConfig.Mode.PARTIAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSegment(String segmentName, TableConfig tableConfig, IndexLoadingConfig indexLoadingConfig) throws Exception {
        SegmentDataManager segmentDataManager = (SegmentDataManager)this._segmentDataManagerMap.get(segmentName);
        if (segmentDataManager != null) {
            this._logger.warn("Skipping adding existing segment: {} for table: {} with data manager class: {}", new Object[]{segmentName, this._tableNameWithType, segmentDataManager.getClass().getSimpleName()});
            return;
        }
        SegmentZKMetadata segmentZKMetadata = ZKMetadataProvider.getSegmentZKMetadata((ZkHelixPropertyStore)this._propertyStore, (String)this._tableNameWithType, (String)segmentName);
        Preconditions.checkNotNull((Object)segmentZKMetadata);
        Schema schema = ZKMetadataProvider.getTableSchema((ZkHelixPropertyStore)this._propertyStore, (String)this._tableNameWithType);
        Preconditions.checkNotNull((Object)schema);
        File segmentDir = new File(this._indexDir, segmentName);
        LoaderUtils.reloadFailureRecovery((File)segmentDir);
        boolean isHLCSegment = SegmentName.isHighLevelConsumerSegmentName((String)segmentName);
        if (segmentZKMetadata.getStatus().isCompleted()) {
            block15: {
                if (segmentDir.exists()) {
                    try {
                        this.addSegment(ImmutableSegmentLoader.load((File)segmentDir, (IndexLoadingConfig)indexLoadingConfig, (Schema)schema));
                        return;
                    }
                    catch (Exception e) {
                        if (!isHLCSegment) {
                            this._logger.error("Caught exception while loading segment: {}, downloading a new copy", (Object)segmentName, (Object)e);
                            FileUtils.deleteQuietly((File)segmentDir);
                            break block15;
                        }
                        throw new RuntimeException("Failed to load local HLC segment: " + segmentName, e);
                    }
                }
                if (isHLCSegment) {
                    throw new RuntimeException("Failed to find local copy for committed HLC segment: " + segmentName);
                }
            }
            this.downloadAndReplaceSegment(segmentName, segmentZKMetadata, indexLoadingConfig, tableConfig);
            return;
        }
        FileUtils.deleteQuietly((File)segmentDir);
        if (!this.isValid(schema, tableConfig.getIndexingConfig())) {
            this._logger.error("Not adding segment {}", (Object)segmentName);
            throw new RuntimeException("Mismatching schema/table config for " + this._tableNameWithType);
        }
        VirtualColumnProviderFactory.addBuiltInVirtualColumnsToSegmentSchema((Schema)schema, (String)segmentName);
        if (!isHLCSegment) {
            PartitionDedupMetadataManager partitionDedupMetadataManager;
            LLCSegmentName llcSegmentName = new LLCSegmentName(segmentName);
            int partitionGroupId = llcSegmentName.getPartitionGroupId();
            Semaphore semaphore = this._partitionGroupIdToSemaphoreMap.computeIfAbsent(partitionGroupId, k -> new Semaphore(1));
            ConcurrentMapPartitionUpsertMetadataManager partitionUpsertMetadataManager = this._tableUpsertMetadataManager != null ? this._tableUpsertMetadataManager.getOrCreatePartitionManager(partitionGroupId) : null;
            PartitionDedupMetadataManager partitionDedupMetadataManager2 = partitionDedupMetadataManager = this._tableDedupMetadataManager != null ? this._tableDedupMetadataManager.getOrCreatePartitionManager(partitionGroupId) : null;
            if ((this.isDedupEnabled() || this.isPartialUpsertEnabled()) && !this._allSegmentsLoaded.get()) {
                AtomicBoolean atomicBoolean = this._allSegmentsLoaded;
                synchronized (atomicBoolean) {
                    if (!this._allSegmentsLoaded.get()) {
                        TableStateUtils.waitForAllSegmentsLoaded((HelixManager)this._helixManager, (String)this._tableNameWithType);
                        this._allSegmentsLoaded.set(true);
                    }
                }
            }
            schema = SegmentGeneratorConfig.updateSchemaWithTimestampIndexes((Schema)schema, (Map)SegmentGeneratorConfig.extractTimestampIndexConfigsFromTableConfig((TableConfig)tableConfig));
            segmentDataManager = new LLRealtimeSegmentDataManager(segmentZKMetadata, tableConfig, this, this._indexDir.getAbsolutePath(), indexLoadingConfig, schema, llcSegmentName, semaphore, this._serverMetrics, (PartitionUpsertMetadataManager)partitionUpsertMetadataManager, partitionDedupMetadataManager);
        } else {
            InstanceZKMetadata instanceZKMetadata = ZKMetadataProvider.getInstanceZKMetadata((ZkHelixPropertyStore)this._propertyStore, (String)this._instanceId);
            segmentDataManager = new HLRealtimeSegmentDataManager(segmentZKMetadata, tableConfig, instanceZKMetadata, this, this._indexDir.getAbsolutePath(), indexLoadingConfig, schema, this._serverMetrics);
        }
        this._logger.info("Initialized RealtimeSegmentDataManager - " + segmentName);
        this._segmentDataManagerMap.put(segmentName, segmentDataManager);
        this._serverMetrics.addValueToTableGauge(this._tableNameWithType, (AbstractMetrics.Gauge)ServerGauge.SEGMENT_COUNT, 1L);
    }

    @Override
    public void addSegment(ImmutableSegment immutableSegment) {
        if (this.isUpsertEnabled()) {
            this.handleUpsert(immutableSegment);
            return;
        }
        if (this.isDedupEnabled()) {
            this.buildDedupMeta((ImmutableSegmentImpl)immutableSegment);
        }
        super.addSegment(immutableSegment);
    }

    private void buildDedupMeta(ImmutableSegmentImpl immutableSegment) {
        String segmentName = immutableSegment.getSegmentName();
        Integer partitionGroupId = SegmentUtils.getRealtimeSegmentPartitionId((String)segmentName, (String)this._tableNameWithType, (HelixManager)this._helixManager, null);
        Preconditions.checkNotNull((Object)partitionGroupId, (Object)String.format("PartitionGroupId is not available for segment: '%s' (dedup-enabled table: %s)", segmentName, this._tableNameWithType));
        PartitionDedupMetadataManager partitionDedupMetadataManager = this._tableDedupMetadataManager.getOrCreatePartitionManager(partitionGroupId.intValue());
        immutableSegment.enableDedup(partitionDedupMetadataManager);
        partitionDedupMetadataManager.addSegment((IndexSegment)immutableSegment);
    }

    private void handleUpsert(ImmutableSegment immutableSegment) {
        String segmentName = immutableSegment.getSegmentName();
        this._logger.info("Adding immutable segment: {} to upsert-enabled table: {}", (Object)segmentName, (Object)this._tableNameWithType);
        Integer partitionId = SegmentUtils.getRealtimeSegmentPartitionId((String)segmentName, (String)this._tableNameWithType, (HelixManager)this._helixManager, null);
        Preconditions.checkNotNull((Object)partitionId, (Object)String.format("Failed to get partition id for segment: %s (upsert-enabled table: %s)", segmentName, this._tableNameWithType));
        ConcurrentMapPartitionUpsertMetadataManager partitionUpsertMetadataManager = this._tableUpsertMetadataManager.getOrCreatePartitionManager(partitionId.intValue());
        this._serverMetrics.addValueToTableGauge(this._tableNameWithType, (AbstractMetrics.Gauge)ServerGauge.DOCUMENT_COUNT, (long)immutableSegment.getSegmentMetadata().getTotalDocs());
        this._serverMetrics.addValueToTableGauge(this._tableNameWithType, (AbstractMetrics.Gauge)ServerGauge.SEGMENT_COUNT, 1L);
        ImmutableSegmentDataManager newSegmentManager = new ImmutableSegmentDataManager(immutableSegment);
        SegmentDataManager oldSegmentManager = this._segmentDataManagerMap.put(segmentName, newSegmentManager);
        if (oldSegmentManager == null) {
            partitionUpsertMetadataManager.addSegment(immutableSegment);
            this._logger.info("Added new immutable segment: {} to upsert-enabled table: {}", (Object)segmentName, (Object)this._tableNameWithType);
        } else {
            IndexSegment oldSegment = oldSegmentManager.getSegment();
            partitionUpsertMetadataManager.replaceSegment(immutableSegment, oldSegment);
            this._logger.info("Replaced {} segment: {} of upsert-enabled table: {}", new Object[]{oldSegment instanceof ImmutableSegment ? "immutable" : "mutable", segmentName, this._tableNameWithType});
            this.releaseSegment(oldSegmentManager);
        }
    }

    @Override
    protected boolean allowDownload(String segmentName, SegmentZKMetadata zkMetadata) {
        if (SegmentName.isHighLevelConsumerSegmentName((String)segmentName) || zkMetadata.getStatus() == CommonConstants.Segment.Realtime.Status.IN_PROGRESS) {
            return false;
        }
        return !"".equals(zkMetadata.getDownloadUrl());
    }

    void downloadAndReplaceSegment(String segmentName, SegmentZKMetadata segmentZKMetadata, IndexLoadingConfig indexLoadingConfig, TableConfig tableConfig) {
        String uri = segmentZKMetadata.getDownloadUrl();
        if (!"".equals(uri)) {
            try {
                this.downloadSegmentFromDeepStore(segmentName, indexLoadingConfig, uri);
            }
            catch (Exception e) {
                this._logger.warn("Download segment {} from deepstore uri {} failed.", new Object[]{segmentName, uri, e});
                if (this.isPeerSegmentDownloadEnabled(tableConfig)) {
                    this.downloadSegmentFromPeer(segmentName, tableConfig.getValidationConfig().getPeerSegmentDownloadScheme(), indexLoadingConfig);
                }
                throw e;
            }
        } else if (this.isPeerSegmentDownloadEnabled(tableConfig)) {
            this.downloadSegmentFromPeer(segmentName, tableConfig.getValidationConfig().getPeerSegmentDownloadScheme(), indexLoadingConfig);
        } else {
            throw new RuntimeException("Peer segment download not enabled for segment " + segmentName);
        }
    }

    private void downloadSegmentFromDeepStore(String segmentName, IndexLoadingConfig indexLoadingConfig, String uri) {
        File segmentTarFile = new File(this._indexDir, segmentName + ".tar.gz");
        try {
            SegmentFetcherFactory.fetchSegmentToLocal((String)uri, (File)segmentTarFile);
            this._logger.info("Downloaded file from {} to {}; Length of downloaded file: {}", new Object[]{uri, segmentTarFile, segmentTarFile.length()});
            this.untarAndMoveSegment(segmentName, indexLoadingConfig, segmentTarFile);
        }
        catch (Exception e) {
            this._logger.warn("Failed to download segment {} from deep store: ", (Object)segmentName, (Object)e);
            throw new RuntimeException(e);
        }
        finally {
            FileUtils.deleteQuietly((File)segmentTarFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void untarAndMoveSegment(String segmentName, IndexLoadingConfig indexLoadingConfig, File segmentTarFile) throws IOException {
        File tempSegmentDir = this.getTmpSegmentDataDir("tmp-" + segmentName + "." + System.currentTimeMillis());
        try {
            File tempIndexDir = (File)TarGzCompressionUtils.untar((File)segmentTarFile, (File)tempSegmentDir).get(0);
            this._logger.info("Uncompressed file {} into tmp dir {}", (Object)segmentTarFile, (Object)tempSegmentDir);
            File indexDir = new File(this._indexDir, segmentName);
            FileUtils.deleteQuietly((File)indexDir);
            FileUtils.moveDirectory((File)tempIndexDir, (File)indexDir);
            this._logger.info("Replacing LLC Segment {}", (Object)segmentName);
            this.replaceLLSegment(segmentName, indexLoadingConfig);
        }
        finally {
            FileUtils.deleteQuietly((File)tempSegmentDir);
        }
    }

    private boolean isPeerSegmentDownloadEnabled(TableConfig tableConfig) {
        return "http".equalsIgnoreCase(tableConfig.getValidationConfig().getPeerSegmentDownloadScheme()) || "https".equalsIgnoreCase(tableConfig.getValidationConfig().getPeerSegmentDownloadScheme());
    }

    private void downloadSegmentFromPeer(String segmentName, String downloadScheme, IndexLoadingConfig indexLoadingConfig) {
        File segmentTarFile = new File(this._indexDir, segmentName + ".tar.gz");
        try {
            List<URI> peerSegmentURIs = PeerServerSegmentFinder.getPeerServerURIs(segmentName, downloadScheme, this._helixManager);
            SegmentFetcherFactory.getSegmentFetcher((String)downloadScheme).fetchSegmentToLocal(peerSegmentURIs, segmentTarFile);
            this._logger.info("Fetched segment {} from: {} to: {} of size: {}", new Object[]{segmentName, peerSegmentURIs, segmentTarFile, segmentTarFile.length()});
            this.untarAndMoveSegment(segmentName, indexLoadingConfig, segmentTarFile);
        }
        catch (Exception e) {
            this._logger.warn("Download and move segment {} from peer with scheme {} failed.", new Object[]{segmentName, downloadScheme, e});
            throw new RuntimeException(e);
        }
        finally {
            FileUtils.deleteQuietly((File)segmentTarFile);
        }
    }

    public void replaceHLSegment(SegmentZKMetadata segmentZKMetadata, IndexLoadingConfig indexLoadingConfig) throws Exception {
        ZKMetadataProvider.setSegmentZKMetadata((ZkHelixPropertyStore)this._propertyStore, (String)this._tableNameWithType, (SegmentZKMetadata)segmentZKMetadata);
        File indexDir = new File(this._indexDir, segmentZKMetadata.getSegmentName());
        Schema schema = ZKMetadataProvider.getTableSchema((ZkHelixPropertyStore)this._propertyStore, (String)this._tableNameWithType);
        this.addSegment(ImmutableSegmentLoader.load((File)indexDir, (IndexLoadingConfig)indexLoadingConfig, (Schema)schema));
    }

    public void replaceLLSegment(String segmentName, IndexLoadingConfig indexLoadingConfig) {
        try {
            File indexDir = new File(this._indexDir, segmentName);
            Schema schema = ZKMetadataProvider.getTableSchema((ZkHelixPropertyStore)this._propertyStore, (String)this._tableNameWithType);
            this.addSegment(ImmutableSegmentLoader.load((File)indexDir, (IndexLoadingConfig)indexLoadingConfig, (Schema)schema));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getServerInstance() {
        return this._instanceId;
    }

    private boolean isValid(Schema schema, IndexingConfig indexingConfig) {
        List sortedColumns = indexingConfig.getSortedColumn();
        boolean isValid = true;
        if (CollectionUtils.isNotEmpty((Collection)sortedColumns)) {
            FieldSpec fieldSpec;
            String sortedColumn = (String)sortedColumns.get(0);
            if (sortedColumns.size() > 1) {
                this._logger.warn("More than one sorted column configured. Using {}", (Object)sortedColumn);
            }
            if (!(fieldSpec = schema.getFieldSpecFor(sortedColumn)).isSingleValueField()) {
                this._logger.error("Cannot configure multi-valued column {} as sorted column", (Object)sortedColumn);
                isValid = false;
            }
        }
        try {
            SchemaUtils.validate((Schema)schema);
        }
        catch (Exception e) {
            this._logger.error("Caught exception while validating schema: {}", (Object)schema.getSchemaName(), (Object)e);
            isValid = false;
        }
        return isValid;
    }
}

