/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.data.table;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.data.table.BaseTable;
import org.apache.pinot.core.data.table.Key;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.data.table.TableResizer;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.request.context.QueryContext;

public abstract class IndexedTable
extends BaseTable {
    protected final Map<Key, Record> _lookupMap;
    protected final int _resultSize;
    protected final int _numKeyColumns;
    protected final AggregationFunction[] _aggregationFunctions;
    protected final boolean _hasOrderBy;
    protected final TableResizer _tableResizer;
    protected final int _trimSize;
    protected final int _trimThreshold;
    protected Collection<Record> _topRecords;
    private int _numResizes;
    private long _resizeTimeNs;

    protected IndexedTable(DataSchema dataSchema, QueryContext queryContext, int resultSize, int trimSize, int trimThreshold, Map<Key, Record> lookupMap) {
        super(dataSchema);
        this._lookupMap = lookupMap;
        this._resultSize = resultSize;
        List<ExpressionContext> groupByExpressions = queryContext.getGroupByExpressions();
        assert (groupByExpressions != null);
        this._numKeyColumns = groupByExpressions.size();
        this._aggregationFunctions = queryContext.getAggregationFunctions();
        List<OrderByExpressionContext> orderByExpressions = queryContext.getOrderByExpressions();
        if (orderByExpressions != null) {
            this._hasOrderBy = true;
            this._tableResizer = new TableResizer(dataSchema, queryContext);
            this._trimSize = Math.min(trimSize, trimThreshold / 2);
            this._trimThreshold = trimThreshold;
        } else {
            this._hasOrderBy = false;
            this._tableResizer = null;
            this._trimSize = Integer.MAX_VALUE;
            this._trimThreshold = Integer.MAX_VALUE;
        }
    }

    @Override
    public boolean upsert(Record record) {
        Object[] keyValues = Arrays.copyOf(record.getValues(), this._numKeyColumns);
        return this.upsert(new Key(keyValues), record);
    }

    protected void addOrUpdateRecord(Key key, Record newRecord) {
        this._lookupMap.compute(key, (k, v) -> {
            if (v == null) {
                return newRecord;
            }
            Object[] existingValues = v.getValues();
            Object[] newValues = newRecord.getValues();
            int aggNum = 0;
            for (int i = this._numKeyColumns; i < this._numColumns; ++i) {
                existingValues[i] = this._aggregationFunctions[aggNum++].merge(existingValues[i], newValues[i]);
            }
            return v;
        });
    }

    protected void updateExistingRecord(Key key, Record newRecord) {
        this._lookupMap.computeIfPresent(key, (k, v) -> {
            Object[] existingValues = v.getValues();
            Object[] newValues = newRecord.getValues();
            int aggNum = 0;
            for (int i = this._numKeyColumns; i < this._numColumns; ++i) {
                existingValues[i] = this._aggregationFunctions[aggNum++].merge(existingValues[i], newValues[i]);
            }
            return v;
        });
    }

    protected void resize() {
        assert (this._hasOrderBy);
        long startTimeNs = System.nanoTime();
        this._tableResizer.resizeRecordsMap(this._lookupMap, this._trimSize);
        long resizeTimeNs = System.nanoTime() - startTimeNs;
        ++this._numResizes;
        this._resizeTimeNs += resizeTimeNs;
    }

    @Override
    public void finish(boolean sort) {
        if (this._hasOrderBy) {
            long startTimeNs = System.nanoTime();
            this._topRecords = this._tableResizer.getTopRecords(this._lookupMap, this._resultSize, sort);
            long resizeTimeNs = System.nanoTime() - startTimeNs;
            ++this._numResizes;
            this._resizeTimeNs += resizeTimeNs;
        } else {
            this._topRecords = this._lookupMap.values();
        }
    }

    @Override
    public int size() {
        return this._topRecords != null ? this._topRecords.size() : this._lookupMap.size();
    }

    @Override
    public Iterator<Record> iterator() {
        return this._topRecords.iterator();
    }

    public int getNumResizes() {
        return this._numResizes;
    }

    public long getResizeTimeMs() {
        return TimeUnit.NANOSECONDS.toMillis(this._resizeTimeNs);
    }
}

