/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.geospatial.transform.function;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.local.utils.GeometrySerializer;
import org.apache.pinot.segment.local.utils.GeometryUtils;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.spi.data.FieldSpec;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class StAreaFunction
extends BaseTransformFunction {
    private TransformFunction _transformFunction;
    public static final String FUNCTION_NAME = "ST_Area";
    private double[] _results;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        Preconditions.checkArgument((arguments.size() == 1 ? 1 : 0) != 0, (String)"Exactly 1 argument is required for transform function: %s", (Object)this.getName());
        TransformFunction transformFunction = arguments.get(0);
        Preconditions.checkArgument((boolean)transformFunction.getResultMetadata().isSingleValue(), (String)"Argument must be single-valued for transform function: %s", (Object)this.getName());
        Preconditions.checkArgument((transformFunction.getResultMetadata().getDataType() == FieldSpec.DataType.BYTES || transformFunction instanceof LiteralTransformFunction ? 1 : 0) != 0, (String)"The first argument must be of type BYTES, but was %s", (Object)transformFunction.getResultMetadata().getDataType());
        this._transformFunction = transformFunction;
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return DOUBLE_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public double[] transformToDoubleValuesSV(ProjectionBlock projectionBlock) {
        if (this._results == null) {
            this._results = new double[10000];
        }
        byte[][] values = this._transformFunction.transformToBytesValuesSV(projectionBlock);
        int numDocs = projectionBlock.getNumDocs();
        for (int i = 0; i < numDocs; ++i) {
            Geometry geometry = GeometrySerializer.deserialize((byte[])values[i]);
            this._results[i] = GeometryUtils.isGeography((Geometry)geometry) ? this.calculateGeographyArea(geometry) : geometry.getArea();
        }
        return this._results;
    }

    private double calculateGeographyArea(Geometry geometry) {
        Polygon polygon = (Polygon)geometry;
        double sphericalExcess = Math.abs(StAreaFunction.computeSphericalExcess(polygon.getExteriorRing()));
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            sphericalExcess -= Math.abs(StAreaFunction.computeSphericalExcess(polygon.getInteriorRingN(i)));
        }
        return Math.abs(sphericalExcess * 6371010.0 * 6371010.0);
    }

    private static double computeSphericalExcess(LineString lineString) {
        if (lineString.getNumPoints() < 3) {
            throw new RuntimeException("Polygon is not valid: a loop contains less then 3 vertices.");
        }
        SphericalExcessCalculator calculator = new SphericalExcessCalculator(lineString.getEndPoint());
        for (int i = 1; i < lineString.getNumPoints(); ++i) {
            calculator.add(lineString.getPointN(i));
        }
        return calculator.computeSphericalExcess();
    }

    private static class SphericalExcessCalculator {
        private static final double TWO_PI = Math.PI * 2;
        private static final double THREE_PI = Math.PI * 3;
        private double _sphericalExcess;
        private double _courseDelta;
        private boolean _firstPoint;
        private double _firstInitialBearing;
        private double _previousFinalBearing;
        private double _previousPhi;
        private double _previousCos;
        private double _previousSin;
        private double _previousTan;
        private double _previousLongitude;
        private boolean _done;

        public SphericalExcessCalculator(Point endPoint) {
            this._previousPhi = Math.toRadians(endPoint.getY());
            this._previousSin = Math.sin(this._previousPhi);
            this._previousCos = Math.cos(this._previousPhi);
            this._previousTan = Math.tan(this._previousPhi / 2.0);
            this._previousLongitude = Math.toRadians(endPoint.getX());
            this._firstPoint = true;
        }

        private void add(Point point) throws IllegalStateException {
            Preconditions.checkState((!this._done ? 1 : 0) != 0, (Object)"Computation of spherical excess is complete");
            double phi = Math.toRadians(point.getY());
            double tan = Math.tan(phi / 2.0);
            double longitude = Math.toRadians(point.getX());
            if (longitude == this._previousLongitude && phi == this._previousPhi) {
                throw new RuntimeException("Polygon is not valid: it has two identical consecutive vertices");
            }
            double deltaLongitude = longitude - this._previousLongitude;
            this._sphericalExcess += 2.0 * Math.atan2(Math.tan(deltaLongitude / 2.0) * (this._previousTan + tan), 1.0 + this._previousTan * tan);
            double cos = Math.cos(phi);
            double sin = Math.sin(phi);
            double sinOfDeltaLongitude = Math.sin(deltaLongitude);
            double cosOfDeltaLongitude = Math.cos(deltaLongitude);
            double y = sinOfDeltaLongitude * cos;
            double x = this._previousCos * sin - this._previousSin * cos * cosOfDeltaLongitude;
            double initialBearing = (Math.atan2(y, x) + Math.PI * 2) % (Math.PI * 2);
            double finalY = -sinOfDeltaLongitude * this._previousCos;
            double finalX = this._previousSin * cos - this._previousCos * sin * cosOfDeltaLongitude;
            double finalBearing = (Math.atan2(finalY, finalX) + Math.PI) % (Math.PI * 2);
            if (this._firstPoint) {
                this._firstInitialBearing = initialBearing;
                this._firstPoint = false;
            } else {
                this._courseDelta += (initialBearing - this._previousFinalBearing + Math.PI * 3) % (Math.PI * 2) - Math.PI;
            }
            this._courseDelta += (finalBearing - initialBearing + Math.PI * 3) % (Math.PI * 2) - Math.PI;
            this._previousFinalBearing = finalBearing;
            this._previousCos = cos;
            this._previousSin = sin;
            this._previousPhi = phi;
            this._previousTan = tan;
            this._previousLongitude = longitude;
        }

        public double computeSphericalExcess() {
            if (!this._done) {
                this._courseDelta += (this._firstInitialBearing - this._previousFinalBearing + Math.PI * 3) % (Math.PI * 2) - Math.PI;
                if (Math.abs(this._courseDelta) < 0.7853981633974483) {
                    this._sphericalExcess = Math.abs(this._sphericalExcess) - Math.PI * 2;
                }
                this._done = true;
            }
            return this._sphericalExcess;
        }
    }
}

