/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.geospatial.transform.function;

import com.google.common.base.Preconditions;
import org.apache.pinot.core.geospatial.transform.function.BaseBinaryGeoTransformFunction;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.segment.local.utils.GeometryUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public class StDistanceFunction
extends BaseBinaryGeoTransformFunction {
    private static final float MIN_LATITUDE = -90.0f;
    private static final float MAX_LATITUDE = 90.0f;
    private static final float MIN_LONGITUDE = -180.0f;
    private static final float MAX_LONGITUDE = 180.0f;
    public static final String FUNCTION_NAME = "ST_Distance";

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return DOUBLE_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public double[] transformToDoubleValuesSV(ProjectionBlock projectionBlock) {
        return this.transformGeometryToDoubleValuesSV(projectionBlock);
    }

    @Override
    public double transformGeometryToDouble(Geometry firstGeometry, Geometry secondGeometry) {
        if (GeometryUtils.isGeography((Geometry)firstGeometry) != GeometryUtils.isGeography((Geometry)secondGeometry)) {
            throw new RuntimeException("The first and second arguments shall either all be geometry or all geography");
        }
        if (GeometryUtils.isGeography((Geometry)firstGeometry)) {
            return StDistanceFunction.sphericalDistance(firstGeometry, secondGeometry);
        }
        return firstGeometry.isEmpty() || secondGeometry.isEmpty() ? Double.NaN : firstGeometry.distance(secondGeometry);
    }

    private static void checkLatitude(double latitude) {
        Preconditions.checkArgument((latitude >= -90.0 && latitude <= 90.0 ? 1 : 0) != 0, (Object)"Latitude must be between -90 and 90");
    }

    private static void checkLongitude(double longitude) {
        Preconditions.checkArgument((longitude >= -180.0 && longitude <= 180.0 ? 1 : 0) != 0, (Object)"Longitude must be between -180 and 180");
    }

    private static double sphericalDistance(Geometry leftGeometry, Geometry rightGeometry) {
        Preconditions.checkArgument((boolean)(leftGeometry instanceof Point), (Object)"The left argument must be a point");
        Preconditions.checkArgument((boolean)(rightGeometry instanceof Point), (Object)"The right argument must be a point");
        Point leftPoint = (Point)leftGeometry;
        Point rightPoint = (Point)rightGeometry;
        return StDistanceFunction.greatCircleDistance(leftPoint.getX(), leftPoint.getY(), rightPoint.getX(), rightPoint.getY());
    }

    private static double greatCircleDistance(double longitude1, double latitude1, double longitude2, double latitude2) {
        StDistanceFunction.checkLatitude(latitude1);
        StDistanceFunction.checkLongitude(longitude1);
        StDistanceFunction.checkLatitude(latitude2);
        StDistanceFunction.checkLongitude(longitude2);
        double radianLatitude1 = Math.toRadians(latitude1);
        double radianLatitude2 = Math.toRadians(latitude2);
        double sin1 = Math.sin(radianLatitude1);
        double cos1 = Math.cos(radianLatitude1);
        double sin2 = Math.sin(radianLatitude2);
        double cos2 = Math.cos(radianLatitude2);
        double deltaLongitude = Math.toRadians(longitude1) - Math.toRadians(longitude2);
        double cosDeltaLongitude = Math.cos(deltaLongitude);
        double t1 = cos2 * Math.sin(deltaLongitude);
        double t2 = cos1 * sin2 - sin1 * cos2 * cosDeltaLongitude;
        double t3 = sin1 * sin2 + cos1 * cos2 * cosDeltaLongitude;
        return Math.atan2(Math.sqrt(t1 * t1 + t2 * t2), t3) * 6371010.0;
    }
}

