/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.minion;

import java.util.HashMap;
import java.util.Map;
import org.apache.helix.task.TaskConfig;
import org.apache.pinot.spi.utils.EqualityUtils;

public class PinotTaskConfig {
    private static final String TASK_ID_KEY = "TASK_ID";
    private static final String TASK_COMMAND_KEY = "TASK_COMMAND";
    private static final String TASK_TARGET_PARTITION_KEY = "TASK_TARGET_PARTITION";
    private final String _taskType;
    private final Map<String, String> _configs;

    public PinotTaskConfig(String taskType, Map<String, String> configs) {
        this._taskType = taskType;
        this._configs = configs;
    }

    public String getTaskType() {
        return this._taskType;
    }

    public Map<String, String> getConfigs() {
        return this._configs;
    }

    public TaskConfig toHelixTaskConfig(String taskName) {
        return new TaskConfig(this._taskType, new HashMap<String, String>(this._configs), taskName, null);
    }

    public static PinotTaskConfig fromHelixTaskConfig(TaskConfig helixTaskConfig) {
        HashMap<String, String> configs = new HashMap<String, String>(helixTaskConfig.getConfigMap());
        configs.remove(TASK_ID_KEY);
        configs.remove(TASK_COMMAND_KEY);
        configs.remove(TASK_TARGET_PARTITION_KEY);
        return new PinotTaskConfig(helixTaskConfig.getCommand(), configs);
    }

    public int hashCode() {
        int result = EqualityUtils.hashCodeOf((Object)this._taskType);
        result = EqualityUtils.hashCodeOf((int)result, this._configs);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PinotTaskConfig) {
            PinotTaskConfig that = (PinotTaskConfig)obj;
            return this._taskType.equals(that._taskType) && this._configs.equals(that._configs);
        }
        return false;
    }

    public String toString() {
        return "Task Type: " + this._taskType + ", Configs: " + this._configs;
    }
}

