/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.blocks.InstanceResponseBlock;
import org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.core.operator.combine.BaseCombineOperator;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.request.context.ThreadTimer;
import org.apache.pinot.segment.spi.FetchContext;
import org.apache.pinot.segment.spi.IndexSegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceResponseOperator
extends BaseOperator<InstanceResponseBlock> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceResponseOperator.class);
    private static final String EXPLAIN_NAME = "INSTANCE_RESPONSE";
    private final BaseCombineOperator _combineOperator;
    private final List<IndexSegment> _indexSegments;
    private final List<FetchContext> _fetchContexts;
    private final int _fetchContextSize;
    private final QueryContext _queryContext;
    private final ServerMetrics _serverMetrics;

    public InstanceResponseOperator(BaseCombineOperator combinedOperator, List<IndexSegment> indexSegments, List<FetchContext> fetchContexts, QueryContext queryContext, ServerMetrics serverMetrics) {
        this._combineOperator = combinedOperator;
        this._indexSegments = indexSegments;
        this._fetchContexts = fetchContexts;
        this._fetchContextSize = fetchContexts.size();
        this._queryContext = queryContext;
        this._serverMetrics = serverMetrics;
    }

    public static long calSystemActivitiesCpuTimeNs(long totalWallClockTimeNs, long multipleThreadCpuTimeNs, long mainThreadCpuTimeNs, int numServerThreads) {
        double perMultipleThreadCpuTimeNs = (double)multipleThreadCpuTimeNs * 1.0 / (double)numServerThreads;
        long systemActivitiesCpuTimeNs = Math.round((double)(totalWallClockTimeNs - mainThreadCpuTimeNs) - perMultipleThreadCpuTimeNs);
        return Math.max(systemActivitiesCpuTimeNs, 0L);
    }

    @Override
    protected InstanceResponseBlock getNextBlock() {
        InstanceResponseBlock instanceResponseBlock;
        IntermediateResultsBlock intermediateResultsBlock;
        if (ThreadTimer.isThreadCpuTimeMeasurementEnabled()) {
            long startWallClockTimeNs = System.nanoTime();
            ThreadTimer mainThreadTimer = new ThreadTimer();
            intermediateResultsBlock = this.getCombinedResults();
            instanceResponseBlock = new InstanceResponseBlock(intermediateResultsBlock);
            long mainThreadCpuTimeNs = mainThreadTimer.getThreadTimeNs();
            long totalWallClockTimeNs = System.nanoTime() - startWallClockTimeNs;
            long multipleThreadCpuTimeNs = intermediateResultsBlock.getExecutionThreadCpuTimeNs();
            int numServerThreads = intermediateResultsBlock.getNumServerThreads();
            long systemActivitiesCpuTimeNs = InstanceResponseOperator.calSystemActivitiesCpuTimeNs(totalWallClockTimeNs, multipleThreadCpuTimeNs, mainThreadCpuTimeNs, numServerThreads);
            long threadCpuTimeNs = mainThreadCpuTimeNs + multipleThreadCpuTimeNs;
            Map responseMetaData = instanceResponseBlock.getInstanceResponseDataTable().getMetadata();
            responseMetaData.put(DataTable.MetadataKey.THREAD_CPU_TIME_NS.getName(), String.valueOf(threadCpuTimeNs));
            responseMetaData.put(DataTable.MetadataKey.SYSTEM_ACTIVITIES_CPU_TIME_NS.getName(), String.valueOf(systemActivitiesCpuTimeNs));
        } else {
            intermediateResultsBlock = this.getCombinedResults();
            instanceResponseBlock = new InstanceResponseBlock(intermediateResultsBlock);
        }
        this.logAndEmitMetricForQueryHasMVSelectionOrderBy(intermediateResultsBlock);
        return instanceResponseBlock;
    }

    private void logAndEmitMetricForQueryHasMVSelectionOrderBy(IntermediateResultsBlock intermediateResultsBlock) {
        if (!intermediateResultsBlock.isQueryHasMVSelectionOrderBy()) {
            return;
        }
        String tableName = this._queryContext.getTableName();
        if (this._serverMetrics != null) {
            this._serverMetrics.addMeteredTableValue(tableName, (AbstractMetrics.Meter)ServerMeter.QUERY_HAS_MV_SELECTION_ORDER_BY, 1L);
        }
        LOGGER.warn("Table {} has MV column in ORDER BY. Expressions: {}", (Object)tableName, this._queryContext.getOrderByExpressions());
    }

    private IntermediateResultsBlock getCombinedResults() {
        try {
            this.prefetchAll();
            IntermediateResultsBlock intermediateResultsBlock = (IntermediateResultsBlock)this._combineOperator.nextBlock();
            return intermediateResultsBlock;
        }
        finally {
            this.releaseAll();
        }
    }

    private void prefetchAll() {
        for (int i = 0; i < this._fetchContextSize; ++i) {
            this._indexSegments.get(i).prefetch(this._fetchContexts.get(i));
        }
    }

    private void releaseAll() {
        for (int i = 0; i < this._fetchContextSize; ++i) {
            this._indexSegments.get(i).release(this._fetchContexts.get(i));
        }
    }

    @Override
    public String toExplainString() {
        return EXPLAIN_NAME;
    }

    @Override
    public List<Operator> getChildOperators() {
        return Collections.singletonList(this._combineOperator);
    }
}

