/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.blocks;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.core.common.Block;
import org.apache.pinot.core.common.BlockDocIdSet;
import org.apache.pinot.core.common.BlockDocIdValueSet;
import org.apache.pinot.core.common.BlockMetadata;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.datatable.DataTableBuilder;
import org.apache.pinot.core.common.datatable.DataTableFactory;
import org.apache.pinot.core.data.table.IntermediateRecord;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.data.table.Table;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.AggregationGroupByResult;
import org.apache.pinot.core.query.selection.SelectionOperatorUtils;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.NullValueUtils;
import org.roaringbitmap.RoaringBitmap;

public class IntermediateResultsBlock
implements Block {
    private DataSchema _dataSchema;
    private boolean _nullHandlingEnabled;
    private Collection<Object[]> _selectionResult;
    private AggregationFunction[] _aggregationFunctions;
    private List<Object> _aggregationResult;
    private AggregationGroupByResult _aggregationGroupByResult;
    private List<ProcessingException> _processingExceptions;
    private Collection<IntermediateRecord> _intermediateRecords;
    private long _numDocsScanned;
    private long _numEntriesScannedInFilter;
    private long _numEntriesScannedPostFilter;
    private long _numTotalDocs;
    private int _numSegmentsProcessed;
    private int _numSegmentsMatched;
    private int _numConsumingSegmentsProcessed;
    private int _numConsumingSegmentsMatched;
    private boolean _numGroupsLimitReached;
    private int _numResizes;
    private long _resizeTimeMs;
    private long _executionThreadCpuTimeNs;
    private int _numServerThreads;
    private boolean _queryHasMVSelectionOrderBy;
    private Table _table;

    public IntermediateResultsBlock() {
    }

    public IntermediateResultsBlock(DataSchema dataSchema, Collection<Object[]> selectionResult, boolean nullHandlingEnabled) {
        this._dataSchema = dataSchema;
        this._selectionResult = selectionResult;
        this._nullHandlingEnabled = nullHandlingEnabled;
    }

    public IntermediateResultsBlock(AggregationFunction[] aggregationFunctions, List<Object> aggregationResult, boolean nullHandlingEnabled) {
        this._aggregationFunctions = aggregationFunctions;
        this._aggregationResult = aggregationResult;
        this._nullHandlingEnabled = nullHandlingEnabled;
    }

    public IntermediateResultsBlock(AggregationFunction[] aggregationFunctions, @Nullable AggregationGroupByResult aggregationGroupByResults, DataSchema dataSchema, boolean nullHandlingEnabled) {
        this._aggregationFunctions = aggregationFunctions;
        this._aggregationGroupByResult = aggregationGroupByResults;
        this._dataSchema = dataSchema;
        this._nullHandlingEnabled = nullHandlingEnabled;
    }

    public IntermediateResultsBlock(AggregationFunction[] aggregationFunctions, Collection<IntermediateRecord> intermediateRecords, DataSchema dataSchema, boolean nullHandlingEnabled) {
        this._aggregationFunctions = aggregationFunctions;
        this._dataSchema = dataSchema;
        this._intermediateRecords = intermediateRecords;
        this._nullHandlingEnabled = nullHandlingEnabled;
    }

    public IntermediateResultsBlock(Table table, boolean nullHandlingEnabled) {
        this._table = table;
        this._dataSchema = table.getDataSchema();
        this._nullHandlingEnabled = nullHandlingEnabled;
    }

    public IntermediateResultsBlock(ProcessingException processingException, Exception e) {
        this._processingExceptions = new ArrayList<ProcessingException>();
        this._processingExceptions.add(QueryException.getException((ProcessingException)processingException, (Exception)e));
        this._nullHandlingEnabled = false;
    }

    public IntermediateResultsBlock(Exception e) {
        this(QueryException.QUERY_EXECUTION_ERROR, e);
    }

    @Nullable
    public DataSchema getDataSchema() {
        return this._dataSchema;
    }

    public void setDataSchema(DataSchema dataSchema) {
        this._dataSchema = dataSchema;
    }

    @Nullable
    public Collection<Object[]> getSelectionResult() {
        return this._selectionResult;
    }

    public void setSelectionResult(Collection<Object[]> rowEventsSet) {
        this._selectionResult = rowEventsSet;
    }

    @Nullable
    public AggregationFunction[] getAggregationFunctions() {
        return this._aggregationFunctions;
    }

    public void setAggregationFunctions(AggregationFunction[] aggregationFunctions) {
        this._aggregationFunctions = aggregationFunctions;
    }

    @Nullable
    public List<Object> getAggregationResult() {
        return this._aggregationResult;
    }

    public void setAggregationResults(List<Object> aggregationResults) {
        this._aggregationResult = aggregationResults;
    }

    @Nullable
    public AggregationGroupByResult getAggregationGroupByResult() {
        return this._aggregationGroupByResult;
    }

    @Nullable
    public List<ProcessingException> getProcessingExceptions() {
        return this._processingExceptions;
    }

    public void setProcessingExceptions(List<ProcessingException> processingExceptions) {
        this._processingExceptions = processingExceptions;
    }

    public void addToProcessingExceptions(ProcessingException processingException) {
        if (this._processingExceptions == null) {
            this._processingExceptions = new ArrayList<ProcessingException>();
        }
        this._processingExceptions.add(processingException);
    }

    public void setNumResizes(int numResizes) {
        this._numResizes = numResizes;
    }

    public void setResizeTimeMs(long resizeTimeMs) {
        this._resizeTimeMs = resizeTimeMs;
    }

    public long getExecutionThreadCpuTimeNs() {
        return this._executionThreadCpuTimeNs;
    }

    public void setExecutionThreadCpuTimeNs(long executionThreadCpuTimeNs) {
        this._executionThreadCpuTimeNs = executionThreadCpuTimeNs;
    }

    public int getNumServerThreads() {
        return this._numServerThreads;
    }

    public void setNumServerThreads(int numServerThreads) {
        this._numServerThreads = numServerThreads;
    }

    @VisibleForTesting
    public long getNumDocsScanned() {
        return this._numDocsScanned;
    }

    public void setNumDocsScanned(long numDocsScanned) {
        this._numDocsScanned = numDocsScanned;
    }

    @VisibleForTesting
    public long getNumEntriesScannedInFilter() {
        return this._numEntriesScannedInFilter;
    }

    public void setNumEntriesScannedInFilter(long numEntriesScannedInFilter) {
        this._numEntriesScannedInFilter = numEntriesScannedInFilter;
    }

    @VisibleForTesting
    public long getNumEntriesScannedPostFilter() {
        return this._numEntriesScannedPostFilter;
    }

    public void setNumEntriesScannedPostFilter(long numEntriesScannedPostFilter) {
        this._numEntriesScannedPostFilter = numEntriesScannedPostFilter;
    }

    @VisibleForTesting
    public int getNumSegmentsProcessed() {
        return this._numSegmentsProcessed;
    }

    public void setNumSegmentsProcessed(int numSegmentsProcessed) {
        this._numSegmentsProcessed = numSegmentsProcessed;
    }

    @VisibleForTesting
    public int getNumSegmentsMatched() {
        return this._numSegmentsMatched;
    }

    public void setNumSegmentsMatched(int numSegmentsMatched) {
        this._numSegmentsMatched = numSegmentsMatched;
    }

    @VisibleForTesting
    public int getNumConsumingSegmentsProcessed() {
        return this._numConsumingSegmentsProcessed;
    }

    public void setNumConsumingSegmentsProcessed(int numConsumingSegmentsProcessed) {
        this._numConsumingSegmentsProcessed = numConsumingSegmentsProcessed;
    }

    @VisibleForTesting
    public int getNumConsumingSegmentsMatched() {
        return this._numConsumingSegmentsMatched;
    }

    public void setNumConsumingSegmentsMatched(int numConsumingSegmentsMatched) {
        this._numConsumingSegmentsMatched = numConsumingSegmentsMatched;
    }

    @VisibleForTesting
    public long getNumTotalDocs() {
        return this._numTotalDocs;
    }

    public void setNumTotalDocs(long numTotalDocs) {
        this._numTotalDocs = numTotalDocs;
    }

    @VisibleForTesting
    public boolean isNumGroupsLimitReached() {
        return this._numGroupsLimitReached;
    }

    public void setNumGroupsLimitReached(boolean numGroupsLimitReached) {
        this._numGroupsLimitReached = numGroupsLimitReached;
    }

    public boolean isQueryHasMVSelectionOrderBy() {
        return this._queryHasMVSelectionOrderBy;
    }

    public void setQueryHasMVSelectionOrderBy(boolean queryHasMVSelectionOrderBy) {
        this._queryHasMVSelectionOrderBy = queryHasMVSelectionOrderBy;
    }

    @Nullable
    public Collection<IntermediateRecord> getIntermediateRecords() {
        return this._intermediateRecords;
    }

    public DataTable getDataTable() throws Exception {
        if (this._table != null) {
            return this.getResultDataTable();
        }
        if (this._selectionResult != null) {
            return this.getSelectionResultDataTable();
        }
        if (this._aggregationResult != null) {
            return this.getAggregationResultDataTable();
        }
        return this.getMetadataDataTable();
    }

    private DataTable getResultDataTable() throws IOException {
        DataTableBuilder dataTableBuilder = DataTableFactory.getDataTableBuilder(this._dataSchema);
        DataSchema.ColumnDataType[] storedColumnDataTypes = this._dataSchema.getStoredColumnDataTypes();
        int numColumns = this._dataSchema.size();
        Iterator<Record> iterator = this._table.iterator();
        if (this._nullHandlingEnabled) {
            RoaringBitmap[] nullBitmaps = new RoaringBitmap[numColumns];
            Object[] colDefaultNullValues = new Object[numColumns];
            for (int colId = 0; colId < numColumns; ++colId) {
                if (storedColumnDataTypes[colId] != DataSchema.ColumnDataType.OBJECT) {
                    colDefaultNullValues[colId] = NullValueUtils.getDefaultNullValue((FieldSpec.DataType)storedColumnDataTypes[colId].toDataType());
                }
                nullBitmaps[colId] = new RoaringBitmap();
            }
            int rowId = 0;
            while (iterator.hasNext()) {
                Object[] values = iterator.next().getValues();
                dataTableBuilder.startRow();
                for (int columnIndex = 0; columnIndex < values.length; ++columnIndex) {
                    Object value = values[columnIndex];
                    if (value == null) {
                        value = colDefaultNullValues[columnIndex];
                        nullBitmaps[columnIndex].add(rowId);
                    }
                    this.setDataTableColumn(storedColumnDataTypes[columnIndex], dataTableBuilder, columnIndex, value);
                }
                dataTableBuilder.finishRow();
                ++rowId;
            }
            for (int colId = 0; colId < numColumns; ++colId) {
                dataTableBuilder.setNullRowIds(nullBitmaps[colId]);
            }
        } else {
            while (iterator.hasNext()) {
                Record record = iterator.next();
                dataTableBuilder.startRow();
                int columnIndex = 0;
                for (Object value : record.getValues()) {
                    this.setDataTableColumn(storedColumnDataTypes[columnIndex], dataTableBuilder, columnIndex, value);
                    ++columnIndex;
                }
                dataTableBuilder.finishRow();
            }
        }
        DataTable dataTable = dataTableBuilder.build();
        return this.attachMetadataToDataTable(dataTable);
    }

    private void setDataTableColumn(DataSchema.ColumnDataType columnDataType, DataTableBuilder dataTableBuilder, int columnIndex, Object value) throws IOException {
        switch (columnDataType) {
            case INT: {
                dataTableBuilder.setColumn(columnIndex, (Integer)value);
                break;
            }
            case LONG: {
                dataTableBuilder.setColumn(columnIndex, (Long)value);
                break;
            }
            case FLOAT: {
                dataTableBuilder.setColumn(columnIndex, ((Float)value).floatValue());
                break;
            }
            case DOUBLE: {
                dataTableBuilder.setColumn(columnIndex, (Double)value);
                break;
            }
            case BIG_DECIMAL: {
                dataTableBuilder.setColumn(columnIndex, (BigDecimal)value);
                break;
            }
            case STRING: {
                dataTableBuilder.setColumn(columnIndex, (String)value);
                break;
            }
            case BYTES: {
                dataTableBuilder.setColumn(columnIndex, (ByteArray)value);
                break;
            }
            case OBJECT: {
                dataTableBuilder.setColumn(columnIndex, value);
                break;
            }
            case INT_ARRAY: {
                dataTableBuilder.setColumn(columnIndex, (int[])value);
                break;
            }
            case LONG_ARRAY: {
                dataTableBuilder.setColumn(columnIndex, (long[])value);
                break;
            }
            case FLOAT_ARRAY: {
                dataTableBuilder.setColumn(columnIndex, (float[])value);
                break;
            }
            case DOUBLE_ARRAY: {
                dataTableBuilder.setColumn(columnIndex, (double[])value);
                break;
            }
            case STRING_ARRAY: {
                dataTableBuilder.setColumn(columnIndex, (String[])value);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private DataTable getSelectionResultDataTable() throws Exception {
        return this.attachMetadataToDataTable(SelectionOperatorUtils.getDataTableFromRows(this._selectionResult, this._dataSchema, this._nullHandlingEnabled));
    }

    private DataTable getAggregationResultDataTable() throws Exception {
        int i;
        int numAggregationFunctions = this._aggregationFunctions.length;
        String[] columnNames = new String[numAggregationFunctions];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numAggregationFunctions];
        for (int i2 = 0; i2 < numAggregationFunctions; ++i2) {
            AggregationFunction aggregationFunction = this._aggregationFunctions[i2];
            columnNames[i2] = aggregationFunction.getColumnName();
            columnDataTypes[i2] = aggregationFunction.getIntermediateResultColumnType();
        }
        RoaringBitmap[] nullBitmaps = null;
        Object[] colDefaultNullValues = null;
        if (this._nullHandlingEnabled) {
            colDefaultNullValues = new Object[numAggregationFunctions];
            nullBitmaps = new RoaringBitmap[numAggregationFunctions];
            for (int i3 = 0; i3 < numAggregationFunctions; ++i3) {
                if (columnDataTypes[i3] != DataSchema.ColumnDataType.OBJECT) {
                    colDefaultNullValues[i3] = NullValueUtils.getDefaultNullValue((FieldSpec.DataType)columnDataTypes[i3].toDataType());
                }
                nullBitmaps[i3] = new RoaringBitmap();
            }
        }
        DataTableBuilder dataTableBuilder = DataTableFactory.getDataTableBuilder(new DataSchema(columnNames, columnDataTypes));
        dataTableBuilder.startRow();
        if (this._nullHandlingEnabled) {
            block12: for (i = 0; i < numAggregationFunctions; ++i) {
                Object value = this._aggregationResult.get(i);
                if (columnDataTypes[i] != DataSchema.ColumnDataType.OBJECT && value == null) {
                    value = colDefaultNullValues[i];
                    nullBitmaps[i].add(0);
                }
                switch (columnDataTypes[i]) {
                    case LONG: {
                        dataTableBuilder.setColumn(i, ((Number)value).longValue());
                        continue block12;
                    }
                    case DOUBLE: {
                        dataTableBuilder.setColumn(i, (Double)value);
                        continue block12;
                    }
                    case OBJECT: {
                        dataTableBuilder.setColumn(i, value);
                        continue block12;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported aggregation column data type: " + columnDataTypes[i] + " for column: " + columnNames[i]);
                    }
                }
            }
        } else {
            block13: for (i = 0; i < numAggregationFunctions; ++i) {
                switch (columnDataTypes[i]) {
                    case LONG: {
                        dataTableBuilder.setColumn(i, ((Number)this._aggregationResult.get(i)).longValue());
                        continue block13;
                    }
                    case DOUBLE: {
                        dataTableBuilder.setColumn(i, (Double)this._aggregationResult.get(i));
                        continue block13;
                    }
                    case OBJECT: {
                        dataTableBuilder.setColumn(i, this._aggregationResult.get(i));
                        continue block13;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported aggregation column data type: " + columnDataTypes[i] + " for column: " + columnNames[i]);
                    }
                }
            }
        }
        dataTableBuilder.finishRow();
        if (this._nullHandlingEnabled) {
            for (i = 0; i < numAggregationFunctions; ++i) {
                dataTableBuilder.setNullRowIds(nullBitmaps[i]);
            }
        }
        DataTable dataTable = dataTableBuilder.build();
        return this.attachMetadataToDataTable(dataTable);
    }

    private DataTable getMetadataDataTable() {
        return this.attachMetadataToDataTable(DataTableFactory.getEmptyDataTable());
    }

    private DataTable attachMetadataToDataTable(DataTable dataTable) {
        dataTable.getMetadata().put(DataTable.MetadataKey.NUM_DOCS_SCANNED.getName(), String.valueOf(this._numDocsScanned));
        dataTable.getMetadata().put(DataTable.MetadataKey.NUM_ENTRIES_SCANNED_IN_FILTER.getName(), String.valueOf(this._numEntriesScannedInFilter));
        dataTable.getMetadata().put(DataTable.MetadataKey.NUM_ENTRIES_SCANNED_POST_FILTER.getName(), String.valueOf(this._numEntriesScannedPostFilter));
        dataTable.getMetadata().put(DataTable.MetadataKey.NUM_SEGMENTS_PROCESSED.getName(), String.valueOf(this._numSegmentsProcessed));
        dataTable.getMetadata().put(DataTable.MetadataKey.NUM_SEGMENTS_MATCHED.getName(), String.valueOf(this._numSegmentsMatched));
        dataTable.getMetadata().put(DataTable.MetadataKey.NUM_CONSUMING_SEGMENTS_PROCESSED.getName(), String.valueOf(this._numConsumingSegmentsProcessed));
        dataTable.getMetadata().put(DataTable.MetadataKey.NUM_CONSUMING_SEGMENTS_MATCHED.getName(), String.valueOf(this._numConsumingSegmentsMatched));
        dataTable.getMetadata().put(DataTable.MetadataKey.NUM_RESIZES.getName(), String.valueOf(this._numResizes));
        dataTable.getMetadata().put(DataTable.MetadataKey.RESIZE_TIME_MS.getName(), String.valueOf(this._resizeTimeMs));
        dataTable.getMetadata().put(DataTable.MetadataKey.TOTAL_DOCS.getName(), String.valueOf(this._numTotalDocs));
        if (this._numGroupsLimitReached) {
            dataTable.getMetadata().put(DataTable.MetadataKey.NUM_GROUPS_LIMIT_REACHED.getName(), "true");
        }
        if (this._processingExceptions != null && !this._processingExceptions.isEmpty()) {
            for (ProcessingException exception : this._processingExceptions) {
                dataTable.addException(exception);
            }
        }
        return dataTable;
    }

    @Override
    public BlockDocIdSet getBlockDocIdSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockValSet getBlockValueSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockDocIdValueSet getBlockDocIdValueSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockMetadata getMetadata() {
        throw new UnsupportedOperationException();
    }
}

