/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.combine;

import java.util.List;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.segment.spi.MutableSegment;

public class CombineOperatorUtils {
    public static final int MAX_NUM_THREADS_PER_QUERY = Math.max(1, Math.min(10, Runtime.getRuntime().availableProcessors() / 2));

    private CombineOperatorUtils() {
    }

    public static int getNumTasksForQuery(int numOperators, int maxExecutionThreads) {
        if (maxExecutionThreads > 0) {
            return Math.min(numOperators, maxExecutionThreads);
        }
        return Math.min(numOperators, MAX_NUM_THREADS_PER_QUERY);
    }

    public static void setExecutionStatistics(IntermediateResultsBlock resultsBlock, List<Operator> operators, long threadCpuTimeNs, int numServerThreads) {
        int numSegmentsProcessed = operators.size();
        int numSegmentsMatched = 0;
        int numConsumingSegmentsProcessed = 0;
        int numConsumingSegmentsMatched = 0;
        long numDocsScanned = 0L;
        long numEntriesScannedInFilter = 0L;
        long numEntriesScannedPostFilter = 0L;
        long numTotalDocs = 0L;
        for (Operator operator : operators) {
            ExecutionStatistics executionStatistics = operator.getExecutionStatistics();
            if (executionStatistics.getNumDocsScanned() > 0L) {
                ++numSegmentsMatched;
            }
            try {
                if (operator.getIndexSegment() instanceof MutableSegment) {
                    ++numConsumingSegmentsProcessed;
                    if (executionStatistics.getNumDocsScanned() > 0L) {
                        ++numConsumingSegmentsMatched;
                    }
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            numDocsScanned += executionStatistics.getNumDocsScanned();
            numEntriesScannedInFilter += executionStatistics.getNumEntriesScannedInFilter();
            numEntriesScannedPostFilter += executionStatistics.getNumEntriesScannedPostFilter();
            numTotalDocs += executionStatistics.getNumTotalDocs();
        }
        resultsBlock.setNumSegmentsProcessed(numSegmentsProcessed);
        resultsBlock.setNumSegmentsMatched(numSegmentsMatched);
        resultsBlock.setNumConsumingSegmentsProcessed(numConsumingSegmentsProcessed);
        resultsBlock.setNumConsumingSegmentsMatched(numConsumingSegmentsMatched);
        resultsBlock.setNumDocsScanned(numDocsScanned);
        resultsBlock.setNumEntriesScannedInFilter(numEntriesScannedInFilter);
        resultsBlock.setNumEntriesScannedPostFilter(numEntriesScannedPostFilter);
        resultsBlock.setNumTotalDocs(numTotalDocs);
        resultsBlock.setExecutionThreadCpuTimeNs(threadCpuTimeNs);
        resultsBlock.setNumServerThreads(numServerThreads);
    }
}

