/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.dociditerators;

import org.apache.pinot.core.operator.dociditerators.BitmapBasedDocIdIterator;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;

public final class BitmapDocIdIterator
implements BitmapBasedDocIdIterator {
    private final ImmutableRoaringBitmap _docIds;
    private final PeekableIntIterator _docIdIterator;
    private final int _numDocs;

    public BitmapDocIdIterator(ImmutableRoaringBitmap docIds, int numDocs) {
        this._docIds = docIds;
        this._docIdIterator = docIds.getIntIterator();
        this._numDocs = numDocs;
    }

    @Override
    public ImmutableRoaringBitmap getDocIds() {
        return this._docIds;
    }

    @Override
    public int next() {
        int docId;
        if (this._docIdIterator.hasNext() && (docId = this._docIdIterator.next()) < this._numDocs) {
            return docId;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int advance(int targetDocId) {
        this._docIdIterator.advanceIfNeeded(targetDocId);
        return this.next();
    }
}

