/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.docidsets;

import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.core.common.BlockDocIdIterator;
import org.apache.pinot.core.operator.dociditerators.AndDocIdIterator;
import org.apache.pinot.core.operator.dociditerators.BitmapBasedDocIdIterator;
import org.apache.pinot.core.operator.dociditerators.RangelessBitmapDocIdIterator;
import org.apache.pinot.core.operator.dociditerators.ScanBasedDocIdIterator;
import org.apache.pinot.core.operator.dociditerators.SortedDocIdIterator;
import org.apache.pinot.core.operator.docidsets.FilterBlockDocIdSet;
import org.apache.pinot.core.util.SortedRangeIntersection;
import org.apache.pinot.spi.utils.Pairs;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public final class AndDocIdSet
implements FilterBlockDocIdSet {
    private final List<FilterBlockDocIdSet> _docIdSets;

    public AndDocIdSet(List<FilterBlockDocIdSet> docIdSets) {
        this._docIdSets = docIdSets;
    }

    @Override
    public BlockDocIdIterator iterator() {
        int numDocIdSets = this._docIdSets.size();
        BlockDocIdIterator[] allDocIdIterators = new BlockDocIdIterator[numDocIdSets];
        ArrayList<SortedDocIdIterator> sortedDocIdIterators = new ArrayList<SortedDocIdIterator>();
        ArrayList<BitmapBasedDocIdIterator> bitmapBasedDocIdIterators = new ArrayList<BitmapBasedDocIdIterator>();
        ArrayList<ScanBasedDocIdIterator> scanBasedDocIdIterators = new ArrayList<ScanBasedDocIdIterator>();
        ArrayList<BlockDocIdIterator> remainingDocIdIterators = new ArrayList<BlockDocIdIterator>();
        for (int i = 0; i < numDocIdSets; ++i) {
            BlockDocIdIterator docIdIterator;
            allDocIdIterators[i] = docIdIterator = this._docIdSets.get(i).iterator();
            if (docIdIterator instanceof SortedDocIdIterator) {
                sortedDocIdIterators.add((SortedDocIdIterator)docIdIterator);
                continue;
            }
            if (docIdIterator instanceof BitmapBasedDocIdIterator) {
                bitmapBasedDocIdIterators.add((BitmapBasedDocIdIterator)docIdIterator);
                continue;
            }
            if (docIdIterator instanceof ScanBasedDocIdIterator) {
                scanBasedDocIdIterators.add((ScanBasedDocIdIterator)docIdIterator);
                continue;
            }
            remainingDocIdIterators.add(docIdIterator);
        }
        int numSortedDocIdIterators = sortedDocIdIterators.size();
        int numBitmapBasedDocIdIterators = bitmapBasedDocIdIterators.size();
        int numScanBasedDocIdIterators = scanBasedDocIdIterators.size();
        int numRemainingDocIdIterators = remainingDocIdIterators.size();
        int numIndexBasedDocIdIterators = numSortedDocIdIterators + numBitmapBasedDocIdIterators;
        if (numIndexBasedDocIdIterators > 0 && numScanBasedDocIdIterators > 0 || numIndexBasedDocIdIterators > 1) {
            Object docIds;
            if (numSortedDocIdIterators > 0) {
                List<Pairs.IntPair> docIdRanges;
                if (numSortedDocIdIterators == 1) {
                    docIdRanges = ((SortedDocIdIterator)sortedDocIdIterators.get(0)).getDocIdRanges();
                } else {
                    ArrayList<List<Pairs.IntPair>> docIdRangesList = new ArrayList<List<Pairs.IntPair>>(numSortedDocIdIterators);
                    for (SortedDocIdIterator sortedDocIdIterator : sortedDocIdIterators) {
                        docIdRangesList.add(sortedDocIdIterator.getDocIdRanges());
                    }
                    docIdRanges = SortedRangeIntersection.intersectSortedRangeSets(docIdRangesList);
                }
                MutableRoaringBitmap mutableDocIds = new MutableRoaringBitmap();
                for (Pairs.IntPair docIdRange : docIdRanges) {
                    mutableDocIds.add((long)docIdRange.getLeft(), (long)docIdRange.getRight() + 1L);
                }
                for (BitmapBasedDocIdIterator bitmapBasedDocIdIterator : bitmapBasedDocIdIterators) {
                    mutableDocIds.and(bitmapBasedDocIdIterator.getDocIds());
                }
                docIds = mutableDocIds;
            } else if (numBitmapBasedDocIdIterators == 1) {
                docIds = ((BitmapBasedDocIdIterator)bitmapBasedDocIdIterators.get(0)).getDocIds();
            } else {
                MutableRoaringBitmap mutableDocIds = ((BitmapBasedDocIdIterator)bitmapBasedDocIdIterators.get(0)).getDocIds().toMutableRoaringBitmap();
                for (int i = 1; i < numBitmapBasedDocIdIterators; ++i) {
                    mutableDocIds.and(((BitmapBasedDocIdIterator)bitmapBasedDocIdIterators.get(i)).getDocIds());
                }
                docIds = mutableDocIds;
            }
            for (ScanBasedDocIdIterator scanBasedDocIdIterator : scanBasedDocIdIterators) {
                docIds = scanBasedDocIdIterator.applyAnd((ImmutableRoaringBitmap)docIds);
            }
            RangelessBitmapDocIdIterator rangelessBitmapDocIdIterator = new RangelessBitmapDocIdIterator((ImmutableRoaringBitmap)docIds);
            if (numRemainingDocIdIterators == 0) {
                return rangelessBitmapDocIdIterator;
            }
            BlockDocIdIterator[] docIdIterators = new BlockDocIdIterator[numRemainingDocIdIterators + 1];
            docIdIterators[0] = rangelessBitmapDocIdIterator;
            for (int i = 0; i < numRemainingDocIdIterators; ++i) {
                docIdIterators[i + 1] = (BlockDocIdIterator)remainingDocIdIterators.get(i);
            }
            return new AndDocIdIterator(docIdIterators);
        }
        return new AndDocIdIterator(allDocIdIterators);
    }

    @Override
    public long getNumEntriesScannedInFilter() {
        long numEntriesScannedInFilter = 0L;
        for (FilterBlockDocIdSet child : this._docIdSets) {
            numEntriesScannedInFilter += child.getNumEntriesScannedInFilter();
        }
        return numEntriesScannedInFilter;
    }
}

