/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.docvalsets;

import java.math.BigDecimal;
import javax.annotation.Nullable;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.DataBlockCache;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.index.reader.NullValueVectorReader;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.trace.InvocationRecording;
import org.apache.pinot.spi.trace.InvocationScope;
import org.apache.pinot.spi.trace.Tracing;
import org.roaringbitmap.RoaringBitmap;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;

public class ProjectionBlockValSet
implements BlockValSet {
    private final DataBlockCache _dataBlockCache;
    private final String _column;
    private final DataSource _dataSource;
    private boolean _nullBitmapSet;
    private RoaringBitmap _nullBitmap;

    public ProjectionBlockValSet(DataBlockCache dataBlockCache, String column, DataSource dataSource) {
        this._dataBlockCache = dataBlockCache;
        this._column = column;
        this._dataSource = dataSource;
    }

    @Override
    @Nullable
    public RoaringBitmap getNullBitmap() {
        if (!this._nullBitmapSet) {
            ImmutableRoaringBitmap nullBitmap;
            NullValueVectorReader nullValueReader = this._dataSource.getNullValueVector();
            ImmutableRoaringBitmap immutableRoaringBitmap = nullBitmap = nullValueReader != null ? nullValueReader.getNullBitmap() : null;
            if (nullBitmap != null && !nullBitmap.isEmpty()) {
                RoaringBitmap projectedNullBitmap = new RoaringBitmap();
                int[] docIds = this._dataBlockCache.getDocIds();
                for (int i = 0; i < this._dataBlockCache.getNumDocs(); ++i) {
                    if (!nullBitmap.contains(docIds[i])) continue;
                    projectedNullBitmap.add(i);
                }
                this._nullBitmap = projectedNullBitmap;
            } else {
                this._nullBitmap = null;
            }
            this._nullBitmapSet = true;
        }
        return this._nullBitmap;
    }

    @Override
    public FieldSpec.DataType getValueType() {
        return this._dataSource.getDataSourceMetadata().getDataType();
    }

    @Override
    public boolean isSingleValue() {
        return this._dataSource.getDataSourceMetadata().isSingleValue();
    }

    @Override
    @Nullable
    public Dictionary getDictionary() {
        return this._dataSource.getDictionary();
    }

    @Override
    public int[] getDictionaryIdsSV() {
        try (InvocationScope scope = Tracing.getTracer().createScope(ProjectionBlockValSet.class);){
            this.recordReadValues((InvocationRecording)scope, FieldSpec.DataType.INT, true);
            int[] nArray = this._dataBlockCache.getDictIdsForSVColumn(this._column);
            return nArray;
        }
    }

    @Override
    public int[] getIntValuesSV() {
        try (InvocationScope scope = Tracing.getTracer().createScope(ProjectionBlockValSet.class);){
            this.recordReadValues((InvocationRecording)scope, FieldSpec.DataType.INT, true);
            int[] nArray = this._dataBlockCache.getIntValuesForSVColumn(this._column);
            return nArray;
        }
    }

    @Override
    public long[] getLongValuesSV() {
        try (InvocationScope scope = Tracing.getTracer().createScope(ProjectionBlockValSet.class);){
            this.recordReadValues((InvocationRecording)scope, FieldSpec.DataType.LONG, true);
            long[] lArray = this._dataBlockCache.getLongValuesForSVColumn(this._column);
            return lArray;
        }
    }

    @Override
    public float[] getFloatValuesSV() {
        try (InvocationScope scope = Tracing.getTracer().createScope(ProjectionBlockValSet.class);){
            this.recordReadValues((InvocationRecording)scope, FieldSpec.DataType.FLOAT, true);
            float[] fArray = this._dataBlockCache.getFloatValuesForSVColumn(this._column);
            return fArray;
        }
    }

    @Override
    public double[] getDoubleValuesSV() {
        try (InvocationScope scope = Tracing.getTracer().createScope(ProjectionBlockValSet.class);){
            this.recordReadValues((InvocationRecording)scope, FieldSpec.DataType.DOUBLE, true);
            double[] dArray = this._dataBlockCache.getDoubleValuesForSVColumn(this._column);
            return dArray;
        }
    }

    @Override
    public BigDecimal[] getBigDecimalValuesSV() {
        try (InvocationScope scope = Tracing.getTracer().createScope(ProjectionBlockValSet.class);){
            this.recordReadValues((InvocationRecording)scope, FieldSpec.DataType.BIG_DECIMAL, true);
            BigDecimal[] bigDecimalArray = this._dataBlockCache.getBigDecimalValuesForSVColumn(this._column);
            return bigDecimalArray;
        }
    }

    @Override
    public String[] getStringValuesSV() {
        try (InvocationScope scope = Tracing.getTracer().createScope(ProjectionBlockValSet.class);){
            this.recordReadValues((InvocationRecording)scope, FieldSpec.DataType.STRING, true);
            String[] stringArray = this._dataBlockCache.getStringValuesForSVColumn(this._column);
            return stringArray;
        }
    }

    @Override
    public byte[][] getBytesValuesSV() {
        try (InvocationScope scope = Tracing.getTracer().createScope(ProjectionBlockValSet.class);){
            this.recordReadValues((InvocationRecording)scope, FieldSpec.DataType.BYTES, true);
            byte[][] byArray = this._dataBlockCache.getBytesValuesForSVColumn(this._column);
            return byArray;
        }
    }

    @Override
    public int[][] getDictionaryIdsMV() {
        try (InvocationScope scope = Tracing.getTracer().createScope(ProjectionBlockValSet.class);){
            this.recordReadValues((InvocationRecording)scope, FieldSpec.DataType.INT, false);
            int[][] nArray = this._dataBlockCache.getDictIdsForMVColumn(this._column);
            return nArray;
        }
    }

    @Override
    public int[][] getIntValuesMV() {
        try (InvocationScope scope = Tracing.getTracer().createScope(ProjectionBlockValSet.class);){
            this.recordReadValues((InvocationRecording)scope, FieldSpec.DataType.INT, false);
            int[][] nArray = this._dataBlockCache.getIntValuesForMVColumn(this._column);
            return nArray;
        }
    }

    @Override
    public long[][] getLongValuesMV() {
        try (InvocationScope scope = Tracing.getTracer().createScope(ProjectionBlockValSet.class);){
            this.recordReadValues((InvocationRecording)scope, FieldSpec.DataType.LONG, false);
            long[][] lArray = this._dataBlockCache.getLongValuesForMVColumn(this._column);
            return lArray;
        }
    }

    @Override
    public float[][] getFloatValuesMV() {
        try (InvocationScope scope = Tracing.getTracer().createScope(ProjectionBlockValSet.class);){
            this.recordReadValues((InvocationRecording)scope, FieldSpec.DataType.FLOAT, false);
            float[][] fArray = this._dataBlockCache.getFloatValuesForMVColumn(this._column);
            return fArray;
        }
    }

    @Override
    public double[][] getDoubleValuesMV() {
        try (InvocationScope scope = Tracing.getTracer().createScope(ProjectionBlockValSet.class);){
            this.recordReadValues((InvocationRecording)scope, FieldSpec.DataType.DOUBLE, false);
            double[][] dArray = this._dataBlockCache.getDoubleValuesForMVColumn(this._column);
            return dArray;
        }
    }

    @Override
    public String[][] getStringValuesMV() {
        try (InvocationScope scope = Tracing.getTracer().createScope(ProjectionBlockValSet.class);){
            this.recordReadValues((InvocationRecording)scope, FieldSpec.DataType.STRING, false);
            String[][] stringArray = this._dataBlockCache.getStringValuesForMVColumn(this._column);
            return stringArray;
        }
    }

    @Override
    public int[] getNumMVEntries() {
        return this._dataBlockCache.getNumValuesForMVColumn(this._column);
    }

    private void recordReadValues(InvocationRecording recording, FieldSpec.DataType dataType, boolean singleValue) {
        if (recording.isEnabled()) {
            int numDocs = this._dataBlockCache.getNumDocs();
            recording.setNumDocsScanned(numDocs);
            recording.setColumnName(this._column);
            recording.setOutputDataType(dataType, singleValue);
        }
    }
}

