/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import com.google.common.base.Preconditions;
import com.uber.h3core.LengthUnit;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.common.request.context.predicate.RangePredicate;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.blocks.FilterBlock;
import org.apache.pinot.core.operator.dociditerators.ScanBasedDocIdIterator;
import org.apache.pinot.core.operator.docidsets.BitmapDocIdSet;
import org.apache.pinot.core.operator.docidsets.EmptyDocIdSet;
import org.apache.pinot.core.operator.docidsets.MatchAllDocIdSet;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.core.operator.filter.ExpressionFilterOperator;
import org.apache.pinot.segment.local.utils.GeometrySerializer;
import org.apache.pinot.segment.local.utils.H3Utils;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.index.reader.H3IndexReader;
import org.apache.pinot.spi.utils.BytesUtils;
import org.locationtech.jts.geom.Coordinate;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class H3IndexFilterOperator
extends BaseFilterOperator {
    private static final String EXPLAIN_NAME = "FILTER_H3_INDEX";
    private final IndexSegment _segment;
    private final Predicate _predicate;
    private final int _numDocs;
    private final H3IndexReader _h3IndexReader;
    private final long _h3Id;
    private final double _edgeLength;
    private final double _lowerBound;
    private final double _upperBound;

    public H3IndexFilterOperator(IndexSegment segment, Predicate predicate, int numDocs) {
        Coordinate coordinate;
        this._segment = segment;
        this._predicate = predicate;
        this._numDocs = numDocs;
        List arguments = predicate.getLhs().getFunction().getArguments();
        if (((ExpressionContext)arguments.get(0)).getType() == ExpressionContext.Type.IDENTIFIER) {
            this._h3IndexReader = segment.getDataSource(((ExpressionContext)arguments.get(0)).getIdentifier()).getH3Index();
            coordinate = GeometrySerializer.deserialize((byte[])BytesUtils.toBytes((String)((ExpressionContext)arguments.get(1)).getLiteral())).getCoordinate();
        } else {
            this._h3IndexReader = segment.getDataSource(((ExpressionContext)arguments.get(1)).getIdentifier()).getH3Index();
            coordinate = GeometrySerializer.deserialize((byte[])BytesUtils.toBytes((String)((ExpressionContext)arguments.get(0)).getLiteral())).getCoordinate();
        }
        assert (this._h3IndexReader != null);
        int resolution = this._h3IndexReader.getH3IndexResolution().getLowestResolution();
        this._h3Id = H3Utils.H3_CORE.geoToH3(coordinate.y, coordinate.x, resolution);
        this._edgeLength = H3Utils.H3_CORE.edgeLength(resolution, LengthUnit.m);
        RangePredicate rangePredicate = (RangePredicate)predicate;
        this._lowerBound = !rangePredicate.getLowerBound().equals("*") ? Double.parseDouble(rangePredicate.getLowerBound()) : Double.NaN;
        this._upperBound = !rangePredicate.getUpperBound().equals("*") ? Double.parseDouble(rangePredicate.getUpperBound()) : Double.NaN;
    }

    @Override
    protected FilterBlock getNextBlock() {
        if (this._upperBound < 0.0 || this._lowerBound > this._upperBound) {
            return new FilterBlock(EmptyDocIdSet.getInstance());
        }
        try {
            Set fullMatchH3Ids;
            if (Double.isNaN(this._lowerBound) || this._lowerBound < 0.0) {
                if (Double.isNaN(this._upperBound)) {
                    return new FilterBlock(new MatchAllDocIdSet(this._numDocs));
                }
                List<Long> fullMatchH3Ids2 = this.getAlwaysMatchH3Ids(this._upperBound);
                HashSet<Long> partialMatchH3Ids = new HashSet<Long>(this.getPossibleMatchH3Ids(this._upperBound));
                partialMatchH3Ids.removeAll(fullMatchH3Ids2);
                MutableRoaringBitmap fullMatchDocIds = new MutableRoaringBitmap();
                for (long fullMatchH3Id : fullMatchH3Ids2) {
                    fullMatchDocIds.or(this._h3IndexReader.getDocIds(fullMatchH3Id));
                }
                MutableRoaringBitmap partialMatchDocIds = new MutableRoaringBitmap();
                for (long partialMatchH3Id : partialMatchH3Ids) {
                    partialMatchDocIds.or(this._h3IndexReader.getDocIds(partialMatchH3Id));
                }
                return this.getFilterBlock(fullMatchDocIds, partialMatchDocIds);
            }
            if (Double.isNaN(this._upperBound)) {
                List<Long> alwaysNotMatchH3Ids = this.getAlwaysMatchH3Ids(this._lowerBound);
                HashSet<Long> possibleNotMatchH3Ids = new HashSet<Long>(this.getPossibleMatchH3Ids(this._lowerBound));
                MutableRoaringBitmap fullMatchDocIds = new MutableRoaringBitmap();
                MutableRoaringBitmap partialMatchDocIds = possibleNotMatchH3Ids.iterator();
                while (partialMatchDocIds.hasNext()) {
                    long partialMatchH3Id = (Long)partialMatchDocIds.next();
                    fullMatchDocIds.or(this._h3IndexReader.getDocIds(partialMatchH3Id));
                }
                fullMatchDocIds.flip(0L, (long)this._numDocs);
                possibleNotMatchH3Ids.removeAll(alwaysNotMatchH3Ids);
                partialMatchDocIds = new MutableRoaringBitmap();
                Iterator partialMatchH3Id = possibleNotMatchH3Ids.iterator();
                while (partialMatchH3Id.hasNext()) {
                    long partialMatchH3Id2 = (Long)partialMatchH3Id.next();
                    partialMatchDocIds.or(this._h3IndexReader.getDocIds(partialMatchH3Id2));
                }
                return this.getFilterBlock(fullMatchDocIds, partialMatchDocIds);
            }
            List<Long> lowerAlwaysMatchH3Ids = this.getAlwaysMatchH3Ids(this._lowerBound);
            List<Long> lowerPossibleMatchH3Ids = this.getPossibleMatchH3Ids(this._lowerBound);
            List<Long> upperAlwaysMatchH3Ids = this.getAlwaysMatchH3Ids(this._upperBound);
            List<Long> upperPossibleMatchH3Ids = this.getPossibleMatchH3Ids(this._upperBound);
            if (upperAlwaysMatchH3Ids.size() > lowerPossibleMatchH3Ids.size()) {
                fullMatchH3Ids = new HashSet<Long>(upperAlwaysMatchH3Ids);
                fullMatchH3Ids.removeAll(lowerPossibleMatchH3Ids);
            } else {
                fullMatchH3Ids = Collections.emptySet();
            }
            MutableRoaringBitmap fullMatchDocIds = new MutableRoaringBitmap();
            Iterator iterator = fullMatchH3Ids.iterator();
            while (iterator.hasNext()) {
                long fullMatchH3Id = (Long)iterator.next();
                fullMatchDocIds.or(this._h3IndexReader.getDocIds(fullMatchH3Id));
            }
            HashSet<Long> partialMatchH3Ids = new HashSet<Long>(upperPossibleMatchH3Ids);
            partialMatchH3Ids.removeAll(lowerAlwaysMatchH3Ids);
            partialMatchH3Ids.removeAll(fullMatchH3Ids);
            MutableRoaringBitmap partialMatchDocIds = new MutableRoaringBitmap();
            Iterator iterator2 = partialMatchH3Ids.iterator();
            while (iterator2.hasNext()) {
                long partialMatchH3Id = (Long)iterator2.next();
                partialMatchDocIds.or(this._h3IndexReader.getDocIds(partialMatchH3Id));
            }
            return this.getFilterBlock(fullMatchDocIds, partialMatchDocIds);
        }
        catch (Exception e) {
            return new ExpressionFilterOperator(this._segment, this._predicate, this._numDocs).getNextBlock();
        }
    }

    private List<Long> getAlwaysMatchH3Ids(double distance) {
        int numRings = (int)Math.floor((distance / this._edgeLength - 2.0) / 1.7321);
        return numRings >= 0 ? this.getH3Ids(numRings) : Collections.emptyList();
    }

    private List<Long> getPossibleMatchH3Ids(double distance) {
        int numRings = (int)Math.floor((distance / this._edgeLength + 2.0) / 1.5 + 0.001);
        return this.getH3Ids(numRings);
    }

    private List<Long> getH3Ids(int numRings) {
        Preconditions.checkState((numRings <= 100 ? 1 : 0) != 0, (String)"Expect numRings <= 100, got: %s", (int)numRings);
        return H3Utils.H3_CORE.kRing(this._h3Id, numRings);
    }

    private FilterBlock getFilterBlock(MutableRoaringBitmap fullMatchDocIds, MutableRoaringBitmap partialMatchDocIds) {
        ExpressionFilterOperator expressionFilterOperator = new ExpressionFilterOperator(this._segment, this._predicate, this._numDocs);
        final ScanBasedDocIdIterator docIdIterator = (ScanBasedDocIdIterator)expressionFilterOperator.getNextBlock().getBlockDocIdSet().iterator();
        MutableRoaringBitmap result = docIdIterator.applyAnd((ImmutableRoaringBitmap)partialMatchDocIds);
        result.or((ImmutableRoaringBitmap)fullMatchDocIds);
        return new FilterBlock(new BitmapDocIdSet((ImmutableRoaringBitmap)result, this._numDocs){

            @Override
            public long getNumEntriesScannedInFilter() {
                return docIdIterator.getNumEntriesScanned();
            }
        });
    }

    @Override
    public List<Operator> getChildOperators() {
        return Collections.emptyList();
    }

    @Override
    public String toExplainString() {
        StringBuilder stringBuilder = new StringBuilder(EXPLAIN_NAME).append("(indexLookUp:h3_index");
        stringBuilder.append(",operator:").append(this._predicate.getType());
        stringBuilder.append(",predicate:").append(this._predicate.toString());
        return stringBuilder.append(')').toString();
    }
}

