/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import java.util.Collections;
import java.util.List;
import org.apache.pinot.common.request.context.predicate.JsonMatchPredicate;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.blocks.FilterBlock;
import org.apache.pinot.core.operator.docidsets.BitmapDocIdSet;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.core.operator.filter.BitmapCollection;
import org.apache.pinot.segment.spi.index.reader.JsonIndexReader;
import org.apache.pinot.spi.trace.FilterType;
import org.apache.pinot.spi.trace.InvocationRecording;
import org.apache.pinot.spi.trace.Tracing;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class JsonMatchFilterOperator
extends BaseFilterOperator {
    private static final String EXPLAIN_NAME = "FILTER_JSON_INDEX";
    private final JsonIndexReader _jsonIndex;
    private final int _numDocs;
    private final JsonMatchPredicate _predicate;

    public JsonMatchFilterOperator(JsonIndexReader jsonIndex, JsonMatchPredicate predicate, int numDocs) {
        this._jsonIndex = jsonIndex;
        this._predicate = predicate;
        this._numDocs = numDocs;
    }

    @Override
    protected FilterBlock getNextBlock() {
        MutableRoaringBitmap bitmap = this._jsonIndex.getMatchingDocIds(this._predicate.getValue());
        this.record((ImmutableRoaringBitmap)bitmap);
        return new FilterBlock(new BitmapDocIdSet((ImmutableRoaringBitmap)bitmap, this._numDocs));
    }

    @Override
    public boolean canOptimizeCount() {
        return true;
    }

    @Override
    public int getNumMatchingDocs() {
        return this._jsonIndex.getMatchingDocIds(this._predicate.getValue()).getCardinality();
    }

    @Override
    public boolean canProduceBitmaps() {
        return true;
    }

    @Override
    public BitmapCollection getBitmaps() {
        return new BitmapCollection(this._numDocs, false, new ImmutableRoaringBitmap[]{this._jsonIndex.getMatchingDocIds(this._predicate.getValue())});
    }

    @Override
    public List<Operator> getChildOperators() {
        return Collections.emptyList();
    }

    @Override
    public String toExplainString() {
        StringBuilder stringBuilder = new StringBuilder(EXPLAIN_NAME).append("(indexLookUp:json_index");
        stringBuilder.append(",operator:").append(this._predicate.getType());
        stringBuilder.append(",predicate:").append(this._predicate.toString());
        return stringBuilder.append(')').toString();
    }

    private void record(ImmutableRoaringBitmap bitmap) {
        InvocationRecording recording = Tracing.activeRecording();
        if (recording.isEnabled()) {
            recording.setColumnName(this._predicate.getLhs().getIdentifier());
            recording.setFilter(FilterType.INDEX, this._predicate.getType().name());
            recording.setNumDocsMatchingAfterFilter(bitmap.getCardinality());
        }
    }
}

